#!perl -T

#
# $Id: 6d057ddd6637943b8b6bde19ea56c37944bb8bfd $
#

use Test::Simple tests => 11;

use File::Basename;

use Log::Fine;
use Log::Fine::Handle::Syslog;
use Log::Fine::Levels::Syslog;

use Sys::Syslog qw( :standard :macros );

{

        my $msg =
"This is a test message generated by the Log::Fine unit tests.  Please disregard";

        # get a logger
        my $log = Log::Fine->logger("handlesyslog0");

        ok(ref $log eq "Log::Fine::Logger");
        ok($log->name() =~ /\w\d+$/);

        # add a handle.  Note we use the default formatter.
        my $handle = Log::Fine::Handle::Syslog->new(facility => LOG_USER);

        # do some validation
        ok($handle->isa("Log::Fine::Handle"));
        ok($handle->name() =~ /\w\d+$/);

        # these should be set to their default values
        ok($handle->{mask} == $handle->levelMap()->bitmaskAll());
        ok($handle->{formatter}->isa("Log::Fine::Formatter::Basic"));

        # Syslog-specific attributes
        ok($handle->{ident} eq basename $0);
        ok($handle->{logopts} =~ /pid/);
        ok($handle->{facility} == LOG_USER);

        # write a test message
        $handle->msgWrite(INFO, $msg, 1);

        # Make sure we can't define more than one handle
        eval {
                open STDERR, '>/dev/null';
                my $console =
                    Log::Fine::Handle::Syslog->new(facility => LOG_LOCAL0,
                                                   ident    => "badhandle");
                close STDERR;
        };

        ok(defined $@);
        ok($@ =~ /One and _only_ one/);

}
