#!perl -w
$|++;

use strict;
use Test::More tests => 373;

use lib "./t";
use _nrr_test_util;

use lib "./blib/lib";
use Number::Range::Regex;

my $r;

$r = rangespec( '3..15', {base => 8} );
ok($r);
ok( "2"  !~ /^$r$/ );
ok( /^$r$/ ) for qw ( 3 4 5 6 7 10 11 12 13 14 15 );
ok( !/^$r$/ ) for qw ( 8 9 );
ok( "16" !~ /^$r$/ );

$r = rangespec( '3..10231', {base => 4} );
ok( "2" !~ /^$r$/ );
ok( "3" =~ /^$r$/ );
ok( /^$r$/ ) for qw ( 10 11 12 13 20 21 22 23 30 31 32 33 );
ok( "40" !~ /^$r$/ );
ok( /^$r$/ ) for qw ( 100 101 102 103 110 120 130 131 132 133
                      200 201 202 203 210 220 230 231 232 233
                      300 301 302 303 310 320 330 331 332 333 );
ok( "400" !~ /^$r$/ );
ok( /^$r$/ ) for qw ( 1000 1001 1002 1003 1010 1100 1333
                      2000 2001 2002 2003 2010 2100 2333
                      3000 3001 3002 3003 3010 3100 3333 );
ok( "4000" !~ /^$r$/ );
ok( /^$r$/ ) for qw ( 10000 10001 10002 10003 10010 10011 10012 10013
                      10020 10021 10022 10023 10030 10031 10032 10033
                      10100 10101 10102 10103 10110 10111 10112 10113
                      10120 10121 10122 10123 10130 10131 10132 10133
                      10200 10201 10202 10203 10210 10211 10212 10213
                      10220 10221 10222 10223 10230 10231 );
ok( !/^$r$/ ) for qw ( 10232 10300 11000 20000 );

$r = rangespec( '1..101010', {base => 2} );
ok( /^$r$/ ) for qw ( 1 10 11 100 101 110 111
                      1000 1001 1010 1011 1100 1101 1110 1111
                      10000 10001 10010 10011 10100 10101 10110 10111
                      11000 11001 11010 11011 11100 11101 11110 11111
                      100000 100001 100010 100011 100100 100101 100110 100111
                      101000 101001 101010 );
ok( !/^$r$/ ) for qw ( 0 101011 101110 111010 101100 );
ok( !/^$r$/ ) for qw ( 101020 102010 201010 );
ok( !/^$r$/ ) for qw ( 2 20 200 2000 20000 200000 );

$r = rangespec( '3..b5', {base => 16} );
ok( /^$r$/ ) for qw ( 3 4 5 6 7 8 9 a b c d e f
                      10 11 12 13 14 15 16 17 18 19 1a 1b 1c 1d 1e 1f
                      20 21 22 23 24 25 26 27 28 29 2a 2b 2c 2d 2e 2f
                      30 31 32 33 34 35 36 37 38 39 3a 3b 3c 3d 3e 3f
                      40 41 42 43 44 45 46 47 48 49 4a 4b 4c 4d 4e 4f
                      50 51 52 53 54 55 56 57 58 59 5a 5b 5c 5d 5e 5f
                      60 61 62 63 64 65 66 67 68 69 6a 6b 6c 6d 6e 6f
                      70 71 72 73 74 75 76 77 78 79 7a 7b 7c 7d 7e 7f
                      80 81 82 83 84 85 86 87 88 89 8a 8b 8c 8d 8e 8f
                      90 91 92 93 94 95 96 97 98 99 9a 9b 9c 9d 9e 9f
                      a0 a1 a2 a3 a4 a5 a6 a7 a8 a9 aa ab ac ad ae af
                      b0 b1 b2 b3 b4 b5 );
ok( !/^$r$/ ) for qw ( 2 g b6 c0 );

