#!/usr/bin/env perl
use lib "../lib/";
use Object::Pad;
use CAD::OpenSCAD;
use CAD::OpenSCAD::Math;
use CAD::OpenSCAD::Loft;
use Test::Simple tests=>7;

my $math=new CAD::OpenSCAD::Math;
my $scad;my $item;my $args;
my $divisions=10;
my $radius=30;

ok($scad=new OpenSCAD,"Creating a OpenSCAD object "              );
ok($loft=new CAD::OpenSCAD::Loft(scad=>$scad),"A new Loft object");
ok($args=$loft->spheroid(undef,$divisions,$radius), "A new set of scadItem Parameters");
ok($scad->item(new scadItem(name=>"head",function=>"polyhedron",args=>$args)),"create a Polyhedron scadItem");
ok($scad->item("head")->scale([12,17],[2,1,2]),"scale part of polyhedron");
ok($scad->item("head")->remove([24,25])->{index}==14,"remove points of polyhedron");
ok($scad->item("head")->shear([26..28],[0,5,0]),"shear points of polyhedron");
