/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasLemma;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.lexparser.BiLexPCFGParser;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BoundaryRemover;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.EvalbFormatWriter;
import edu.stanford.nlp.parser.lexparser.ExhaustiveDependencyParser;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.parser.lexparser.FastFactoredParser;
import edu.stanford.nlp.parser.lexparser.HTKLatticeReader;
import edu.stanford.nlp.parser.lexparser.IterativeCKYPCFGParser;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.NodePruner;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParserConstraint;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.lexparser.TwinScorer;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.parser.metrics.BestOfTopKEval;
import edu.stanford.nlp.parser.metrics.Evalb;
import edu.stanford.nlp.parser.metrics.EvalbByCat;
import edu.stanford.nlp.parser.metrics.LeafAncestorEval;
import edu.stanford.nlp.parser.metrics.TaggingEval;
import edu.stanford.nlp.parser.metrics.UnlabeledAttachmentEval;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.trees.LeftHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.DeltaIndex;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LexicalizedParserQuery {
    private final Options op;
    private final TreeTransformer debinarizer;
    private final ExhaustivePCFGParser pparser;
    private final ExhaustiveDependencyParser dparser;
    private final KBestViterbiParser bparser;
    private final boolean fallbackToPCFG;
    private final TreeTransformer subcategoryStripper;
    private boolean parseSucceeded = false;
    private List<String> originalWords = null;
    private List<String> originalLemmas = null;
    protected Function<List<? extends HasWord>, ArrayList<TaggedWord>> tagger;

    LexicalizedParserQuery(LexicalizedParser parser) {
        this.op = parser.getOp();
        BinaryGrammar bg = parser.bg;
        UnaryGrammar ug = parser.ug;
        Lexicon lex = parser.lex;
        DependencyGrammar dg = parser.dg;
        Index<String> stateIndex = parser.stateIndex;
        DeltaIndex<String> wordIndex = new DeltaIndex<String>(parser.wordIndex);
        Index<String> tagIndex = parser.tagIndex;
        this.debinarizer = new Debinarizer(this.op.forceCNF);
        this.pparser = this.op.doPCFG ? (this.op.testOptions.iterativeCKY ? new IterativeCKYPCFGParser(bg, ug, lex, this.op, stateIndex, wordIndex, tagIndex) : new ExhaustivePCFGParser(bg, ug, lex, this.op, stateIndex, wordIndex, tagIndex)) : null;
        if (this.op.doDep) {
            dg.setLexicon(lex);
            this.dparser = !this.op.testOptions.useFastFactored ? new ExhaustiveDependencyParser(dg, lex, this.op, wordIndex, tagIndex) : null;
        } else {
            this.dparser = null;
        }
        if (this.op.doDep && this.op.doPCFG) {
            if (this.op.testOptions.useFastFactored) {
                MLEDependencyGrammar mledg = (MLEDependencyGrammar)dg;
                int numToFind = 1;
                if (this.op.testOptions.printFactoredKGood > 0) {
                    numToFind = this.op.testOptions.printFactoredKGood;
                }
                this.bparser = new FastFactoredParser(this.pparser, mledg, this.op, numToFind, wordIndex, tagIndex);
            } else {
                TwinScorer scorer = new TwinScorer(this.pparser, this.dparser);
                this.bparser = this.op.testOptions.useN5 ? new BiLexPCFGParser.N5BiLexPCFGParser(scorer, this.pparser, this.dparser, bg, ug, dg, lex, this.op, stateIndex, wordIndex, tagIndex) : new BiLexPCFGParser(scorer, this.pparser, this.dparser, bg, ug, dg, lex, this.op, stateIndex, wordIndex, tagIndex);
            }
        } else {
            this.bparser = null;
        }
        this.fallbackToPCFG = true;
        this.subcategoryStripper = this.op.tlpParams.subcategoryStripper();
    }

    public void setConstraints(List<ParserConstraint> constraints) {
        if (this.pparser != null) {
            this.pparser.setConstraints(constraints);
        }
    }

    public boolean parse(List<? extends HasWord> sentence) {
        int length = sentence.size();
        if (length == 0) {
            throw new UnsupportedOperationException("Can't parse a zero-length sentence!");
        }
        if (this.op.wordFunction != null) {
            this.originalWords = new ArrayList<String>(sentence.size());
            this.originalLemmas = new ArrayList<String>(sentence.size());
            for (HasWord hasWord : sentence) {
                this.originalWords.add(hasWord.word());
                if (hasWord instanceof HasLemma) {
                    this.originalLemmas.add(((HasLemma)((Object)hasWord)).lemma());
                } else {
                    this.originalLemmas.add(null);
                }
                hasWord.setWord(this.op.wordFunction.apply(hasWord.word()));
            }
        }
        ArrayList<HasWord> sentenceB = new ArrayList<HasWord>(sentence);
        if (this.op.testOptions.addMissingFinalPunctuation) {
            this.addSentenceFinalPunctIfNeeded(sentenceB, length);
        }
        if (length > this.op.testOptions.maxLength) {
            throw new UnsupportedOperationException("Sentence too long: length " + length);
        }
        TreePrint treePrint = this.getTreePrint();
        PrintWriter pwOut = this.op.tlpParams.pw();
        this.parseSucceeded = false;
        if (sentence.get(0) instanceof CoreLabel) {
            CoreLabel boundary = new CoreLabel();
            boundary.setWord(".$.");
            boundary.setValue(".$.");
            boundary.setTag(".$$.");
            boundary.setIndex(sentence.size() + 1);
            sentenceB.add(boundary);
        } else {
            sentenceB.add(new TaggedWord(".$.", ".$$."));
        }
        if (this.op.doPCFG) {
            if (!this.pparser.parse(sentenceB)) {
                this.restoreOriginalWords(sentence);
                return this.parseSucceeded;
            }
            if (this.op.testOptions.verbose) {
                pwOut.println("PParser output");
                treePrint.printTree(this.getBestPCFGParse(false), pwOut);
            }
        }
        if (this.op.doDep && !this.op.testOptions.useFastFactored) {
            if (!this.dparser.parse(sentenceB)) {
                this.restoreOriginalWords(sentence);
                return this.parseSucceeded;
            }
            if (this.op.testOptions.verbose) {
                pwOut.println("DParser output");
                treePrint.printTree(this.dparser.getBestParse(), pwOut);
            }
        }
        if (this.op.doPCFG && this.op.doDep) {
            if (!this.bparser.parse(sentenceB)) {
                this.restoreOriginalWords(sentence);
                return this.parseSucceeded;
            }
            this.parseSucceeded = true;
        }
        this.restoreOriginalWords(sentence);
        return true;
    }

    private void restoreOriginalWords(List<? extends HasWord> sentence) {
        if (this.originalWords == null) {
            return;
        }
        if (sentence.size() != this.originalWords.size()) {
            return;
        }
        if (this.originalWords.size() != this.originalLemmas.size()) {
            throw new AssertionError((Object)"originalWords and originalLemmas of different sizes");
        }
        Iterator<String> wordsIterator = this.originalWords.iterator();
        Iterator<String> lemmasIterator = this.originalLemmas.iterator();
        for (HasWord hasWord : sentence) {
            hasWord.setWord(wordsIterator.next());
            String lemma = lemmasIterator.next();
            if (!(hasWord instanceof HasLemma) || lemma == null) continue;
            ((HasLemma)((Object)hasWord)).setLemma(lemma);
        }
    }

    private void restoreOriginalWords(Tree tree) {
        if (this.originalWords == null || tree == null) {
            return;
        }
        List leaves = tree.getLeaves();
        if (leaves.size() != this.originalWords.size()) {
            return;
        }
        if (this.originalWords.size() != this.originalLemmas.size()) {
            throw new AssertionError((Object)"originalWords and originalLemmas of different sizes");
        }
        Iterator<String> wordsIterator = this.originalWords.iterator();
        Iterator<String> lemmasIterator = this.originalLemmas.iterator();
        for (Tree leaf : leaves) {
            leaf.setValue(wordsIterator.next());
            String lemma = lemmasIterator.next();
            if (!(leaf.label() instanceof HasLemma) || lemma == null) continue;
            ((HasLemma)((Object)leaf.label())).setLemma(lemma);
        }
    }

    boolean parse(HTKLatticeReader lr) {
        TreePrint treePrint = this.getTreePrint();
        PrintWriter pwOut = this.op.tlpParams.pw();
        this.parseSucceeded = false;
        if (lr.getNumStates() > this.op.testOptions.maxLength + 1) {
            throw new UnsupportedOperationException("Lattice too big: " + lr.getNumStates());
        }
        if (this.op.doPCFG) {
            if (!this.pparser.parse(lr)) {
                return this.parseSucceeded;
            }
            if (this.op.testOptions.verbose) {
                pwOut.println("PParser output");
                treePrint.printTree(this.getBestPCFGParse(false), pwOut);
            }
        }
        return true;
    }

    public Tree getBestParse() {
        return this.getBestParse(true);
    }

    Tree getBestParse(boolean stripSubcat) {
        if (this.bparser != null && this.parseSucceeded) {
            Tree binaryTree = this.bparser.getBestParse();
            Tree tree = this.debinarizer.transformTree(binaryTree);
            if (this.op.nodePrune) {
                NodePruner np = new NodePruner(this.pparser, this.debinarizer);
                tree = np.prune(tree);
            }
            if (stripSubcat) {
                tree = this.subcategoryStripper.transformTree(tree);
            }
            this.restoreOriginalWords(tree);
            return tree;
        }
        if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
            return this.getBestPCFGParse();
        }
        if (this.dparser != null && this.dparser.hasParse()) {
            return this.getBestDependencyParse(true);
        }
        throw new NoSuchElementException();
    }

    public List<ScoredObject<Tree>> getKGoodFactoredParses(int k) {
        if (this.bparser == null) {
            return null;
        }
        List<ScoredObject<Tree>> binaryTrees = this.bparser.getKGoodParses(k);
        if (binaryTrees == null) {
            return null;
        }
        ArrayList<ScoredObject<Tree>> trees = new ArrayList<ScoredObject<Tree>>(k);
        for (ScoredObject<Tree> tp : binaryTrees) {
            Tree t = this.debinarizer.transformTree(tp.object());
            t = this.subcategoryStripper.transformTree(t);
            this.restoreOriginalWords(t);
            trees.add(new ScoredObject<Tree>(t, tp.score()));
        }
        return trees;
    }

    public List<ScoredObject<Tree>> getKBestPCFGParses(int k) {
        if (this.pparser == null) {
            return null;
        }
        List<ScoredObject<Tree>> binaryTrees = this.pparser.getKBestParses(k);
        if (binaryTrees == null) {
            return null;
        }
        ArrayList<ScoredObject<Tree>> trees = new ArrayList<ScoredObject<Tree>>(k);
        for (ScoredObject<Tree> p : binaryTrees) {
            Tree t = this.debinarizer.transformTree(p.object());
            t = this.subcategoryStripper.transformTree(t);
            this.restoreOriginalWords(t);
            trees.add(new ScoredObject<Tree>(t, p.score()));
        }
        return trees;
    }

    Tree getBestPCFGParse() {
        return this.getBestPCFGParse(true);
    }

    Tree getBestPCFGParse(boolean stripSubcategories) {
        if (this.pparser == null) {
            return null;
        }
        Tree binaryTree = this.pparser.getBestParse();
        if (binaryTree == null) {
            return null;
        }
        Tree t = this.debinarizer.transformTree(binaryTree);
        if (stripSubcategories) {
            t = this.subcategoryStripper.transformTree(t);
        }
        this.restoreOriginalWords(t);
        return t;
    }

    public double getPCFGScore() {
        return this.pparser.getBestScore();
    }

    double getPCFGScore(String goalStr) {
        return this.pparser.getBestScore(goalStr);
    }

    void parsePCFG(List<? extends HasWord> sentence) {
        this.pparser.parse(sentence);
    }

    Tree getBestDependencyParse() {
        return this.getBestDependencyParse(false);
    }

    Tree getBestDependencyParse(boolean debinarize) {
        Tree t;
        Tree tree = t = this.dparser != null ? this.dparser.getBestParse() : null;
        if (debinarize && t != null) {
            t = this.debinarizer.transformTree(t);
        }
        this.restoreOriginalWords(t);
        return t;
    }

    public double testOnTreebank(Treebank testTreebank) {
        System.err.println("Testing on treebank");
        Timing treebankTotalTtimer = new Timing();
        TreePrint treePrint = this.getTreePrint();
        TreebankLangParserParams tlpParams = this.op.tlpParams;
        TreebankLanguagePack tlp = this.op.langpack();
        PrintWriter pwOut = tlpParams.pw();
        PrintWriter pwErr = tlpParams.pw(System.err);
        if (this.op.testOptions.verbose) {
            pwErr.print("Testing ");
            pwErr.println(testTreebank.textualSummary(tlp));
        }
        if (this.op.testOptions.evalb) {
            EvalbFormatWriter.initEVALBfiles(tlpParams);
        }
        PrintWriter pwo = null;
        if (this.op.testOptions.writeOutputFiles) {
            String fname = this.op.testOptions.outputFilesPrefix + "." + this.op.testOptions.outputFilesExtension;
            try {
                pwo = this.op.tlpParams.pw(new FileOutputStream(fname));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        PrintWriter statsPwo = null;
        if (this.op.testOptions.outputkBestEquivocation != null) {
            try {
                statsPwo = this.op.tlpParams.pw(new FileOutputStream(this.op.testOptions.outputkBestEquivocation));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        TreeTransformer tc = tlpParams.collinizer();
        BoundaryRemover br = new BoundaryRemover();
        boolean runningAverages = Boolean.parseBoolean(this.op.testOptions.evals.getProperty("runningAverages"));
        boolean summary = Boolean.parseBoolean(this.op.testOptions.evals.getProperty("summary"));
        boolean tsv = Boolean.parseBoolean(this.op.testOptions.evals.getProperty("tsv"));
        tlpParams.setupForEval();
        ArrayList<BestOfTopKEval> topKEvals = new ArrayList<BestOfTopKEval>();
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgTopK"))) {
            topKEvals.add(new BestOfTopKEval(new Evalb("pcfg top k comparisons", false), new Evalb("pcfg top k LP/LR", runningAverages)));
        }
        Evalb pcfgLB = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgLB"))) {
            pcfgLB = new Evalb("pcfg LP/LR", runningAverages);
        }
        LeafAncestorEval pcfgLA = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgLA"))) {
            pcfgLA = new LeafAncestorEval("pcfg LeafAncestor");
        }
        Evalb.CBEval pcfgCB = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgCB"))) {
            pcfgCB = new Evalb.CBEval("pcfg CB", runningAverages);
        }
        UnlabeledAttachmentEval pcfgDA = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgDA"))) {
            pcfgDA = new UnlabeledAttachmentEval("pcfg DA", runningAverages, tlp.headFinder());
        }
        TaggingEval pcfgTA = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgTA"))) {
            pcfgTA = new TaggingEval("pcfg Tag", runningAverages, this.pparser.lex);
        }
        UnlabeledAttachmentEval depDA = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("depDA"))) {
            depDA = new UnlabeledAttachmentEval("dep DA", runningAverages, null, tlp.punctuationWordRejectFilter());
        }
        TaggingEval depTA = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("depTA"))) {
            depTA = new TaggingEval("dep Tag", runningAverages, this.pparser.lex);
        }
        Evalb factLB = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("factLB"))) {
            factLB = new Evalb("factor LP/LR", runningAverages);
        }
        LeafAncestorEval factLA = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("factLA"))) {
            factLA = new LeafAncestorEval("factor LeafAncestor");
        }
        Evalb.CBEval factCB = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("factCB"))) {
            factCB = new Evalb.CBEval("fact CB", runningAverages);
        }
        UnlabeledAttachmentEval factDA = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("factDA"))) {
            factDA = new UnlabeledAttachmentEval("factor DA", runningAverages, null);
        }
        TaggingEval factTA = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("factTA"))) {
            factTA = this.op.doPCFG ? new TaggingEval("factor Tag", runningAverages, this.pparser.lex) : new TaggingEval("factor Tag", runningAverages, this.pparser.lex);
        }
        AbstractEval.RuleErrorEval pcfgRUO = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgRUO"))) {
            pcfgRUO = new AbstractEval.RuleErrorEval("pcfg Rule under/over");
        }
        AbstractEval.CatErrorEval pcfgCUO = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgCUO"))) {
            pcfgCUO = new AbstractEval.CatErrorEval("pcfg Category under/over");
        }
        EvalbByCat pcfgCatE = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgCatE"))) {
            pcfgCatE = new EvalbByCat("pcfg Category Eval", runningAverages);
        }
        AbstractEval.ScoreEval pcfgLL = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgLL"))) {
            pcfgLL = new AbstractEval.ScoreEval("pcfgLL", runningAverages);
        }
        AbstractEval.ScoreEval depLL = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("depLL"))) {
            depLL = new AbstractEval.ScoreEval("depLL", runningAverages);
        }
        AbstractEval.ScoreEval factLL = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("factLL"))) {
            factLL = new AbstractEval.ScoreEval("factLL", runningAverages);
        }
        Evalb kGoodLB = new Evalb("kGood LP/LR", false);
        TreeAnnotatorAndBinarizer binarizerOnly = !this.op.trainOptions.leftToRight ? new TreeAnnotatorAndBinarizer(tlpParams, this.op.forceCNF, false, false, this.op) : new TreeAnnotatorAndBinarizer(tlpParams.headFinder(), new LeftHeadFinder(), tlpParams, this.op.forceCNF, false, false, this.op);
        if (this.op.testOptions.preTag) {
            try {
                Class[] argsClass = new Class[]{String.class};
                Object[] arguments = new Object[]{this.op.testOptions.taggerSerializedFile};
                System.err.printf("Loading tagger from serialized file %s ...\n", this.op.testOptions.taggerSerializedFile);
                this.tagger = (Function)Class.forName("edu.stanford.nlp.tagger.maxent.MaxentTagger").getConstructor(argsClass).newInstance(arguments);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int numSkippedEvals = 0;
        boolean saidMemMessage = false;
        Timing timer = new Timing();
        for (Tree goldTree : testTreebank) {
            List<ScoredObject<Tree>> kbestPCFGTrees;
            Tree tree;
            ArrayList<? extends HasWord> sentence;
            block131: {
                sentence = this.getInputSentence(goldTree);
                timer.start();
                pwErr.println("Parsing [len. " + sentence.size() + "]: " + Sentence.listToString(sentence));
                tree = null;
                kbestPCFGTrees = null;
                int kbestPCFG = 0;
                if (topKEvals.size() > 0) {
                    kbestPCFG = this.op.testOptions.evalPCFGkBest;
                }
                if (this.op.testOptions.printPCFGkBest > 0) {
                    kbestPCFG = Math.max(kbestPCFG, this.op.testOptions.printPCFGkBest);
                }
                try {
                    if (!this.parse(sentence)) {
                        pwErr.print("Sentence couldn't be parsed by grammar.");
                        if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
                            pwErr.println("... falling back to PCFG parse.");
                            tree = this.getBestPCFGParse();
                            if (kbestPCFG > 0) {
                                kbestPCFGTrees = this.getKBestPCFGParses(kbestPCFG);
                            }
                        } else {
                            pwErr.println();
                        }
                        break block131;
                    }
                    tree = this.getBestParse();
                    if (kbestPCFG > 0) {
                        kbestPCFGTrees = this.getKBestPCFGParses(kbestPCFG);
                    }
                    if (this.bparser == null) break block131;
                    pwErr.println("FactoredParser parse score is " + this.bparser.getBestScore());
                }
                catch (OutOfMemoryError e) {
                    if (this.op.testOptions.maxLength != 559038737) {
                        pwErr.print("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH ");
                        pwErr.println(this.op.testOptions.maxLength);
                        throw e;
                    }
                    if (!saidMemMessage) {
                        LexicalizedParserQuery.printOutOfMemory(pwErr);
                        saidMemMessage = true;
                    }
                    if (this.pparser.hasParse() && this.fallbackToPCFG) {
                        try {
                            String what = "dependency";
                            if (this.dparser.hasParse()) {
                                what = "factored";
                            }
                            pwErr.println("Sentence too long for " + what + " parser.  Falling back to PCFG parse...");
                            tree = this.getBestPCFGParse();
                            if (kbestPCFG > 0) {
                                kbestPCFGTrees = this.getKBestPCFGParses(kbestPCFG);
                            }
                        }
                        catch (OutOfMemoryError oome) {
                            oome.printStackTrace();
                            pwErr.println("No memory to gather PCFG parse. Skipping...");
                            this.pparser.nudgeDownArraySize();
                        }
                    } else {
                        pwErr.println("Sentence has no parse using PCFG grammar (or no PCFG fallback).  Skipping...");
                    }
                    pwErr.println();
                }
                catch (UnsupportedOperationException uoe) {
                    pwErr.println("Sentence too long (or zero words).");
                    if (pwo == null) continue;
                    pwo.println("(())");
                    continue;
                }
            }
            if (this.op.testOptions.verbose) {
                pwOut.println("ComboParser best");
                Tree ot = tree;
                if (ot != null && !tlpParams.treebankLanguagePack().isStartSymbol(ot.value())) {
                    ot = ot.treeFactory().newTreeNode(tlpParams.treebankLanguagePack().startSymbol(), Collections.singletonList(ot));
                }
                treePrint.printTree(ot, pwOut);
            } else {
                treePrint.printTree(tree, pwOut);
            }
            if (tree != null) {
                Tree tbtr;
                Tree transGoldTree;
                List<ScoredObject<Tree>> trees;
                if (this.op.testOptions.printAllBestParses) {
                    List<ScoredObject<Tree>> parses = this.pparser.getBestParses();
                    int sz = parses.size();
                    if (sz > 1) {
                        pwOut.println("There were " + sz + " best PCFG parses with score " + parses.get(0).score() + '.');
                        Tree transGoldTree2 = tc.transformTree(goldTree);
                        int iii = 0;
                        for (ScoredObject<Tree> sot : parses) {
                            Tree tb = sot.object();
                            Tree tbd = this.debinarizer.transformTree(tb);
                            tbd = this.subcategoryStripper.transformTree(tbd);
                            this.restoreOriginalWords(tbd);
                            pwOut.println("PCFG Parse #" + ++iii + " with score " + tbd.score());
                            tbd.pennPrint(pwOut);
                            Tree tbtr2 = tc.transformTree(tbd);
                            ((AbstractEval)kGoodLB).evaluate(tbtr2, transGoldTree2, pwErr);
                        }
                    }
                } else if (this.op.testOptions.printPCFGkBest > 0 && this.op.testOptions.outputkBestEquivocation == null) {
                    trees = kbestPCFGTrees.subList(0, this.op.testOptions.printPCFGkBest);
                    transGoldTree = tc.transformTree(goldTree);
                    int i = 0;
                    for (ScoredObject<Tree> tp : trees) {
                        pwOut.println("PCFG Parse #" + ++i + " with score " + tp.score());
                        Tree tbd = tp.object();
                        tbd.pennPrint(pwOut);
                        tbtr = tc.transformTree(tbd);
                        ((AbstractEval)kGoodLB).evaluate(tbtr, transGoldTree, pwErr);
                    }
                } else if (this.op.testOptions.printFactoredKGood > 0 && this.bparser.hasParse()) {
                    trees = this.getKGoodFactoredParses(this.op.testOptions.printFactoredKGood);
                    transGoldTree = tc.transformTree(goldTree);
                    int ii = 0;
                    for (ScoredObject<Tree> tp : trees) {
                        pwOut.println("Factored Parse #" + ++ii + " with score " + tp.score());
                        Tree tbd = tp.object();
                        tbd.pennPrint(pwOut);
                        tbtr = tc.transformTree(tbd);
                        ((AbstractEval)kGoodLB).evaluate(tbtr, transGoldTree, pwOut);
                    }
                } else if (pwo != null) {
                    pwo.println(tree.toString());
                }
                if (this.op.testOptions.outputkBestEquivocation != null && this.op.testOptions.printPCFGkBest > 0) {
                    trees = kbestPCFGTrees.subList(0, this.op.testOptions.printPCFGkBest);
                    double[] logScores = new double[trees.size()];
                    int treeId = 0;
                    for (ScoredObject<Tree> kBestTree : trees) {
                        logScores[treeId++] = kBestTree.score();
                    }
                    double entropy = 0.0;
                    double denom = ArrayMath.logSum(logScores);
                    for (double logScore : logScores) {
                        double logPr = logScore - denom;
                        entropy += Math.exp(logPr) * (logPr / Math.log(2.0));
                    }
                    statsPwo.printf("%f\t%d\t%d\n", entropy *= -1.0, trees.size(), sentence.size());
                }
            }
            if (tree != null) {
                Tree treeDep;
                Tree treePCFG;
                Tree transGoldTree;
                tree = this.subcategoryStripper.transformTree(tree);
                Tree treeFact = tc.transformTree(tree);
                if (this.op.testOptions.verbose) {
                    pwOut.println("Correct parse");
                    treePrint.printTree(goldTree, pwOut);
                }
                if ((transGoldTree = tc.transformTree(goldTree)) != null) {
                    transGoldTree = this.subcategoryStripper.transformTree(transGoldTree);
                }
                if (transGoldTree == null) {
                    pwErr.println("Couldn't transform gold tree for evaluation, skipping eval. Gold tree was:");
                    goldTree.pennPrint(pwErr);
                    ++numSkippedEvals;
                    continue;
                }
                if (treeFact == null) {
                    pwErr.println("Couldn't transform hypothesis tree for evaluation, skipping eval. Tree was:");
                    tree.pennPrint(pwErr);
                    ++numSkippedEvals;
                    continue;
                }
                if (treeFact.yield().size() != transGoldTree.yield().size()) {
                    ArrayList<Label> fYield = treeFact.yield();
                    ArrayList<Label> gYield = transGoldTree.yield();
                    pwErr.println("WARNING: Evaluation could not be performed due to guess/gold yield mismatch.");
                    pwErr.println("  sizes: g: " + gYield.size() + " p: " + fYield.size());
                    pwErr.println("  g: " + Sentence.listToString(gYield, true));
                    pwErr.println("  p: " + Sentence.listToString(gYield, true));
                    ++numSkippedEvals;
                    continue;
                }
                if (topKEvals.size() > 0) {
                    ArrayList<Tree> transGuesses = new ArrayList<Tree>();
                    int kbest = Math.min(this.op.testOptions.evalPCFGkBest, kbestPCFGTrees.size());
                    for (ScoredObject<Tree> guess : kbestPCFGTrees.subList(0, kbest)) {
                        transGuesses.add(tc.transformTree(guess.object()));
                    }
                    for (BestOfTopKEval eval : topKEvals) {
                        eval.evaluate(transGuesses, transGoldTree, pwErr);
                    }
                }
                if ((treePCFG = this.getBestPCFGParse()) != null) {
                    Tree treePCFGeval = tc.transformTree(treePCFG);
                    if (pcfgLB != null) {
                        ((AbstractEval)pcfgLB).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgLA != null) {
                        pcfgLA.evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgCB != null) {
                        ((AbstractEval)pcfgCB).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgDA != null) {
                        treePCFGeval.indexLeaves(true);
                        transGoldTree.indexLeaves(true);
                        ((AbstractEval)pcfgDA).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgTA != null) {
                        ((AbstractEval)pcfgTA).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgLL != null && this.pparser != null) {
                        pcfgLL.recordScore(this.pparser, pwErr);
                    }
                    if (pcfgRUO != null) {
                        ((AbstractEval)pcfgRUO).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgCUO != null) {
                        ((AbstractEval)pcfgCUO).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgCatE != null) {
                        ((AbstractEval)pcfgCatE).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                }
                if ((treeDep = this.getBestDependencyParse()) != null) {
                    Tree goldTreeB = binarizerOnly.transformTree(goldTree);
                    Tree goldTreeEval = goldTree.deepCopy();
                    goldTreeEval.indexLeaves(true);
                    goldTreeEval.percolateHeads(tlp.headFinder());
                    Tree depDAEval = this.getBestDependencyParse(true);
                    depDAEval.indexLeaves(true);
                    depDAEval.percolateHeadIndices();
                    if (depDA != null) {
                        ((AbstractEval)depDA).evaluate(depDAEval, goldTreeEval, pwErr);
                    }
                    if (depTA != null) {
                        Tree undoneTree = this.debinarizer.transformTree(treeDep);
                        undoneTree = this.subcategoryStripper.transformTree(undoneTree);
                        this.restoreOriginalWords(undoneTree);
                        ((AbstractEval)depTA).evaluate(undoneTree, goldTree, pwErr);
                    }
                    if (depLL != null && this.dparser != null) {
                        depLL.recordScore(this.dparser, pwErr);
                    }
                    Tree factTreeB = this.bparser != null && this.parseSucceeded ? this.bparser.getBestParse() : treeDep;
                    if (factDA != null) {
                        ((AbstractEval)factDA).evaluate(factTreeB, goldTreeB, pwErr);
                    }
                }
                if (factLB != null) {
                    ((AbstractEval)factLB).evaluate(treeFact, transGoldTree, pwErr);
                }
                if (factLA != null) {
                    factLA.evaluate(treeFact, transGoldTree, pwErr);
                }
                if (factTA != null) {
                    ((AbstractEval)factTA).evaluate(tree, br.transformTree(goldTree), pwErr);
                }
                if (factLL != null && this.bparser != null) {
                    factLL.recordScore(this.bparser, pwErr);
                }
                if (factCB != null) {
                    ((AbstractEval)factCB).evaluate(treeFact, transGoldTree, pwErr);
                }
                if (this.op.testOptions.evalb) {
                    LexicalizedParserQuery.nanScores(tree);
                    EvalbFormatWriter.writeEVALBline(treeFact, transGoldTree);
                }
            }
            pwErr.println();
        }
        treebankTotalTtimer.done("Testing on treebank");
        if (saidMemMessage) {
            LexicalizedParserQuery.printOutOfMemory(pwErr);
        }
        if (this.op.testOptions.evalb) {
            EvalbFormatWriter.closeEVALBfiles();
        }
        if (numSkippedEvals != 0) {
            pwOut.printf("Unable to evaluate %d parser hypotheses due to yield mismatch\n", numSkippedEvals);
        }
        if (summary) {
            if (pcfgLB != null) {
                pcfgLB.display(false, pwErr);
            }
            if (pcfgLA != null) {
                pcfgLA.display(false, pwErr);
            }
            if (pcfgCB != null) {
                ((AbstractEval)pcfgCB).display(false, pwErr);
            }
            if (pcfgDA != null) {
                pcfgDA.display(false, pwErr);
            }
            if (pcfgTA != null) {
                ((AbstractEval)pcfgTA).display(false, pwErr);
            }
            if (pcfgLL != null && this.pparser != null) {
                pcfgLL.display(false, pwErr);
            }
            if (depDA != null) {
                depDA.display(false, pwErr);
            }
            if (depTA != null) {
                ((AbstractEval)depTA).display(false, pwErr);
            }
            if (depLL != null && this.dparser != null) {
                depLL.display(false, pwErr);
            }
            if (factLB != null) {
                factLB.display(false, pwErr);
            }
            if (factLA != null) {
                factLA.display(false, pwErr);
            }
            if (factCB != null) {
                ((AbstractEval)factCB).display(false, pwErr);
            }
            if (factDA != null) {
                factDA.display(false, pwErr);
            }
            if (factTA != null) {
                ((AbstractEval)factTA).display(false, pwErr);
            }
            if (factLL != null && this.bparser != null) {
                factLL.display(false, pwErr);
            }
            if (pcfgCatE != null) {
                ((AbstractEval)pcfgCatE).display(false, pwErr);
            }
            for (BestOfTopKEval eval : topKEvals) {
                eval.display(false, pwErr);
            }
        }
        if (pcfgRUO != null) {
            ((AbstractEval)pcfgRUO).display(true, pwErr);
        }
        if (pcfgCUO != null) {
            ((AbstractEval)pcfgCUO).display(true, pwErr);
        }
        if (tsv) {
            DecimalFormat nf = new DecimalFormat("0.00");
            pwErr.println("factF1\tfactDA\tfactEx\tpcfgF1\tdepDA\tfactTA\tnum");
            if (factLB != null) {
                pwErr.print(nf.format(factLB.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (this.dparser != null && factDA != null) {
                pwErr.print(nf.format(factDA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (factLB != null) {
                pwErr.print(nf.format(factLB.getExactPercent()));
            }
            pwErr.print("\t");
            if (pcfgLB != null) {
                pwErr.print(nf.format(pcfgLB.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (this.dparser != null && depDA != null) {
                pwErr.print(nf.format(depDA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (this.pparser != null && factTA != null) {
                pwErr.print(nf.format(factTA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (factLB != null) {
                pwErr.print(factLB.getNum());
            }
            pwErr.println();
        }
        double f1 = 0.0;
        if (factLB != null) {
            f1 = factLB.getEvalbF1();
        }
        if (pwo != null) {
            pwo.close();
        }
        if (statsPwo != null) {
            statsPwo.close();
        }
        return f1;
    }

    void parseFiles(String[] args, int argIndex, boolean tokenized, TokenizerFactory<? extends HasWord> tokenizerFactory, String elementDelimiter, String sentenceDelimiter, Function<List<HasWord>, List<HasWord>> escaper, String tagDelimiter) {
        TreebankLanguagePack tlp = this.op.tlpParams.treebankLanguagePack();
        PrintWriter pwOut = this.op.tlpParams.pw();
        PrintWriter pwErr = this.op.tlpParams.pw(System.err);
        TreePrint treePrint = this.getTreePrint();
        Timing timer = new Timing();
        int numWords = 0;
        int numSents = 0;
        int numUnparsable = 0;
        int numNoMemory = 0;
        int numFallback = 0;
        int numSkipped = 0;
        boolean saidMemMessage = false;
        if (this.op.testOptions.verbose) {
            if (tokenizerFactory != null) {
                pwErr.println("parseFiles: Tokenizer factory is: " + tokenizerFactory);
            }
            pwErr.println("Sentence final words are: " + Arrays.asList(tlp.sentenceFinalPunctuationWords()));
            pwErr.println("File encoding is: " + this.op.tlpParams.getInputEncoding());
        }
        boolean runningAverages = Boolean.parseBoolean(this.op.testOptions.evals.getProperty("runningAverages"));
        boolean summary = Boolean.parseBoolean(this.op.testOptions.evals.getProperty("summary"));
        AbstractEval.ScoreEval pcfgLL = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("pcfgLL"))) {
            pcfgLL = new AbstractEval.ScoreEval("pcfgLL", runningAverages);
        }
        AbstractEval.ScoreEval depLL = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("depLL"))) {
            depLL = new AbstractEval.ScoreEval("depLL", runningAverages);
        }
        AbstractEval.ScoreEval factLL = null;
        if (Boolean.parseBoolean(this.op.testOptions.evals.getProperty("factLL"))) {
            factLL = new AbstractEval.ScoreEval("factLL", runningAverages);
        }
        timer.start();
        DocumentPreprocessor.DocType docType = elementDelimiter == null ? DocumentPreprocessor.DocType.Plain : DocumentPreprocessor.DocType.XML;
        for (int i = argIndex; i < args.length; ++i) {
            DocumentPreprocessor documentPreprocessor;
            String filename = args[i];
            if (filename.equals("-")) {
                try {
                    documentPreprocessor = new DocumentPreprocessor(new BufferedReader(new InputStreamReader(System.in, this.op.tlpParams.getInputEncoding())), docType);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            } else {
                documentPreprocessor = new DocumentPreprocessor(filename, docType);
            }
            documentPreprocessor.setSentenceFinalPuncWords(tlp.sentenceFinalPunctuationWords());
            documentPreprocessor.setEncoding(this.op.tlpParams.getInputEncoding());
            documentPreprocessor.setEscaper(escaper);
            documentPreprocessor.setSentenceDelimiter(sentenceDelimiter);
            documentPreprocessor.setTagDelimiter(tagDelimiter);
            documentPreprocessor.setElementDelimiter(elementDelimiter);
            if (tokenizerFactory == null) {
                documentPreprocessor.setTokenizerFactory(tokenized ? null : tlp.getTokenizerFactory());
            } else {
                documentPreprocessor.setTokenizerFactory(tokenizerFactory);
            }
            PrintWriter pwo = pwOut;
            if (this.op.testOptions.writeOutputFiles) {
                String normalizedName = filename;
                try {
                    URL url = new URL(normalizedName);
                    normalizedName = normalizedName.replaceAll("/", "_");
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                String ext = this.op.testOptions.outputFilesExtension == null ? "stp" : this.op.testOptions.outputFilesExtension;
                String fname = normalizedName + '.' + ext;
                if (this.op.testOptions.outputFilesDirectory != null && !this.op.testOptions.outputFilesDirectory.equals("")) {
                    String fseparator = System.getProperty("file.separator");
                    if (fseparator == null || "".equals(fseparator)) {
                        fseparator = "/";
                    }
                    File fnameFile = new File(fname);
                    fname = this.op.testOptions.outputFilesDirectory + fseparator + fnameFile.getName();
                }
                try {
                    pwo = this.op.tlpParams.pw(new FileOutputStream(fname));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            treePrint.printHeader(pwo, this.op.tlpParams.getOutputEncoding());
            pwErr.println("Parsing file: " + filename);
            int num = 0;
            for (List<HasWord> sentence : documentPreprocessor) {
                List<ScoredObject<Tree>> trees;
                ++numSents;
                int len = sentence.size();
                numWords += len;
                pwErr.println("Parsing [sent. " + ++num + " len. " + len + "]: " + Sentence.listToString(sentence, true));
                Tree ansTree = null;
                try {
                    if (!this.parse(sentence)) {
                        pwErr.print("Sentence couldn't be parsed by grammar.");
                        if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
                            pwErr.println("... falling back to PCFG parse.");
                            ansTree = this.getBestPCFGParse();
                            ++numFallback;
                        } else {
                            pwErr.println();
                            ++numUnparsable;
                        }
                    } else {
                        ansTree = this.getBestParse();
                    }
                    if (pcfgLL != null && this.pparser != null) {
                        pcfgLL.recordScore(this.pparser, pwErr);
                    }
                    if (depLL != null && this.dparser != null) {
                        depLL.recordScore(this.dparser, pwErr);
                    }
                    if (factLL != null && this.bparser != null) {
                        factLL.recordScore(this.bparser, pwErr);
                    }
                }
                catch (OutOfMemoryError e) {
                    if (this.op.testOptions.maxLength != 559038737) {
                        pwErr.println("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH " + this.op.testOptions.maxLength);
                        pwo.println("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH " + this.op.testOptions.maxLength);
                        throw e;
                    }
                    if (!saidMemMessage) {
                        LexicalizedParserQuery.printOutOfMemory(pwErr);
                        saidMemMessage = true;
                    }
                    if (this.pparser.hasParse() && this.fallbackToPCFG) {
                        try {
                            String what = "dependency";
                            if (this.dparser.hasParse()) {
                                what = "factored";
                            }
                            pwErr.println("Sentence too long for " + what + " parser.  Falling back to PCFG parse...");
                            ansTree = this.getBestPCFGParse();
                            ++numFallback;
                        }
                        catch (OutOfMemoryError oome) {
                            oome.printStackTrace();
                            ++numNoMemory;
                            pwErr.println("No memory to gather PCFG parse. Skipping...");
                            pwo.println("Sentence skipped:  no PCFG fallback.");
                            this.pparser.nudgeDownArraySize();
                        }
                    } else {
                        pwErr.println("Sentence has no parse using PCFG grammar (or no PCFG fallback).  Skipping...");
                        pwo.println("Sentence skipped: no PCFG fallback.");
                        ++numSkipped;
                    }
                }
                catch (UnsupportedOperationException uoe) {
                    pwErr.println("Sentence too long (or zero words).");
                    numWords -= len;
                    ++numSkipped;
                }
                try {
                    treePrint.printTree(ansTree, Integer.toString(num), pwo);
                }
                catch (RuntimeException re) {
                    pwErr.println("TreePrint.printTree skipped: out of memory (or other error)");
                    re.printStackTrace();
                    ++numNoMemory;
                    try {
                        treePrint.printTree(null, Integer.toString(num), pwo);
                    }
                    catch (Exception e) {
                        pwo.println("Sentence skipped: out of memory and error calling TreePrint.");
                        e.printStackTrace();
                    }
                }
                if (this.op.testOptions.printPCFGkBest > 0 && this.pparser.hasParse()) {
                    trees = this.getKBestPCFGParses(this.op.testOptions.printPCFGkBest);
                    treePrint.printTrees(trees, Integer.toString(num), pwo);
                    continue;
                }
                if (this.op.testOptions.printFactoredKGood <= 0 || !this.bparser.hasParse()) continue;
                trees = this.getKGoodFactoredParses(this.op.testOptions.printFactoredKGood);
                treePrint.printTrees(trees, Integer.toString(num), pwo);
            }
            treePrint.printFooter(pwo);
            if (this.op.testOptions.writeOutputFiles) {
                pwo.close();
            }
            pwErr.println("Parsed file: " + filename + " [" + num + " sentences].");
        }
        long millis = timer.stop();
        if (summary) {
            if (pcfgLL != null) {
                pcfgLL.display(false, pwErr);
            }
            if (depLL != null) {
                depLL.display(false, pwErr);
            }
            if (factLL != null) {
                factLL.display(false, pwErr);
            }
        }
        if (saidMemMessage) {
            LexicalizedParserQuery.printOutOfMemory(pwErr);
        }
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        double sentspersec = (double)numSents / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        pwErr.println("Parsed " + numWords + " words in " + numSents + " sentences (" + nf.format(wordspersec) + " wds/sec; " + nf.format(sentspersec) + " sents/sec).");
        if (numFallback > 0) {
            pwErr.println("  " + numFallback + " sentences were parsed by fallback to PCFG.");
        }
        if (numUnparsable > 0 || numNoMemory > 0 || numSkipped > 0) {
            pwErr.println("  " + (numUnparsable + numNoMemory + numSkipped) + " sentences were not parsed:");
            if (numUnparsable > 0) {
                pwErr.println("    " + numUnparsable + " were not parsable with non-zero probability.");
            }
            if (numNoMemory > 0) {
                pwErr.println("    " + numNoMemory + " were skipped because of insufficient memory.");
            }
            if (numSkipped > 0) {
                pwErr.println("    " + numSkipped + " were skipped as length 0 or greater than " + this.op.testOptions.maxLength);
            }
        }
    }

    private static void printOutOfMemory(PrintWriter pw) {
        pw.println();
        pw.println("*******************************************************");
        pw.println("***  WARNING!! OUT OF MEMORY! THERE WAS NOT ENOUGH  ***");
        pw.println("***  MEMORY TO RUN ALL PARSERS.  EITHER GIVE THE    ***");
        pw.println("***  JVM MORE MEMORY, SET THE MAXIMUM SENTENCE      ***");
        pw.println("***  LENGTH WITH -maxLength, OR PERHAPS YOU ARE     ***");
        pw.println("***  HAPPY TO HAVE THE PARSER FALL BACK TO USING    ***");
        pw.println("***  A SIMPLER PARSER FOR VERY LONG SENTENCES.      ***");
        pw.println("*******************************************************");
        pw.println();
    }

    private static void nanScores(Tree tree) {
        tree.setScore(Double.NaN);
        Tree[] kids = tree.children();
        for (int i = 0; i < kids.length; ++i) {
            LexicalizedParserQuery.nanScores(kids[i]);
        }
    }

    private ArrayList<? extends HasWord> getInputSentence(Tree t) {
        if (this.op.testOptions.forceTags) {
            if (this.op.testOptions.preTag) {
                ArrayList<TaggedWord> s = this.tagger.apply(t.yieldWords());
                if (this.op.testOptions.verbose) {
                    System.err.println("Guess tags: " + Arrays.toString(s.toArray()));
                    System.err.println("Gold tags: " + t.labeledYield().toString());
                }
                return s;
            }
            if (this.op.testOptions.noFunctionalForcing) {
                ArrayList<TaggedWord> s = t.taggedYield();
                for (HasWord hasWord : s) {
                    String tag = ((HasTag)((Object)hasWord)).tag();
                    tag = tag.split("-")[0];
                    ((HasTag)((Object)hasWord)).setTag(tag);
                }
                return s;
            }
            return t.taggedYield();
        }
        return t.yieldWords();
    }

    public TreePrint getTreePrint() {
        return this.op.testOptions.treePrint(this.op.tlpParams);
    }

    void addSentenceFinalPunctIfNeeded(List<HasWord> sentence, int length) {
        String[] sfpWords;
        int start = length - 3;
        if (start < 0) {
            start = 0;
        }
        TreebankLanguagePack tlp = this.op.tlpParams.treebankLanguagePack();
        for (int i = length - 1; i >= start; --i) {
            String str;
            HasWord item = sentence.get(i);
            String tag = null;
            if (item instanceof HasTag) {
                tag = ((HasTag)((Object)item)).tag();
            }
            if (!(tag != null && !"".equals(tag) ? tlp.isSentenceFinalPunctuationTag(tag) : (item instanceof HasWord ? tlp.isPunctuationWord(str = item.word()) : tlp.isPunctuationWord(str = item.toString())))) continue;
            return;
        }
        if (this.op.testOptions.verbose) {
            System.err.println("Adding missing final punctuation to sentence.");
        }
        if ((sfpWords = tlp.sentenceFinalPunctuationWords()).length > 0) {
            sentence.add(new Word(sfpWords[0]));
        }
    }
}

