=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ab - Package for language Abkhazian

=cut

package Locale::CLDR::Locales::Ab;
# This file auto generated from Data\common\main\ab.xml
#	on Wed 15 Jan 11:22:39 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'ab' => 'Аԥсшәа',
 				'ace' => 'ачех',
 				'ada' => 'адангме',
 				'ady' => 'аедыгь',
 				'af' => 'африкаанс',
 				'agq' => 'агем',
 				'ain' => 'аин',
 				'ak' => 'акан',
 				'ale' => 'алеут',
 				'alt' => 'аладалтаи',
 				'am' => 'амхар',
 				'an' => 'арагон',
 				'anp' => 'ангика',
 				'ar' => 'араб',
 				'arn' => 'амапуче',
 				'arp' => 'арапахо',
 				'ars' => 'анедџитә араб',
 				'as' => 'ассам',
 				'asa' => 'асу',
 				'ast' => 'астури',
 				'av' => 'авар',
 				'awa' => 'авадхи',
 				'ay' => 'аимара',
 				'az' => 'азербаиџьан',
 				'ba' => 'абашкир',
 				'ban' => 'абали',
 				'bas' => 'абаса',
 				'be' => 'абелорус',
 				'bem' => 'абемба',
 				'bez' => 'абена',
 				'bg' => 'аболгар',
 				'bho' => 'абхоџпури',
 				'bi' => 'абислама',
 				'bin' => 'абини',
 				'bla' => 'асиксика',
 				'bm' => 'абамбара',
 				'bn' => 'абенгал',
 				'bo' => 'атибет',
 				'br' => 'абретон',
 				'brx' => 'абодо',
 				'bs' => 'абосни',
 				'bug' => 'абуги',
 				'byn' => 'абилин',
 				'ca' => 'акаталан',
 				'cay' => 'акаиуга',
 				'ccp' => 'ачакма',
 				'ce' => 'ачечен',
 				'ceb' => 'асебуано',
 				'cgg' => 'акига',
 				'ch' => 'ачаморро',
 				'chk' => 'ачукот',
 				'chm' => 'амари',
 				'cho' => 'ачоктав',
 				'chp' => 'ачипевиан',
 				'chr' => 'ачероки',
 				'chy' => 'ашаиен',
 				'ckb' => 'агәҭантәи ақәырд',
 				'ckb@alt=menu' => 'ақәырд (асорани)',
 				'co' => 'акорсикан',
 				'cs' => 'ачеш',
 				'cu' => 'ауахәама-славиан',
 				'cv' => 'ачуваш',
 				'cy' => 'авалли',
 				'da' => 'адат',
 				'dak' => 'адакота',
 				'dar' => 'адаргин',
 				'dav' => 'атаита',
 				'de' => 'агерман',
 				'de_AT' => 'австриа агерман',
 				'de_CH' => 'алитературатә ашвеицар агерман',
 				'dgr' => 'адогриб',
 				'dje' => 'аџерма',
 				'doi' => 'адогри',
 				'dsb' => 'ҵаҟатәи лужик',
 				'dua' => 'адуала',
 				'dv' => 'амалдив',
 				'dyo' => 'адиола-фони',
 				'dz' => 'аӡонг-ка',
 				'dzg' => 'адаза',
 				'ebu' => 'аембу',
 				'ee' => 'аеве',
 				'efi' => 'аефик',
 				'eka' => 'аекаџук',
 				'el' => 'абырзен',
 				'en' => 'англыз',
 				'en_AU' => 'австралиатәи англыз',
 				'en_CA' => 'канадатәи англыз',
 				'en_GB' => 'абритан англыз',
 				'en_US' => 'америкатәи англыз',
 				'eo' => 'аесперанто',
 				'es' => 'аиспан',
 				'es_419' => 'алаҭын-америкатәи аиспан',
 				'es_ES' => 'европатәи аиспан',
 				'es_MX' => 'мексикатәи аиспан',
 				'et' => 'аестон',
 				'eu' => 'абаск',
 				'ewo' => 'аевондо',
 				'fa' => 'аџьам',
 				'fa_AF' => 'адари',
 				'ff' => 'афулах',
 				'fi' => 'афин',
 				'fil' => 'афилиппин',
 				'fj' => 'афиџи',
 				'fo' => 'афарер',
 				'fon' => 'афон',
 				'fr' => 'афранцыз',
 				'fr_CA' => 'канадатәи афранцыз',
 				'fr_CH' => 'швеицариатәи афранцыз',
 				'frc' => 'каџунтәи афранцыз',
 				'fur' => 'африул',
 				'fy' => 'мраҭашәаратәи африз',
 				'ga' => 'аирланд',
 				'gaa' => 'ага',
 				'gd' => 'агел',
 				'gez' => 'агеез',
 				'gil' => 'агилберт',
 				'gl' => 'агалиси',
 				'gn' => 'агуарани',
 				'gor' => 'агоронтало',
 				'gsw' => 'швеицариатәи агерман',
 				'gu' => 'агуџарати',
 				'guz' => 'агуси',
 				'gv' => 'амен',
 				'gwi' => 'агвичин',
 				'ha' => 'ахауса',
 				'hai' => 'ахаида',
 				'haw' => 'агаваи',
 				'he' => 'аиврит',
 				'hi' => 'ахинди',
 				'hi_Latn@alt=variant' => 'ахынглыз',
 				'hil' => 'ахилигаинон',
 				'hmn' => 'ахмонг',
 				'hr' => 'ахорват',
 				'hsb' => 'хыхьтәи-алужик',
 				'ht' => 'агаитиан',
 				'hu' => 'авенгер',
 				'hup' => 'ахупа',
 				'hy' => 'аерман',
 				'hz' => 'агереро',
 				'ia' => 'аинтерлингва',
 				'iba' => 'аибан',
 				'ibb' => 'аибибио',
 				'id' => 'аиндонез',
 				'ig' => 'аигбо',
 				'ii' => 'аносу',
 				'ilo' => 'аилоко',
 				'inh' => 'аингәыш',
 				'io' => 'аидо',
 				'is' => 'аисланд',
 				'it' => 'аиталиа',
 				'iu' => 'аинуктитут',
 				'ja' => 'аиапон',
 				'jbo' => 'аложбан',
 				'jgo' => 'ангомба',
 				'jmc' => 'амачаме',
 				'jv' => 'аиаван',
 				'ka' => 'ақырҭ',
 				'kab' => 'акабил',
 				'kac' => 'акачин',
 				'kaj' => 'акаџи',
 				'kam' => 'акамба',
 				'kbd' => 'аҟабарда',
 				'kcg' => 'атиап',
 				'kde' => 'амаконде',
 				'kea' => 'акабувердиану',
 				'kfo' => 'акоро',
 				'kha' => 'акхаси',
 				'khq' => 'акоира чиини',
 				'ki' => 'акикәиу',
 				'kj' => 'акәнама',
 				'kk' => 'аҟазах',
 				'kkj' => 'акако',
 				'kl' => 'агренланд',
 				'kln' => 'акаленџин',
 				'km' => 'акхмер',
 				'kmb' => 'акимбунду',
 				'kn' => 'аканнада',
 				'ko' => 'акореи',
 				'kok' => 'аконкани',
 				'kpe' => 'акпелле',
 				'kr' => 'аканури',
 				'krc' => 'аҟарач-абалҟар',
 				'krl' => 'акарел',
 				'kru' => 'акурух',
 				'ks' => 'акашмири',
 				'ksb' => 'ашамбала',
 				'ksf' => 'абафиа',
 				'ksh' => 'акиолн',
 				'ku' => 'ақәырд',
 				'kum' => 'акәымык',
 				'kv' => 'акоми',
 				'kw' => 'акорн',
 				'ky' => 'акиргиз',
 				'la' => 'алаҭын',
 				'lad' => 'аладино',
 				'lag' => 'аланго',
 				'lb' => 'алиуксембург',
 				'lez' => 'алезгьын',
 				'lg' => 'аганда',
 				'li' => 'алимбург',
 				'lkt' => 'алакота',
 				'ln' => 'алингала',
 				'lo' => 'алаос',
 				'lou' => 'алуизиантәи акреол',
 				'loz' => 'алози',
 				'lrc' => 'аҩадалур',
 				'lt' => 'алитов',
 				'lu' => 'алуба-акатанга',
 				'lua' => 'алуба-алулуа',
 				'lun' => 'алунда',
 				'luo' => 'алуо',
 				'lus' => 'амизо',
 				'luy' => 'алухьиа',
 				'lv' => 'алатыш',
 				'mad' => 'амадур',
 				'mag' => 'амагахи',
 				'mai' => 'амаитхили',
 				'mak' => 'амакассар',
 				'mas' => 'амасаи',
 				'mdf' => 'амокшан',
 				'men' => 'аменде',
 				'mer' => 'амеру',
 				'mfe' => 'амаврикитә креол',
 				'mg' => 'амалагаси',
 				'mgh' => 'амакуа-амеетто',
 				'mgo' => 'амета',
 				'mh' => 'амаршал',
 				'mi' => 'амаори',
 				'mic' => 'амикмак',
 				'min' => 'аминангкабау',
 				'mk' => 'амакедон',
 				'ml' => 'амалаиалам',
 				'mn' => 'амонгол',
 				'mni' => 'аманипур',
 				'moh' => 'амохаук',
 				'mos' => 'амоси',
 				'mr' => 'амаратхи',
 				'ms' => 'амалаи',
 				'mt' => 'амалти',
 				'mua' => 'амунданг',
 				'mul' => 'еиуеиԥшым аҭаацәаратә бызшәақәа',
 				'mus' => 'акрик',
 				'mwl' => 'амиранд',
 				'my' => 'абирман',
 				'myv' => 'аерзиан',
 				'mzn' => 'амазандеран',
 				'na' => 'анауру',
 				'nap' => 'анеаполитан',
 				'naq' => 'анама',
 				'nb' => 'анорвегтәи абукмол',
 				'nd' => 'нхыҵ андебеле',
 				'nds' => 'ҵаҟатәи агерман',
 				'nds_NL' => 'ҵаҟатәи асаксон',
 				'ne' => 'анепал',
 				'new' => 'аневар',
 				'ng' => 'андонга',
 				'nia' => 'аниас',
 				'niu' => 'аниуе',
 				'nl' => 'анидерланд',
 				'nl_BE' => 'афламанд',
 				'nmg' => 'аквасио',
 				'nn' => 'аниунорск',
 				'nnh' => 'ангиембунд',
 				'no' => 'анорвег',
 				'nog' => 'аногаи',
 				'nqo' => 'анко',
 				'nr' => 'аладатәи андебеле',
 				'nso' => 'аҩадатәи асото',
 				'nus' => 'ануер',
 				'nv' => 'анавахо',
 				'ny' => 'анианџа',
 				'nyn' => 'анианколе',
 				'oc' => 'аокситан',
 				'om' => 'аоромо',
 				'or' => 'аориа',
 				'os' => 'ауаԥс',
 				'pa' => 'апанџаби',
 				'pag' => 'апангасинан',
 				'pam' => 'апампанга',
 				'pap' => 'апапиаменто',
 				'pau' => 'апалау',
 				'pcm' => 'анигери-креол',
 				'pl' => 'апол',
 				'prg' => 'апрус',
 				'ps' => 'апушту',
 				'pt' => 'апортугал',
 				'pt_BR' => 'бразилиатәи апортугал',
 				'pt_PT' => 'европатәи апортугал',
 				'qu' => 'акечуа',
 				'rap' => 'арапануи',
 				'rar' => 'араротонга',
 				'rhg' => 'арохинџа',
 				'rm' => 'ароманш',
 				'rn' => 'арунди',
 				'ro' => 'арумын',
 				'ro_MD' => 'молдав',
 				'rof' => 'аромбо',
 				'ru' => 'аурыс',
 				'rup' => 'аромун',
 				'rw' => 'акиниаруанда',
 				'rwk' => 'аруанда',
 				'sa' => 'асанскрит',
 				'sad' => 'асандаве',
 				'sah' => 'асаха',
 				'saq' => 'асамбуру',
 				'sat' => 'асантали',
 				'sba' => 'ангамбаи',
 				'sbp' => 'асангу',
 				'sc' => 'асардин',
 				'scn' => 'асицили',
 				'sco' => 'ашотланд',
 				'sd' => 'асиндхи',
 				'se' => 'аҩадасаам',
 				'seh' => 'асена',
 				'ses' => 'акоираборо асенни',
 				'sg' => 'асанго',
 				'shi' => 'аташелхит',
 				'shn' => 'ашан',
 				'si' => 'асингал',
 				'sk' => 'асловак',
 				'sl' => 'асловен',
 				'sm' => 'асамоан',
 				'smn' => 'аинари-асаам',
 				'sms' => 'аколтта-асаам',
 				'sn' => 'ашона',
 				'snk' => 'асонинке',
 				'so' => 'асомали',
 				'sq' => 'арнауҭ',
 				'sr' => 'асерб',
 				'srn' => 'асранан-атонго',
 				'ss' => 'асвази',
 				'st' => 'аладатәи асото',
 				'su' => 'асундан',
 				'suk' => 'асукәыма',
 				'sv' => 'ашвед',
 				'sw' => 'асуахили',
 				'sw_CD' => 'конголезтәи асуахили',
 				'swb' => 'акомор',
 				'syr' => 'ашьам',
 				'ta' => 'атамил',
 				'te' => 'ателугу',
 				'tem' => 'атемне',
 				'teo' => 'атесо',
 				'tet' => 'атетум',
 				'tg' => 'аҭаџьык',
 				'th' => 'атаи',
 				'ti' => 'атигриниа',
 				'tig' => 'атигре',
 				'tk' => 'атуркмен',
 				'tlh' => 'аклингон',
 				'tli' => 'атлингит',
 				'tn' => 'атсвана',
 				'to' => 'атонган',
 				'tpi' => 'аток-аписин',
 				'tr' => 'аҭырқә',
 				'trv' => 'аседек',
 				'ts' => 'атсонга',
 				'tt' => 'аҭаҭар',
 				'tum' => 'атумбука',
 				'tvl' => 'атувалу',
 				'twq' => 'атасавак',
 				'ty' => 'атаитиан',
 				'tyv' => 'атувин',
 				'tzm' => 'абжьара-атластәи атамазигхт',
 				'udm' => 'аудмурт',
 				'ug' => 'ауигур',
 				'uk' => 'аукраин',
 				'umb' => 'аумбунду',
 				'und' => 'еилкаам абызшәа',
 				'ur' => 'аурду',
 				'uz' => 'аузбек',
 				'vai' => 'аваи',
 				've' => 'авенда',
 				'vi' => 'авиетнам',
 				'vo' => 'аволапиук',
 				'vun' => 'авунџо',
 				'wa' => 'аваллон',
 				'wae' => 'аваллис',
 				'wal' => 'аволамо',
 				'war' => 'авараи',
 				'wo' => 'аволоф',
 				'wuu' => 'аву',
 				'xal' => 'аҟалмыҟ',
 				'xh' => 'акоса',
 				'xog' => 'асога',
 				'yav' => 'аиангбен',
 				'ybb' => 'аиемба',
 				'yi' => 'аидиш',
 				'yo' => 'аиоруба',
 				'yue' => 'акантон',
 				'zgh' => 'атамазигхт',
 				'zh' => 'акитаи',
 				'zh@alt=menu' => 'аҩадакитаи',
 				'zh_Hans' => 'акитаи, имариоу аҩыра',
 				'zh_Hans@alt=long' => 'аҩадакитаи, имариоу аҩыра',
 				'zh_Hant' => 'акитаи, атрадициатә ҩыра',
 				'zh_Hant@alt=long' => 'аҩадакитаи, атрадициатә ҩыра',
 				'zu' => 'азулу',
 				'zun' => 'азуни',
 				'zxx' => 'абызшәатә хыҵхырҭақәа ыҟаӡам',
 				'zza' => 'азаза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'араб',
 			'Aran' => 'анасталик',
 			'Armi' => 'арамеи',
 			'Armn' => 'аерман',
 			'Avst' => 'авести',
 			'Bali' => 'абали',
 			'Bamu' => 'абамум',
 			'Bass' => 'абасса (авах)',
 			'Batk' => 'абатак',
 			'Beng' => 'абенгал',
 			'Bopo' => 'абопомофо',
 			'Brah' => 'абрахми',
 			'Brai' => 'Браили ишрифт',
 			'Bugi' => 'абугиниз',
 			'Buhd' => 'абухид',
 			'Cakm' => 'ачакма',
 			'Cans' => 'канадатәи ацыратә ҩыра',
 			'Cari' => 'акари',
 			'Cham' => 'ачам',
 			'Cher' => 'ачероки',
 			'Copt' => 'акопт',
 			'Cprt' => 'акипр',
 			'Cyrl' => 'акириллица',
 			'Deva' => 'адеванагар',
 			'Dsrt' => 'адезерет',
 			'Dupl' => 'адуплоиантә ццакҩыра',
 			'Egyp' => 'мсыртәи аиероглиф',
 			'Ethi' => 'аефиоп',
 			'Geor' => 'ақырҭ',
 			'Glag' => 'аглаголица',
 			'Goth' => 'агот',
 			'Gran' => 'агрантха',
 			'Grek' => 'абырзен',
 			'Gujr' => 'агуџарати',
 			'Guru' => 'агәырмукхи',
 			'Hanb' => 'аханб',
 			'Hang' => 'ахангыл',
 			'Hani' => 'акитаи',
 			'Hano' => 'ахануну',
 			'Hans' => 'имариоу акитаи',
 			'Hant' => 'китаитәи атрадициатә',
 			'Hebr' => 'ауриа',
 			'Hira' => 'ахирагана',
 			'Hluw' => 'лувиатәи аиероглифқәа',
 			'Hmng' => 'апахау ахмонг',
 			'Hrkt' => 'акатаканеи ахираганеи',
 			'Hung' => 'ажәытәвенгер',
 			'Ital' => 'ажәытәиталиа',
 			'Jamo' => 'аџамо',
 			'Java' => 'аиаван',
 			'Jpan' => 'аиапон',
 			'Kali' => 'акаиа',
 			'Kana' => 'акатакана',
 			'Khar' => 'акхароштхи',
 			'Khmr' => 'акхмер',
 			'Khoj' => 'ахоџики',
 			'Knda' => 'аканнада',
 			'Kore' => 'акореи',
 			'Kthi' => 'акаитхи',
 			'Lana' => 'аланна',
 			'Laoo' => 'алаос',
 			'Latn' => 'алаҭын',
 			'Lepc' => 'алепха',
 			'Limb' => 'алимбу',
 			'Lina' => 'ацәаҳәатә ҩыра А',
 			'Linb' => 'ацәаҳәатә ҩыра Б',
 			'Lisu' => 'алису',
 			'Lyci' => 'алициан',
 			'Lydi' => 'алиди',
 			'Mand' => 'амандеи',
 			'Mani' => 'аманихеи',
 			'Mend' => 'аменде',
 			'Merc' => 'ихьынаау америоттә',
 			'Mero' => 'амероит',
 			'Mlym' => 'амалаиалам',
 			'Mong' => 'амонгол',
 			'Mroo' => 'амро',
 			'Mtei' => 'аманипур',
 			'Mymr' => 'амианман',
 			'Narb' => 'аҩадарави',
 			'Nbat' => 'анабатеи',
 			'Nkoo' => 'анко',
 			'Nshu' => 'аниуи-шу',
 			'Ogam' => 'аогам',
 			'Olck' => 'аол чики',
 			'Orkh' => 'аорхоно-енисеи',
 			'Orya' => 'аориа',
 			'Osma' => 'аосман',
 			'Palm' => 'апалмир',
 			'Perm' => 'ажәытәпермтәи',
 			'Phag' => 'апагспа',
 			'Phli' => 'апехлеви',
 			'Phlp' => 'апахлави апсалтир',
 			'Phnx' => 'афиники',
 			'Plrd' => 'аполлардтәи афонетика',
 			'Prti' => 'апарфиан',
 			'Qaag' => 'азоџ',
 			'Rjng' => 'ареџанг',
 			'Runr' => 'арун',
 			'Samr' => 'асамаритиант',
 			'Sarb' => 'ажәытәа аладатәи араб',
 			'Saur' => 'асаураштра',
 			'Sgnw' => 'адыргақәа рбызшәа',
 			'Shaw' => 'алфавит Шоу',
 			'Shrd' => 'ашарада',
 			'Sind' => 'акхәыдавади',
 			'Sinh' => 'асингал',
 			'Sora' => 'асора-сонпенг',
 			'Sund' => 'асундан',
 			'Sylo' => 'асилоти нагри',
 			'Syrc' => 'ашьам',
 			'Tagb' => 'атагбанва',
 			'Takr' => 'атакри',
 			'Tale' => 'атаи ле',
 			'Talu' => 'атаи ле ҿыц',
 			'Taml' => 'атамил',
 			'Tang' => 'атангәыттә мениа',
 			'Tavt' => 'атаи-вет',
 			'Telu' => 'ателугу',
 			'Tfng' => 'ажәытәливиатәи',
 			'Tglg' => 'атагалог',
 			'Thaa' => 'атана',
 			'Thai' => 'атаи',
 			'Tibt' => 'атибет',
 			'Tirh' => 'атирхәыта',
 			'Ugar' => 'аугарит',
 			'Vaii' => 'аваи',
 			'Wara' => 'аваранг-кшити',
 			'Xpeo' => 'ажәытәџьам',
 			'Xsux' => 'ашумер-аккад асалҩыра',
 			'Yiii' => 'и',
 			'Zinh' => 'шьҭралатәи',
 			'Zmth' => 'аматематикатә дырга',
 			'Zsye' => 'аемоӡи',
 			'Zsym' => 'асимволқәа',
 			'Zxxx' => 'аҩыра змам',
 			'Zyyy' => 'азеиԥшшьҭых',
 			'Zzzz' => 'еилкаам аҩыра',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'адунеи зегьы',
 			'002' => 'Африка',
 			'003' => 'Аҩадатәи Америка',
 			'005' => 'Аладатәи Америка',
 			'009' => 'Океаниа',
 			'011' => 'Мраҭашәаратәи Африка',
 			'013' => 'Агәҭантәи Америка',
 			'014' => 'Мрагыларатәи Африка',
 			'015' => 'Аҩадатәи Африка',
 			'017' => 'Агәҭантәи Африка',
 			'018' => 'Аладатәи Африка',
 			'019' => 'Америка',
 			'021' => 'Аҩада-Америкатәи арегион',
 			'029' => 'Кариб',
 			'030' => 'Мрагыларатәи Азиа',
 			'034' => 'Аладатәи Азиа',
 			'035' => 'Алада-Мрагыларатәи Азиа',
 			'039' => 'Аладатәи Европа',
 			'053' => 'Австралазиа',
 			'054' => 'Меланезиа',
 			'057' => 'Микронезиа',
 			'061' => 'Полинезиа',
 			'142' => 'Азиа',
 			'143' => 'Агәҭантәи Азиа',
 			'145' => 'Мраҭашәаратәи Азиа',
 			'150' => 'Европа',
 			'151' => 'Мрагыларатәи Европа',
 			'154' => 'Аҩадатәи Европа',
 			'155' => 'Мраҭашәаратәи Европа',
 			'202' => 'Атроптә Африка',
 			'419' => 'Алаҭынтәи Америка',
 			'AC' => 'ад-ха Вознесениа',
 			'AD' => 'Андорра',
 			'AE' => 'ЕАЕ',
 			'AF' => 'Афганистан',
 			'AG' => 'Антигуеи Барбудеи',
 			'AI' => 'Ангилиа',
 			'AL' => 'Албаниа',
 			'AM' => 'Ермантәыла',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктида',
 			'AR' => 'Аргентина',
 			'AS' => 'Америкатәи Самоа',
 			'AT' => 'Австриа',
 			'AU' => 'Австралиа',
 			'AW' => 'Аруба',
 			'AX' => 'Аландтәи ад-хақәа',
 			'AZ' => 'Азербаиџьан',
 			'BA' => 'Босниеи Герцеговинеи',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгиа',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Болгариа',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сен-Бартелеми',
 			'BM' => 'Бермудтәи ад-хақәа',
 			'BN' => 'Брунеи-Даруссалам',
 			'BO' => 'Боливиа',
 			'BQ' => 'Бонеир, Синт-Естатиуси Сабеи',
 			'BR' => 'Бразилиа',
 			'BS' => 'Баӷама',
 			'BT' => 'Бутан',
 			'BV' => 'ад-ха Буве',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларус',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокостәи ад-қәа',
 			'CD' => 'Конго-Киншаса',
 			'CD@alt=variant' => 'Конго (АРК)',
 			'CF' => 'Агәҭантәи-Африкатәи Ареспублика',
 			'CG' => 'Конго-Браззавиль',
 			'CG@alt=variant' => 'Ареспублика Конго',
 			'CH' => 'Швеицариа',
 			'CI' => 'Кот-д’Ивуар',
 			'CK' => 'Кук идгьылбжьахақәа',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Китаи',
 			'CO' => 'Колумбиа',
 			'CP' => 'ад-ха Клиппертон',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Киурасао',
 			'CX' => 'ад-ха Қьырса',
 			'CY' => 'Кипр',
 			'CZ' => 'Чехиа',
 			'CZ@alt=variant' => 'Чештәи ареспублика',
 			'DE' => 'Германиа',
 			'DG' => 'Диего-Гарсиа',
 			'DJ' => 'Џибути',
 			'DK' => 'Даниа',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканатәи Ареспублика',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеутеи Мелилиеи',
 			'EC' => 'Еквадор',
 			'EE' => 'Естониа',
 			'EG' => 'Египет',
 			'EH' => 'Мраҭашәаратәи Сахара',
 			'ER' => 'Еритреиа',
 			'ES' => 'Испаниа',
 			'ET' => 'Ефиопиа',
 			'EU' => 'Европатәи аидгыла',
 			'EZ' => 'евроцәаҳәа',
 			'FI' => 'Финлиандиа',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фолклендтәи ад-хақәа',
 			'FK@alt=variant' => 'Фолклендтәи (Мальвинтәи) ад-хақәа',
 			'FM' => 'Еилоу Микронезиатәи Аштатқәа',
 			'FO' => 'Фарертәи ад-хақәа',
 			'FR' => 'Франциа',
 			'GA' => 'Габон',
 			'GB' => 'Британиа ду',
 			'GB@alt=short' => 'Британиа',
 			'GD' => 'Гренада',
 			'GE' => 'Қырҭтәыла',
 			'GF' => 'Францызтәи Гвиана',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландиа',
 			'GM' => 'Гамбиа',
 			'GN' => 'Гвинеиа',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Екваториалтәи Гвинеиа',
 			'GR' => 'Бырзентәыла',
 			'GS' => 'Аладатәи Георгиеи Аладатәи Сандвичқәеи ад-қәа',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинеиа-Бисау',
 			'GY' => 'Гаиана',
 			'HK' => 'Гонконг (ҶАР)',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'ад-хақәа Херди Макдональди',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватиа',
 			'HT' => 'Гаити',
 			'HU' => 'Венгриа',
 			'IC' => 'Канартәи ад-хақәа',
 			'ID' => 'Индонезиа',
 			'IE' => 'Ирландиа',
 			'IL' => 'Израиль',
 			'IM' => 'ад-ха Мен',
 			'IN' => 'Индиа',
 			'IO' => 'Британиатәи аҵакырадгьыл Индиатәи аокеан аҟны',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исландиа',
 			'IT' => 'Италиа',
 			'JE' => 'Џерси',
 			'JM' => 'Иамаика',
 			'JO' => 'Иорданиа',
 			'JP' => 'Иапониа',
 			'KE' => 'Кениа',
 			'KG' => 'Киргизиа',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Комор',
 			'KN' => 'Сент-Китси Невиси',
 			'KP' => 'КЖӘДР',
 			'KR' => 'Кореиа Ареспублика',
 			'KW' => 'Кувеит',
 			'KY' => 'Адгьылбжьахақәа Каиман',
 			'KZ' => 'Ҟазахсҭан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люсиа',
 			'LI' => 'Лихтенштеин',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либериа',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Лиуксембург',
 			'LV' => 'Латвиа',
 			'LY' => 'Ливиа',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Ашьхеиқәаҵәа',
 			'MF' => 'Сен-Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршаллтәи Адгьылбжьахақәа',
 			'MK' => 'Аҩадатәи Македониа',
 			'ML' => 'Мали',
 			'MM' => 'Мианма (Бирма)',
 			'MN' => 'Монголиа',
 			'MO' => 'Макао (ҶАР)',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Аҩадатәи Мариантәи ад-хақәа',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавританиа',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврики',
 			'MV' => 'Мальдив',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малаизиа',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибиа',
 			'NC' => 'Каледониа ҿыц',
 			'NE' => 'Нигер',
 			'NF' => 'Ад-ха Норфолк',
 			'NG' => 'Нигериа',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерланд',
 			'NO' => 'Норвегиа',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуе',
 			'NZ' => 'Зеландиа ҿыц',
 			'NZ@alt=variant' => 'Аотеароа (Зеландиа ҿыц)',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Францызтәи Полинезиа',
 			'PG' => 'Папуа — Гвинеиа ҿыц',
 			'PH' => 'Филиппин',
 			'PK' => 'Пакистан',
 			'PL' => 'Польша',
 			'PM' => 'Сен-Пиери Микелони',
 			'PN' => 'Питкерн ад-хақәа',
 			'PR' => 'Пуерто-Рико',
 			'PS' => 'Палестинатәи аҵакырадгьылқәа',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалиа',
 			'PW' => 'Палау',
 			'PY' => 'Парагваи',
 			'QA' => 'Катар',
 			'QO' => 'Нҭыҵтәи Океаниа',
 			'RE' => 'Реиунон',
 			'RO' => 'Румыниа',
 			'RS' => 'Сербиа',
 			'RU' => 'Урыстәыла',
 			'RW' => 'Руанда',
 			'SA' => 'Саудтәи Арабсҭан',
 			'SB' => 'Соломонтәи адгьылбжьахақәа',
 			'SC' => 'Сеишелтәи адгьылбжьахақәа',
 			'SD' => 'Судан',
 			'SE' => 'Швециа',
 			'SG' => 'Сингапур',
 			'SH' => 'Иԥшьоу Елена ладгьылбжьаха',
 			'SI' => 'Словениа',
 			'SJ' => 'Шпицбергени Иан-Маиени',
 			'SK' => 'Словакиа',
 			'SL' => 'Сиерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Аладатәи Судан',
 			'ST' => 'Сан-Томеи Принсипиеи',
 			'SV' => 'Сальвадор',
 			'SX' => 'Синт-Мартен',
 			'SY' => 'Шьамтәыла',
 			'SZ' => 'Есватини',
 			'SZ@alt=variant' => 'Свазиленд',
 			'TA' => 'Тристан-да-Куниа',
 			'TC' => 'ад-хақәа Тиоркси Каикоси',
 			'TD' => 'Чад',
 			'TF' => 'Францызтәи Аладатәи аҵакырадгьылқәа',
 			'TG' => 'Того',
 			'TH' => 'Таиланд',
 			'TJ' => 'Таџьықсҭан',
 			'TK' => 'Токелау',
 			'TL' => 'Мрагыларатәи Тимор',
 			'TL@alt=variant' => 'Тимор-Лесте',
 			'TM' => 'Ҭурқменисҭан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Ҭырқәтәыла',
 			'TT' => 'Тринидади Тобагои',
 			'TV' => 'Тувалу',
 			'TW' => 'Таиван',
 			'TZ' => 'Танзаниа',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'Нҭыҵтәи малыетәи ад-қәа (ЕАШ)',
 			'UN' => 'Еиду Амилаҭқәа Реиҿкаара',
 			'US' => 'Еиду Аштатқәа',
 			'US@alt=short' => 'ЕАШ',
 			'UY' => 'Уругваи',
 			'UZ' => 'Узбеқьисҭан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсенти Гренадини',
 			'VE' => 'Венесуела',
 			'VG' => 'Виргинтәи ад-хақәа (Британиаду)',
 			'VI' => 'Виргинтәи ад-хақәа (ЕАШ)',
 			'VN' => 'Виетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллиси Футунеи',
 			'WS' => 'Самоа',
 			'XA' => 'амццәажәашьақәа',
 			'XB' => 'амц-Bidi',
 			'XK' => 'Косово',
 			'YE' => 'Иемен',
 			'YT' => 'Маиотта',
 			'ZA' => 'Алада-Африкатәи ареспублика',
 			'ZM' => 'Замбиа',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'еилкаам арегион',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'gregorian' => q{агригориантә мзар},
 				'iso8601' => q{амзар ISO-8601},
 			},
 			'collation' => {
 				'standard' => q{астандартә сортла аилыхра},
 			},
 			'numbers' => {
 				'latn' => q{иахьатәи араб ацифра},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{Аметрикатә},
 			'UK' => q{Англиатәи},
 			'US' => q{Америкатә},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Абызшәа: {0}',
 			'script' => 'Аҩыра: {0}',
 			'region' => 'Арегион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[{а́} ҕ {ҕә} {ҕь} {е́} {и́} {о́} ҧ {у́} {ы́}]},
			index => ['А', 'Б', 'В', 'Г', '{ГӘ}', '{ГЬ}', 'Ӷ', '{ӶӘ}', '{ӶЬ}', 'Д', '{ДӘ}', 'Е', 'Ж', '{ЖӘ}', '{ЖЬ}', 'З', 'Ӡ', '{ӠӘ}', 'И', 'К', '{КӘ}', '{КЬ}', 'Қ', '{ҚӘ}', '{ҚЬ}', 'Ҟ', '{ҞӘ}', '{ҞЬ}', 'Л', 'М', 'Н', 'О', 'П', 'Ԥ', 'Р', 'С', 'Т', '{ТӘ}', 'Ҭ', '{ҬӘ}', 'У', 'Ф', 'Х', '{ХӘ}', '{ХЬ}', 'Ҳ', '{ҲӘ}', 'Ц', '{ЦӘ}', 'Ҵ', '{ҴӘ}', 'Ч', 'Ҷ', 'Ҽ', 'Ҿ', 'Џ', '{ЏЬ}', 'Ш', '{ШӘ}', '{ШЬ}', 'Ы', 'Ҩ'],
			main => qr{[а ә б в г {гә} {гь} ӷ {ӷә} {ӷь} д {дә} е ж {жә} {жь} з ӡ {ӡә} и к {кә} {кь} қ {қә} {қь} ҟ {ҟә} {ҟь} л м н о п ԥ р с т {тә} ҭ {ҭә} у ф х {хә} {хь} ҳ {ҳә} ц {цә} ҵ {ҵә} ч ҷ ҽ ҿ џ {џь} ш {шә} {шь} ы ь ҩ]},
			numbers => qr{[\- ‑ , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘‚ "“„ « » ( ) \[ \] \{ \} § @ * / \& #]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', '{ГӘ}', '{ГЬ}', 'Ӷ', '{ӶӘ}', '{ӶЬ}', 'Д', '{ДӘ}', 'Е', 'Ж', '{ЖӘ}', '{ЖЬ}', 'З', 'Ӡ', '{ӠӘ}', 'И', 'К', '{КӘ}', '{КЬ}', 'Қ', '{ҚӘ}', '{ҚЬ}', 'Ҟ', '{ҞӘ}', '{ҞЬ}', 'Л', 'М', 'Н', 'О', 'П', 'Ԥ', 'Р', 'С', 'Т', '{ТӘ}', 'Ҭ', '{ҬӘ}', 'У', 'Ф', 'Х', '{ХӘ}', '{ХЬ}', 'Ҳ', '{ҲӘ}', 'Ц', '{ЦӘ}', 'Ҵ', '{ҴӘ}', 'Ч', 'Ҷ', 'Ҽ', 'Ҿ', 'Џ', '{ЏЬ}', 'Ш', '{ШӘ}', '{ШЬ}', 'Ы', 'Ҩ'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ааи|а|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:мап|м|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0}-и {1}-и),
				2 => q({0}-и {1}-и),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'group' => q( ),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0 %',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'BMD' => {
			display_name => {
				'currency' => q(бермудтәи адоллар),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(евро),
			},
		},
		'GEL' => {
			symbol => 'ლ',
		},
		'JPY' => {
			symbol => '¥',
		},
		'PHP' => {
			symbol => 'PHP',
		},
		'RON' => {
			symbol => 'L',
		},
		'RUB' => {
			symbol => '₽',
		},
		'SLE' => {
			display_name => {
				'currency' => q(леоне),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(леоне \(1964—2022\)),
			},
		},
		'THB' => {
			symbol => '฿',
		},
		'TWD' => {
			symbol => 'NT$',
		},
		'UAH' => {
			symbol => '₴',
		},
		'USD' => {
			symbol => '$',
		},
		'XXX' => {
			display_name => {
				'currency' => q(Еилкаам Авалиута),
				'other' => q(\(еилкаам авалиута\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Ажь',
							'Жəаб',
							'Хəажә',
							'Мш',
							'Лаҵ',
							'Рашә',
							'Ԥхынгә',
							'Нанҳә',
							'Цəыб',
							'Жьҭ',
							'Абҵ',
							'Ԥхынҷ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Жь',
							'Жə',
							'Хə',
							'М',
							'Л',
							'Р',
							'Гә',
							'Н',
							'Цə',
							'Ҭ',
							'Б',
							'Ҷ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Ажьырныҳəа',
							'Жəабран',
							'Хəажəкыра',
							'Мшаԥы',
							'Лаҵара',
							'Рашəара',
							'Ԥхынгəы',
							'Нанҳəа',
							'Цəыббра',
							'Жьҭаара',
							'Абҵара',
							'Ԥхынҷкәын'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'Жь',
							'Жə',
							'Хə',
							'М',
							'Л',
							'Р',
							'Гә',
							'Н',
							'Цә',
							'Ҭ',
							'Б',
							'Ҷ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Ашә',
						tue => 'Аҩ',
						wed => 'Ах',
						thu => 'Аԥ',
						fri => 'Ахә',
						sat => 'Ас',
						sun => 'Ам'
					},
					wide => {
						mon => 'Ашәахьа',
						tue => 'Аҩаша',
						wed => 'Ахаша',
						thu => 'Аԥшьаша',
						fri => 'Ахәаша',
						sat => 'Асабша',
						sun => 'Амҽыша'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'Шә',
						tue => 'Ҩ',
						wed => 'Х',
						thu => 'Ԥ',
						fri => 'Хә',
						sat => 'С',
						sun => 'М'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-тәи акв.',
						1 => '2-тәи акв.',
						2 => '3-тәи акв.',
						3 => '4-тәи акв.'
					},
					wide => {0 => '1-тәи аквартал',
						1 => '2-тәи аквартал',
						2 => '3-тәи аквартал',
						3 => '4-тәи аквартал'
					},
				},
			},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, d MMMM y 'ш'. G},
			'long' => q{d MMMM y 'ш'. G},
			'medium' => q{d MMM y 'ш'. G},
			'short' => q{dd.MM.y G},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y 'ш'.},
			'long' => q{d MMMM y 'ш'.},
			'medium' => q{d MMM y 'ш'.},
			'short' => q{dd.MM.y},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			EHm => q{ccc HH:mm},
			EHms => q{ccc HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{ccc, h:mm a},
			Ehms => q{ccc, h:mm:ss a},
			Gy => q{y 'ш'. G},
			GyMMM => q{LLL y 'ш'. G},
			GyMMMEd => q{E, d MMM y 'ш'. G},
			GyMMMd => q{d MMM y 'ш'. G},
			GyMd => q{dd.MM.y G},
			MEd => q{E, dd.MM},
			MMMEd => q{ccc, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			y => q{y 'ш'. G},
			yyyy => q{y 'ш'. G},
			yyyyM => q{MM.y G},
			yyyyMEd => q{E, dd.MM.y G},
			yyyyMMM => q{LLL y 'ш'. G},
			yyyyMMMEd => q{E, d MMM y 'ш'. G},
			yyyyMMMM => q{LLLL y 'ш'. G},
			yyyyMMMd => q{d MMM y 'ш'. G},
			yyyyMd => q{dd.MM.y G},
			yyyyQQQ => q{QQQ y 'ш'. G},
			yyyyQQQQ => q{QQQQ y 'ш'. G},
		},
		'gregorian' => {
			EBhm => q{ccc, h:mm B},
			EBhms => q{ccc, h:mm:ss B},
			Ed => q{ccc, d},
			Gy => q{y 'ш'. G},
			GyMMM => q{LLL y 'ш'. G},
			GyMMMEd => q{E, d MMM y 'ш'. G},
			GyMMMd => q{d MMM y 'ш'. G},
			GyMd => q{dd.MM.y GGGGG},
			MEd => q{E, dd.MM},
			MMMEd => q{ccc, d MMM},
			MMMMW => q{W-'тәи' 'амчыбжь' MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			yM => q{MM.y},
			yMEd => q{ccc, dd.MM.y 'ш'.},
			yMMM => q{LLL y 'ш'.},
			yMMMEd => q{E, d MMM y 'ш'.},
			yMMMM => q{LLLL y 'ш'.},
			yMMMd => q{d MMM y 'ш'.},
			yMd => q{dd.MM.y},
			yQQQ => q{QQQ y 'ш'.},
			yQQQQ => q{QQQQ y 'ш'.},
			yw => q{w-'тәи' 'амчыбжь' Y 'ш'.},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Gy => {
				G => q{y 'ш'. G – y 'ш'. G},
				y => q{y–y 'шш'. G},
			},
			GyM => {
				G => q{MM.y G – MM.y G},
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			GyMEd => {
				G => q{ccc, dd.MM.y G – ccc, dd.MM.y G},
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			GyMMM => {
				G => q{LLL y 'ш'. G – LLL y 'ш'. G},
				M => q{LLL – LLL y 'ш'. G},
				y => q{LLL y – LLL y 'шш'. G},
			},
			GyMMMEd => {
				G => q{ccc, d MMM y 'ш'. G – ccc, d MMM y 'ш'. G},
				M => q{ccc, d MMM – ccc, d MMM y 'ш'. G},
				d => q{ccc, d MMM – ccc, d MMM y 'ш'. G},
				y => q{ccc, d MMM y – ccc, d MMM y 'шш'. G},
			},
			GyMMMd => {
				G => q{d MMM y 'ш'. G – d MMM y 'ш'. G},
				M => q{d MMM – d MMM y 'ш'. G},
				d => q{d–d MMM y 'ш'. G},
				y => q{d MMM y – d MMM y 'шш'. G},
			},
			GyMd => {
				G => q{dd.MM.y G – dd.MM.y G},
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{LLL – LLL},
			},
			MMMEd => {
				M => q{ccc, d MMM – ccc, d MMM},
				d => q{ccc, d MMM – ccc, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			y => {
				y => q{y–y 'шш'. G},
			},
			yM => {
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			yMEd => {
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			yMMM => {
				M => q{LLL – LLL y 'ш'. G},
				y => q{LLL y 'ш'. – LLL y 'ш'. G},
			},
			yMMMEd => {
				M => q{ccc, d MMM – ccc, d MMM y 'ш'. G},
				d => q{ccc, d MMM – ccc, d MMM y 'ш'. G},
				y => q{ccc, d MMM y 'ш'. – ccc, d MMM y 'ш'. G},
			},
			yMMMM => {
				M => q{LLLL – LLLL y 'ш'. G},
				y => q{LLLL y 'ш'. – LLLL y 'ш'. G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y 'ш'. G},
				d => q{d–d MMM y 'ш'. G},
				y => q{d MMM y 'ш'. – d MMM y 'ш'. G},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
		},
		'gregorian' => {
			Gy => {
				G => q{y 'ш'. G – y 'ш'. G},
				y => q{y–y 'шш'. G},
			},
			GyM => {
				G => q{MM.y G – MM.y G},
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			GyMEd => {
				G => q{ccc, dd.MM.y G – ccc, dd.MM.y G},
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			GyMMM => {
				G => q{LLL y 'ш'. G – LLL y 'ш'. G},
				M => q{LLL – LLL y 'ш'. G},
				y => q{LLL y – LLL y 'шш'. G},
			},
			GyMMMEd => {
				G => q{ccc, d MMM y 'ш'. G – ccc, d MMM y 'ш'. G},
				M => q{ccc, d MMM – ccc, d MMM y 'ш'. G},
				d => q{ccc, d MMM – ccc, d MMM y 'ш'. G},
				y => q{ccc, d MMM y – ccc, d MMM y 'шш'. G},
			},
			GyMMMd => {
				G => q{d MMM y 'ш'. G – d MMM y 'ш'. G},
				M => q{d MMM – d MMM y 'ш'. G},
				d => q{d–d MMM y 'ш'. G},
				y => q{d MMM y – d MMM y 'шш'. G},
			},
			GyMd => {
				G => q{dd.MM.y G – dd.MM.y G},
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{LLL – LLL},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{ccc, dd.MM.y – ccc, dd.MM.y},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y},
			},
			yMMM => {
				M => q{LLL – LLL y 'ш'.},
				y => q{LLL y 'ш'. – LLL y 'ш'.},
			},
			yMMMEd => {
				M => q{ccc, d MMM – ccc, d MMM y 'ш'.},
				d => q{ccc, d – ccc, d MMM y 'ш'.},
				y => q{ccc, d MMM y 'ш'. – ccc, d MMM y 'ш'.},
			},
			yMMMM => {
				M => q{LLLL – LLLL y 'ш'.},
				y => q{LLLL y 'ш'. – LLLL y 'ш'.},
			},
			yMMMd => {
				M => q{d MMM – d MMM y 'ш'.},
				d => q{d–d MMM y 'ш'.},
				y => q{d MMM y 'ш'. – d MMM y 'ш'.},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0} Аамҭа),
		regionFormat => q({0} Аԥхынтәи Аамҭа),
		regionFormat => q({0} Астандартә Аамҭа),
		'Acre' => {
			long => {
				'daylight' => q#Акри аԥхынтәи аамҭа#,
				'generic' => q#Акри аамҭа#,
				'standard' => q#Акри астандартә аамҭа#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#Афганистан#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмера#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантаир#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-ес-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел-Аиун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Ҳараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Иоҳаннесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Џуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуту#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишо#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровиа#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Наироби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамеи#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Агәҭантәи Африка#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Мрагыларатәи Африка#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Аладатәи Африка#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Мраҭашәаратәи Африка, аԥхынтәи аамҭа#,
				'generic' => q#Мраҭашәаратәи Африка#,
				'standard' => q#Мраҭашәаратәи Африка, астандартә аамҭа#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Алиаска, аԥхынтәи аамҭа#,
				'generic' => q#Алиаска#,
				'standard' => q#Алиаска, астандартә аамҭа#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#Алма-Ата аԥхынтәи аамҭа#,
				'generic' => q#Алма-Ата аамҭа#,
				'standard' => q#Алма-Ата астандартә аамҭа#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазонка, аԥхынтәи аамҭа#,
				'generic' => q#Амазонка#,
				'standard' => q#Амазонка, астандартә аамҭа#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилиа#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаина#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио-Галегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан-Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаиа#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баиа#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баиа-де-Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белен#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Боисе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос-Аирес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кеимбриџ-Беи#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампу-Гранди#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Каиенна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Адгьылбжьахақәа Каиман#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чиуауа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал-Харбор#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куиаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Киурасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Денмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон-Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Салвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нелсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глеис-Беи#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус-Беи#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд-Терк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаиакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гаиана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Ҳалифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Ермосило#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсберг, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл-Сити#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вевеи, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсеннес#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Уинамак#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Иамаика#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуи#,
		},
		'America/Juneau' => {
			exemplarCity => q#Џуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтиселло, Кентукки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендеик#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла-Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анџелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуер-Принс-Куотер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масеио#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиника#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Масатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерреи#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Ниу-Иорк#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норониа#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Боила, Аҩадатәи Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Агәҭа, Аҩадатәи Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Ниу-Сеилем, Аҩадатәи Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спеин#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту-Велиу#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуерто-Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта-Аренас#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин-Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Реџаина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолиут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Риу-Бранку#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарен#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантиаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто-Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорсбисунн#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сен-Бартелеми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Џонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент-Лиусиа#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт-Керрент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уаитхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Иакутат#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Агәҭантәи Америка, аԥхынтәи аамҭа#,
				'generic' => q#Агәҭантәи Америка#,
				'standard' => q#Агәҭантәи Америка, астандартә аамҭа#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Мрагыларатәи Америка, аԥхынтәи аамҭа#,
				'generic' => q#Мрагыларатәи Америка#,
				'standard' => q#Мрагыларатәи Америка, астандартә аамҭа#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Аԥхынтәи ашьхатә аамҭа (Аҩадатәи Америка)#,
				'generic' => q#Ашьхатә аамҭа (Аҩадатәи Америка)#,
				'standard' => q#Астандартә ашьхатә аамҭа (Аҩадатәи Америка)#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Аокеанҭынчтәи аԥхынтәи аамҭа#,
				'generic' => q#Аокеанҭынчтәи аамҭа#,
				'standard' => q#Аокеанҭынчтәи астандартә аамҭа#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#Анадыр аԥхынтәи аамҭа#,
				'generic' => q#аамҭа Анадыр аҿы#,
				'standard' => q#Анадыр астандартә аамҭа#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кеиси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Деивис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Диумон-д’Иурвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мердо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сиова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Амрагылара#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Апиа, аԥхынтәи аамҭа#,
				'generic' => q#Апиа#,
				'standard' => q#Апиа, астандартә аамҭа#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#Актау аԥхынтәи аамҭа#,
				'generic' => q#Актау аамҭа#,
				'standard' => q#Актау, астандартә аамҭа#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#Актобе аԥхынтәи аамҭа#,
				'generic' => q#Актобе аамҭа#,
				'standard' => q#Актобе астандартә аамҭа#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Саудтәи Арабсҭан, аԥхынтәи аамҭа#,
				'generic' => q#Саудтәи Арабсҭан#,
				'standard' => q#Саудтәи Арабсҭан, астандартә аамҭа#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгир#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентина, аԥхынтәи аамҭа#,
				'generic' => q#Аргентина#,
				'standard' => q#Аргентина, астандартә аамҭа#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Мраҭашәаратәи Аргентина, аԥхынтәи аамҭа#,
				'generic' => q#Мраҭашәаратәи Аргентина#,
				'standard' => q#Мраҭашәаратәи Аргентина, астандартә аамҭа#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Ермантәыла, аԥхынтәи аамҭа#,
				'generic' => q#Ермантәыла#,
				'standard' => q#Ермантәыла, астандартә аамҭа#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадыр#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атырау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Беирут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеи#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калкутта#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеврон#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Ҳонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џаиапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Иерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Петропавловск-Камчаткатәи#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноиарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала-Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувеит#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Маскат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосиа#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Уралск#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхениан#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#Костанаи#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызылорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Иангон#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ер-Риад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хошимин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ад-ха Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхаи#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколымск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Таибеи#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Қарҭ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхимпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вентиан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Иакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантикатәи аԥхынтәи аамҭа#,
				'generic' => q#Атлантикатәи аамҭа#,
				'standard' => q#Атлантикатәи астандартә аамҭа#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азортәи ад-хақәа#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермудтәи ад-хақәа#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канартәи ад-хақәа#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарертәи ад-хақәа#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадеира#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Реикиавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Аладатәи Георгиа#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Иԥшьоу Елена ладгьылбжьаха#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен-Хилл#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Иукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд-Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеи#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Агәҭантәи Австралиа, аԥхынтәи аамҭа#,
				'generic' => q#Агәҭантәи Австралиа#,
				'standard' => q#Агәҭантәи Австралиа, астандартә аамҭа#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Агәҭантәи Австралиа, мраҭашәаратәи аԥхынтәи аамҭа#,
				'generic' => q#Агәҭантәи Австралиа, мраҭашәаратәи аамҭа#,
				'standard' => q#Агәҭантәи Австралиа, мраҭашәаратәи астандартә аамҭа#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Мрагыларатәи Австралиа, аԥхынтәи аамҭа#,
				'generic' => q#Мрагыларатәи Австралиа#,
				'standard' => q#Мрагыларатәи Австралиа, астандартә аамҭа#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Мраҭашәаратәи Австралиа, аԥхынтәи аамҭа#,
				'generic' => q#Мраҭашәаратәи Австралиа#,
				'standard' => q#Мраҭашәаратәи Австралиа, астандартә аамҭа#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Азербаиџьан, аԥхынтәи аамҭа#,
				'generic' => q#Азербаиџьан#,
				'standard' => q#Азербаиџьан, астандартә аамҭа#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азортәи ад-хақәа, аԥхынтәи аамҭа#,
				'generic' => q#Азортәи ад-хақәа#,
				'standard' => q#Азортәи ад-хақәа, астандартә аамҭа#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладеш, аԥхынтәи аамҭа#,
				'generic' => q#Бангладеш#,
				'standard' => q#Бангладеш, астандартә аамҭа#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутан#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливиа#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразилиа, аԥхынтәи аамҭа#,
				'generic' => q#Бразилиа#,
				'standard' => q#Бразилиа, астандартә аамҭа#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Брунеи-Даруссалам#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Кабо-Верде, аԥхынтәи аамҭа#,
				'generic' => q#Кабо-Верде#,
				'standard' => q#Кабо-Верде, астандартә аамҭа#,
			},
		},
		'Casey' => {
			long => {
				'standard' => q#Кеиси#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморро#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатем, аԥхынтәи аамҭа#,
				'generic' => q#Чатем#,
				'standard' => q#Чатем, астандартә аамҭа#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чили, аԥхынтәи аамҭа#,
				'generic' => q#Чили#,
				'standard' => q#Чили, астандартә аамҭа#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Китаи, аԥхынтәи аамҭа#,
				'generic' => q#Китаи#,
				'standard' => q#Китаи, астандартә аамҭа#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ад-ха Қьырса#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокостәи ад-хақәа#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумбиа, аԥхынтәи аамҭа#,
				'generic' => q#Колумбиа#,
				'standard' => q#Колумбиа, астандартә аамҭа#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Кук идгьылбжьахақәа, полуаԥхынтәи аамҭа#,
				'generic' => q#Кук идгьылбжьахақәа#,
				'standard' => q#Кук идгьылбжьахақәа, астандартә аамҭа#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Куба, аԥхынтәи аамҭа#,
				'generic' => q#Куба#,
				'standard' => q#Куба, астандартә аамҭа#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Деивис#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Диумон-д’Иурвил#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Мрагыларатәи Тимор#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ад-ха Пасхи, аԥхынтәи аамҭа#,
				'generic' => q#ад-ха Пасхи#,
				'standard' => q#ад-ха Пасхи, астандартә аамҭа#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Еквадор#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Еилкаам ақалақь#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахан#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афин#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Бриуссел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Биузинген-Хыхьтәи-Реине#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенҳаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q#Аирланд Астандартә Аамҭа#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ад-ха Мен#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Стамбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Лиублиана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Англиа Аԥхынтәи Аамҭа#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Лиуксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопол#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопе#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софиа#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокҳолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Улиановск#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилниус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Циурих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Агәҭантәи Европа, аԥхынтәи аамҭа#,
				'generic' => q#Агәҭантәи Европа#,
				'standard' => q#Агәҭантәи Европа, астандартә аамҭа#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Мрагыларатәи Европа, аԥхынтәи аамҭа#,
				'generic' => q#Мрагыларатәи Европа#,
				'standard' => q#Мрагыларатәи Европа, астандартә аамҭа#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Московатәи аамҭа#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Мраҭашәаратәи Европа, аԥхынтәи аамҭа#,
				'generic' => q#Мраҭашәаратәи Европа#,
				'standard' => q#Мраҭашәаратәи Европа, астандартә аамҭа#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолклендтәи ад-хақәа, аԥхынтәи аамҭа#,
				'generic' => q#Фолклендтәи ад-хақәа#,
				'standard' => q#Фолклендтәи ад-хақәа, астандартә аамҭа#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фиџи, аԥхынтәи аамҭа#,
				'generic' => q#Фиџи#,
				'standard' => q#Фиџи, астандартә аамҭа#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Францызтәи Гвиана#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Францызтәи Аладатәеи Антарктикатәи рҵакырадгьылқәа#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Агринвич Ибжьаратәу Аамҭа#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагостәи ад-хақәа#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбе#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Қырҭтәыла, аԥхынтәи аамҭа#,
				'generic' => q#Қырҭтәыла#,
				'standard' => q#Қырҭтәыла, астандартә аамҭа#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ад-хақәа Гилберта#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Мрагыларатәи Гренландиа, аԥхынтәи аамҭа#,
				'generic' => q#Мрагыларатәи Гренландиа#,
				'standard' => q#Мрагыларатәи Гренландиа, стандарное времиа#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Мраҭашәаратәи Гренландиа, аԥхынтәи аамҭа#,
				'generic' => q#Мраҭашәаратәи Гренландиа#,
				'standard' => q#Мраҭашәаратәи Гренландиа, астандартә аамҭа#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#Гуам#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Аџьамтә аӡыбжьахала#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гаиана#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Ҳаваи-алеуттәи аԥхынтәи аамҭа#,
				'generic' => q#Ҳаваи-алеуттәи аамҭа#,
				'standard' => q#Ҳаваи-алеуттәи астандартә аамҭа#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Ҳонконг, аԥхынтәи аамҭа#,
				'generic' => q#Ҳонконг#,
				'standard' => q#Ҳонконг, астандартә аамҭа#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховд, аԥхынтәи аамҭа#,
				'generic' => q#Ховд#,
				'standard' => q#Ховд, астандартә аамҭа#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Индиа#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариву#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ад-ха Қьырса#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокостәи ад-хақәа#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Комор#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Мае#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдив#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврики#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Маиотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реиунон#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Индиатәи аокеан#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Индокитаи#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Агәҭантәи Индонезиа#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Мрагыларатәи Индонезиа#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Мраҭашәаратәи Индонезиа#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Иран, аԥхынтәи аамҭа#,
				'generic' => q#Иран#,
				'standard' => q#Иран, астандартә аамҭа#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Иркутск, аԥхынтәи аамҭа#,
				'generic' => q#Иркутск#,
				'standard' => q#Иркутск, астандартә аамҭа#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израиль, аԥхынтәи аамҭа#,
				'generic' => q#Израиль#,
				'standard' => q#Израиль, астандартә аамҭа#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Иапониа, аԥхынтәи аамҭа#,
				'generic' => q#Иапониа#,
				'standard' => q#Иапониа, астандартә аамҭа#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#Петропавловск-Камчаткатәи, аԥхынтәи аамҭа#,
				'generic' => q#Петропавловск-Камчаткатәи#,
				'standard' => q#Петропавловск-Камчаткатәи, астандартә аамҭа#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Мрагыларатәи Ҟазахсҭан#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Мраҭашәаратәи Ҟазахсҭан#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Кореиа, аԥхынтәи аамҭа#,
				'generic' => q#Кореиа#,
				'standard' => q#Кореиа, астандартә аамҭа#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Косрае#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Красноиарск, аԥхынтәи аамҭа#,
				'generic' => q#Красноиарск#,
				'standard' => q#Красноиарск, астандартә аамҭа#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Киргизиа#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#Шри-Ланка#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ад-хақәа Лаин#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд-Ҳау, аԥхынтәи аамҭа#,
				'generic' => q#Лорд-Ҳау#,
				'standard' => q#Лорд-Ҳау, астандартә аамҭа#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#Макао, аԥхынтәи аамҭа#,
				'generic' => q#Макао#,
				'standard' => q#Макао, астандартә аамҭа#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магадан, аԥхынтәи аамҭа#,
				'generic' => q#Магадан#,
				'standard' => q#Магадан, астандартә аамҭа#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малаизиа#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Мальдив#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркизтәи ад-хақәа#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршаллтәи Адгьылбжьахақәа#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маврики, аԥхынтәи аамҭа#,
				'generic' => q#Маврики#,
				'standard' => q#Маврики, астандартә аамҭа#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Моусон#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Аокеанҭынчтәи амексикатә аԥхынтәи аамҭа#,
				'generic' => q#Аокеанҭынчтәи амексикатә аамҭа#,
				'standard' => q#Аокеанҭынчтәи амексикатә астандартә аамҭа#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улан-Батор, аԥхынтәи аамҭа#,
				'generic' => q#Улан-Батор#,
				'standard' => q#Улан-Батор, астандартә аамҭа#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Москва, аԥхынтәи аамҭа#,
				'generic' => q#Москва#,
				'standard' => q#Москва, астандартә аамҭа#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мианма#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науру#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Непал#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Каледониа ҿыц, аԥхынтәи аамҭа#,
				'generic' => q#Каледониа ҿыц#,
				'standard' => q#Каледониа ҿыц, астандартә аамҭа#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Зеландиа ҿыц, аԥхынтәи аамҭа#,
				'generic' => q#Зеландиа ҿыц#,
				'standard' => q#Зеландиа ҿыц, астандартә аамҭа#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Ниуфаундленд, аԥхынтәи аамҭа#,
				'generic' => q#Ниуфаундленд#,
				'standard' => q#Ниуфаундленд, астандартә аамҭа#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуе#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Норфолк, аԥхынтәи аамҭа#,
				'generic' => q#Норфолк#,
				'standard' => q#Норфолк, астандартә аамҭа#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернанду-ди-Норониа, аԥхынтәи аамҭа#,
				'generic' => q#Фернанду-ди-Норониа#,
				'standard' => q#Фернанду-ди-Норониа, астандартә аамҭа#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#Аҩадатәи Мариантәи ад-хақәа#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирск, аԥхынтәи аамҭа#,
				'generic' => q#Новосибирск#,
				'standard' => q#Новосибирск, астандартә аамҭа#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омск, аԥхынтәи аамҭа#,
				'generic' => q#Омск#,
				'standard' => q#Омск, астандартә аамҭа#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвил#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ад-ха Пасхи#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефате#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагостәи ад-хақәа#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ад-хақәа Гамбе#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#Кантон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалеин#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маџуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркизтәи ад-хақәа#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ад-хақәа Мидуеи#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго-Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпеи#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Саипан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уеик#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакистан, аԥхынтәи аамҭа#,
				'generic' => q#Пакистан#,
				'standard' => q#Пакистан, астандартә аамҭа#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палау#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа — Гвинеиа ҿыц#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагваи, аԥхынтәи аамҭа#,
				'generic' => q#Парагваи#,
				'standard' => q#Парагваи, астандартә аамҭа#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перу, аԥхынтәи аамҭа#,
				'generic' => q#Перу#,
				'standard' => q#Перу, астандартә аамҭа#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филиппин, аԥхынтәи аамҭа#,
				'generic' => q#Филиппин#,
				'standard' => q#Филиппин, астандартә аамҭа#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ад-хақәа Феникс#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сен-Пиери Микелони, аԥхынтәи аамҭа#,
				'generic' => q#Сен-Пиери Микелони#,
				'standard' => q#Сен-Пиери Микелони, астандартә аамҭа#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкерн#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понпеи#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пхениан#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#Кызылорда, аԥхынтәи аамҭа*#,
				'generic' => q#Кызылорда*#,
				'standard' => q#Кызылорда, астандартә аамҭа*#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реиунон#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротера#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалин, аԥхынтәи аамҭа#,
				'generic' => q#Сахалин#,
				'standard' => q#Сахалин, астандартә аамҭа#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#Самартәи аԥхынтәи аамҭа#,
				'generic' => q#аамҭа Самараҿы#,
				'standard' => q#Самартәи астандартә аамҭа#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоа, аԥхынтәи аамҭа#,
				'generic' => q#Самоа#,
				'standard' => q#Самоа, астандартә аамҭа#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сеишелтәи адгьылбжьахақәа#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапур#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломонтәи адгьылбжьахақәа#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Аладатәи Георгиа#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринам#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Сиова#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Таити#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Таиван, аԥхынтәи аамҭа#,
				'generic' => q#Таиван#,
				'standard' => q#Таиван, астандартә аамҭа#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Таџьықсҭан#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелау#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонга, аԥхынтәи аамҭа#,
				'generic' => q#Тонга#,
				'standard' => q#Тонга, астандартә аамҭа#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Трук#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Туркменистан, аԥхынтәи аамҭа#,
				'generic' => q#Туркменистан#,
				'standard' => q#Туркменистан, астандартә аамҭа#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалу#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругваи, аԥхынтәи аамҭа#,
				'generic' => q#Уругваи#,
				'standard' => q#Уругваи, астандартә аамҭа#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Узбеқьисҭан, аԥхынтәи аамҭа#,
				'generic' => q#Узбеқьисҭан#,
				'standard' => q#Узбеқьисҭан, астандартә аамҭа#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануату, аԥхынтәи аамҭа#,
				'generic' => q#Вануату#,
				'standard' => q#Вануату, астандартә аамҭа#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венесуела#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивосток, аԥхынтәи аамҭа#,
				'generic' => q#Владивосток#,
				'standard' => q#Владивосток, астандартә аамҭа#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоград, аԥхынтәи аамҭа#,
				'generic' => q#Волгоград#,
				'standard' => q#Волгоград, астандартә аамҭа#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Амрагылара#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Уеик#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Уоллиси Футунеи#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Иакутск, аԥхынтәи аамҭа#,
				'generic' => q#Иакутск#,
				'standard' => q#Иакутск, астандартә аамҭа#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екатеринбург, аԥхынтәи аамҭа#,
				'generic' => q#Екатеринбург#,
				'standard' => q#Екатеринбург, астандартә аамҭа#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#Иукон#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
