/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullBox;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FullContainerBox
extends AbstractContainerBox
implements FullBox {
    private static Logger LOG = Logger.getLogger(FullContainerBox.class.getName());
    private int version;
    private int flags;

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    public FullContainerBox(String type) {
        super(type);
    }

    @Override
    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer versionAndFlags = ByteBuffer.allocate(4);
        dataSource.read(versionAndFlags);
        this.parseVersionAndFlags((ByteBuffer)versionAndFlags.rewind());
        super.parse(dataSource, header, contentSize, boxParser);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        super.getBox(writableByteChannel);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[childBoxes]";
    }

    protected final long parseVersionAndFlags(ByteBuffer content) {
        this.version = IsoTypeReader.readUInt8(content);
        this.flags = IsoTypeReader.readUInt24(content);
        return 4L;
    }

    protected final void writeVersionAndFlags(ByteBuffer bb) {
        IsoTypeWriter.writeUInt8(bb, this.version);
        IsoTypeWriter.writeUInt24(bb, this.flags);
    }

    @Override
    protected ByteBuffer getHeader() {
        ByteBuffer header;
        if (this.largeBox || this.getSize() >= 0x100000000L) {
            byte[] byArray = new byte[20];
            byArray[3] = 1;
            byArray[4] = this.type.getBytes()[0];
            byArray[5] = this.type.getBytes()[1];
            byArray[6] = this.type.getBytes()[2];
            byArray[7] = this.type.getBytes()[3];
            header = ByteBuffer.wrap(byArray);
            header.position(8);
            IsoTypeWriter.writeUInt64(header, this.getSize());
            this.writeVersionAndFlags(header);
        } else {
            byte[] byArray = new byte[12];
            byArray[4] = this.type.getBytes()[0];
            byArray[5] = this.type.getBytes()[1];
            byArray[6] = this.type.getBytes()[2];
            byArray[7] = this.type.getBytes()[3];
            header = ByteBuffer.wrap(byArray);
            IsoTypeWriter.writeUInt32(header, this.getSize());
            header.position(8);
            this.writeVersionAndFlags(header);
        }
        header.rewind();
        return header;
    }
}

