/*
 * C_FILTER.CPP
 * Connection filter for WinFBB BBS software. (C) PE1OZA 1996.
 * Compiles with BCW 4.02
 * Example version.
 */

#define STRICT
#include <windows.h>
#pragma hdrstop
#include <string.h>  /* string functions, runtime library needed */
#include <stdlib.h>  /* standard library definitions */

/*
 * function prototype definition
 */

extern "C" int FAR PASCAL SVC_MAIN(int , char** far , char* far , int);

/*
 * Connetion filter called for each single connection.
 *
 * Filter is called with some arguments on the command line :
 *
 * Callsign is in the FORM CALLSIGN-SSID (F6FBB-0).
 *
 * The first time C_FILTER is called Level=0, and then will be incremented
 * each time it is called for the same connection.
 *
 * Flags give the flags of the user (MGPBSXLE) in a bit field. as defined
 * in the INIT.SRV user's mask. (0x80=Modem, 0x40=Guest, etc...)
 *
 * If New=1, then this is the first connection of the user on the BBS.
 * Record is the record number in the INF.SYS file.
 *
 * All other arguments are the words sent by the user
 * (password for instance).
 *
 * The number of arguments is variable and depends of the number of words
 * in the answer of the user.
 *
 * The return value tells the BBS if C_FILTER must be called again or not
 * 0 if the BBS can continue.
 * 1 if the FILTER must be called again. (with user argument(s))
 * 2 if the user must immediately be disconnected.
 *
 *
 * WinFBB 7.00 DLL info :
 *
 * Function declaration in the DLL
 *
 * int _export FAR PASCAL svc_main(int argc, char FAR **argv,
 *                                  char FAR *r_buf, int buflen)
 *
 * argc  = Number of arguments. (Like DOS)
 * argv  = Arguments in an array. (Like DOS)
 * r_buf  = Buffer to store the return-text in.
 * buflen = The size of r_buf, set by FBB. (normally 1024)
 *
 * argv[0]="C_FILTER" (or "M_FILTER") (or 'PG name')
 * argv[1]=Callsign of user with SSID ("PE1OZA-0")
 * argv[2]=Calling level number (0 is the first time, up to 99).
 * argv[3]=Flags of the user (binary number as user's mask of INIT.SRV).
 * argv[4]=New : Flag indicating if the user is unknown in the BBS database.
 * argv[5]=Record number of the user in INF.SYS.
 * argv[6]=Port (tnc) number. (not channel!). (0 for console connect).
 *
 * argv[7]=first user supplied argument.
 *
 * The arrangement of the arguments are different when called as an PG.
 * The arguments are different when called as M_FILTER.
 * Just put the DLL in the PG dir and call it from the BBS prompt.
 *
 */

/*
 * SVC_MAIN() - Server main function
 * No check on maximum filled length of r_buf!
 */

int FAR PASCAL SVC_MAIN(int argc, char FAR **argv, char FAR *r_buf, int buflen)
	{
	strcpy(r_buf, "C_FILTER.DLL simple demo by PE1OZA\n");
	char s[40];
	itoa(buflen, s, 10);
	strcat(r_buf, "return string buffer length : ");
	strcat(r_buf, s);
	strcat(r_buf, "\n");
	itoa(argc, s, 10);
	strcat(r_buf, "number of arguments : ");
	strcat(r_buf, s);
	strcat(r_buf, "\n");
	int i;
	strcat(r_buf, "arguments contents :\n");
	for (i = 0 ; i < argc ; i++)
		{
		strcat(r_buf, "argument [");
		itoa(i, s, 10);
		strcat(r_buf, s);
		strcat(r_buf, "] = ");
		strcat(r_buf, argv[i]);
		strcat(r_buf, "\n");
		}
		return (0);  /* Continue with BBS tasks */
	}

/*
 * LibMain() - DLL initialization routine
 *
 * The LibMain function is required for each DLL.  It is called when
 * the DLL is first loaded.  Any initialization for the library should
 * be done here.  LibMain should return a value of 1 if the
 * initialization is successful. Windows HANDLE = HINSTANCE.
 */

#pragma argsused  /*prevent 'arg not used' warning */
int FAR PASCAL LibMain (HINSTANCE hInstance, WORD wDataSeg,
								WORD cbHeapSize, LPSTR lpCmdLine)
{
	return (1);	/* return 1 = success ; 0 = fail */
}

/*
 * WEP - DLL cleanup routine
 *
 * The WEP function should also be found in each DLL.  It is called when
 * the DLL is unloaded.  There is no valid return value.
 */

#pragma argsused
int FAR PASCAL WEP (int bSystemExit )
{
	return (1);
}

