/* saying.c by Mike Wilson G4GOU 15 June 1992 */
#include	<stdio.h>
#include        <string.h>
#include	<stdlib.h>
#include	<time.h>
#include 	"mdw.h"

#define SYSTEM 5  /* system directory from INIT.SRV */

int  get_saying(char *ch);
int  get_param(int p, char *ch);
void f_error(int e, char *ch);

int main()
{
 char saying[240];
 char buff[240];
 char f_name[40];
 char daytime[240];
 char *pos_text;
 FILE *say;
 FILE *ent;

 struct tm times;
 time_t tim_secs;

/* get the time */
 tim_secs = time(NULL);
 times = *localtime(&tim_secs);

 if (times.tm_hour < 12)
    strcpy(daytime,"morning");
    else if (times.tm_hour < 18)
            strcpy(daytime,"afternoon");
         else
             strcpy(daytime,"evening");

/* get the system directory */
 if (get_param(SYSTEM,buff))
 {
  buff[strlen(buff)-1] = '\0';
  strcat(buff,"lang\\");
 }
 else
 {
  f_error(1,"INIT.SRV");
 }

/* get a saying */
 if (NOT get_saying(saying))
 {
  f_error(2,"SAYINGS");
 }

 /* open ENGLISH.SAY */
 strcpy(f_name,buff);
 strcat(f_name,"english.say");
 if((say = fopen(f_name,"r")) IS NULL)
 {
  f_error(3,f_name);
 }

 /* open ENGLISH.ENT */
 strcpy(f_name,buff);
 strcat(f_name,"english.ent");
 if((ent = fopen(f_name,"w")) IS NULL)
 {
  f_error(4,f_name);
 }

/* copy ENGLISH.SAY to ENGLISH.ENT */
  while (fgets(buff,240,say) ISNT NULL)
       {
	   /* Insert the saying at $saying */
        if ((pos_text = strstr(buff,"$saying")) ISNT NULL)
           {
            strcat(saying,pos_text+7);
            *pos_text = '\0';
            strcat(buff,saying);
           }
	   /* Insert the daytime at $day */
        if ((pos_text = strstr(buff,"$day")) ISNT NULL)
           {
            strcat(daytime,pos_text+4);
            *pos_text = '\0';
            strcat(buff,daytime);
           }
        fputs(buff,ent);
       }
  fclose(ent);
  fclose(say);
  exit(0);

}

int get_param(int param_no, char *temp_buff)
/* find a parameter in INIT.SRV */
{
 FILE *fl;
 int count;

 if((fl = fopen("init.srv","r")) ISNT NULL)
 {
  for (count = param_no;count > 0;count--)
  {
   fgets(temp_buff,80,fl);
   if (temp_buff[0] IS '#')
      count++;
  }
  fclose(fl);
  return(TRUE);
 }
 return(FALSE);
}

int get_saying(char *temp_buff)
/* read a saying at random */
{
 FILE *fl;
 long pos;

 randomize();
 if((fl = fopen("sayings","r")) ISNT NULL)
 {
  while(TRUE)
             {
              pos = (long) rand();
              fseek(fl,pos,0);
              if(!feof(fl))
              {
               fgets(temp_buff,240,fl);
               if(fgets(temp_buff,240,fl) > 0)
               {
                temp_buff[strlen(temp_buff)-1] = '\0';
                fclose(fl);
                return(TRUE);
               }
              }
             }
 }
 return(FALSE);
}

void f_error(int e_num,char e_msg[])
/* exit with error code */
{
 printf("Unable to open %s\n",e_msg);
 exit(e_num);
}
