/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.ipc.HandshakeRequest;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.Ipc;
import org.apache.avro.ipc.MD5;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;

public class RpcProtocolTool
implements Tool {
    @Override
    public String getName() {
        return "rpcprotocol";
    }

    @Override
    public String getShortDescription() {
        return "Output the protocol of a RPC service";
    }

    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() != 1) {
            err.println("Usage: uri");
            return 1;
        }
        URI uri = URI.create(args.get(0));
        try (Transceiver transceiver = Ipc.createTransceiver((URI)uri);){
            HandshakeRequest rq = HandshakeRequest.newBuilder().setClientHash(new MD5(new byte[16])).setServerHash(new MD5(new byte[16])).setClientProtocol(null).setMeta(new LinkedHashMap()).build();
            SpecificDatumWriter handshakeWriter = new SpecificDatumWriter(HandshakeRequest.class);
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteBufferOutputStream, null);
            handshakeWriter.write((Object)rq, (Encoder)encoder);
            encoder.flush();
            List response = transceiver.transceive(byteBufferOutputStream.getBufferList());
            ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(response);
            SpecificDatumReader handshakeReader = new SpecificDatumReader(HandshakeResponse.class);
            HandshakeResponse handshakeResponse = (HandshakeResponse)handshakeReader.read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)byteBufferInputStream, null));
            Protocol p = Protocol.parse((String)handshakeResponse.getServerProtocol());
            out.println(p.toString(true));
        }
        return 0;
    }
}

