/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.csm.observability;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.grpc.CallOptions;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.opentelemetry.InternalOpenTelemetryPlugin;
import io.grpc.opentelemetry.OpenTelemetryPlugin;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.contrib.gcp.resource.GCPResourceProvider;
import io.opentelemetry.sdk.autoconfigure.ResourceConfiguration;
import java.net.URI;
import java.util.Map;
import java.util.function.Consumer;

final class MetadataExchanger
implements InternalOpenTelemetryPlugin {
    private static final AttributeKey<String> CLOUD_PLATFORM = AttributeKey.stringKey((String)"cloud.platform");
    private static final AttributeKey<String> K8S_NAMESPACE_NAME = AttributeKey.stringKey((String)"k8s.namespace.name");
    private static final AttributeKey<String> K8S_CLUSTER_NAME = AttributeKey.stringKey((String)"k8s.cluster.name");
    private static final AttributeKey<String> CLOUD_AVAILABILITY_ZONE = AttributeKey.stringKey((String)"cloud.availability_zone");
    private static final AttributeKey<String> CLOUD_REGION = AttributeKey.stringKey((String)"cloud.region");
    private static final AttributeKey<String> CLOUD_ACCOUNT_ID = AttributeKey.stringKey((String)"cloud.account.id");
    private static final Metadata.Key<String> SEND_KEY = Metadata.Key.of((String)"x-envoy-peer-metadata", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<Struct> RECV_KEY = Metadata.Key.of((String)"x-envoy-peer-metadata", new BinaryToAsciiMarshaller(ProtoUtils.metadataMarshaller((Message)Struct.getDefaultInstance())));
    private static final String EXCHANGE_TYPE = "type";
    private static final String EXCHANGE_CANONICAL_SERVICE = "canonical_service";
    private static final String EXCHANGE_PROJECT_ID = "project_id";
    private static final String EXCHANGE_LOCATION = "location";
    private static final String EXCHANGE_CLUSTER_NAME = "cluster_name";
    private static final String EXCHANGE_NAMESPACE_NAME = "namespace_name";
    private static final String EXCHANGE_WORKLOAD_NAME = "workload_name";
    private static final String TYPE_GKE = "gcp_kubernetes_engine";
    private static final String TYPE_GCE = "gcp_compute_engine";
    private final String localMetadata;
    private final Attributes localAttributes;

    public MetadataExchanger() {
        this(MetadataExchanger.addOtelResourceAttributes(new GCPResourceProvider().getAttributes()), System::getenv);
    }

    MetadataExchanger(Attributes platformAttributes, Lookup env) {
        String type = (String)platformAttributes.get(CLOUD_PLATFORM);
        String canonicalService = env.get("CSM_CANONICAL_SERVICE_NAME");
        Struct.Builder struct = Struct.newBuilder();
        MetadataExchanger.put(struct, EXCHANGE_TYPE, type);
        MetadataExchanger.put(struct, EXCHANGE_CANONICAL_SERVICE, canonicalService);
        if (TYPE_GKE.equals(type)) {
            String location = (String)platformAttributes.get(CLOUD_AVAILABILITY_ZONE);
            if (location == null) {
                location = (String)platformAttributes.get(CLOUD_REGION);
            }
            MetadataExchanger.put(struct, EXCHANGE_WORKLOAD_NAME, env.get("CSM_WORKLOAD_NAME"));
            MetadataExchanger.put(struct, EXCHANGE_NAMESPACE_NAME, (String)platformAttributes.get(K8S_NAMESPACE_NAME));
            MetadataExchanger.put(struct, EXCHANGE_CLUSTER_NAME, (String)platformAttributes.get(K8S_CLUSTER_NAME));
            MetadataExchanger.put(struct, EXCHANGE_LOCATION, location);
            MetadataExchanger.put(struct, EXCHANGE_PROJECT_ID, (String)platformAttributes.get(CLOUD_ACCOUNT_ID));
        } else if (TYPE_GCE.equals(type)) {
            String location = (String)platformAttributes.get(CLOUD_AVAILABILITY_ZONE);
            if (location == null) {
                location = (String)platformAttributes.get(CLOUD_REGION);
            }
            MetadataExchanger.put(struct, EXCHANGE_WORKLOAD_NAME, env.get("CSM_WORKLOAD_NAME"));
            MetadataExchanger.put(struct, EXCHANGE_LOCATION, location);
            MetadataExchanger.put(struct, EXCHANGE_PROJECT_ID, (String)platformAttributes.get(CLOUD_ACCOUNT_ID));
        }
        this.localMetadata = BaseEncoding.base64().encode(struct.build().toByteArray());
        this.localAttributes = Attributes.builder().put("csm.mesh_id", MetadataExchanger.nullIsUnknown(env.get("CSM_MESH_ID"))).put("csm.workload_canonical_service", MetadataExchanger.nullIsUnknown(canonicalService)).build();
    }

    private static String nullIsUnknown(String value) {
        return value == null ? "unknown" : value;
    }

    private static void put(Struct.Builder struct, String key, String value) {
        value = MetadataExchanger.nullIsUnknown(value);
        struct.putFields(key, Value.newBuilder().setStringValue(value).build());
    }

    private static void put(AttributesBuilder attributes, String key, Value value) {
        attributes.put(key, MetadataExchanger.nullIsUnknown(MetadataExchanger.fromValue(value)));
    }

    private static String fromValue(Value value) {
        if (value == null) {
            return null;
        }
        if (value.getKindCase() != Value.KindCase.STRING_VALUE) {
            return null;
        }
        return value.getStringValue();
    }

    private static Attributes addOtelResourceAttributes(Attributes platformAttributes) {
        Attributes envAttributes = ResourceConfiguration.createEnvironmentResource().getAttributes();
        AttributesBuilder builder = platformAttributes.toBuilder();
        builder.putAll(envAttributes);
        return builder.build();
    }

    private void addLabels(AttributesBuilder to, Struct struct) {
        to.putAll(this.localAttributes);
        Map remote = struct.getFieldsMap();
        Value typeValue = (Value)remote.get(EXCHANGE_TYPE);
        String type = MetadataExchanger.fromValue(typeValue);
        MetadataExchanger.put(to, "csm.remote_workload_type", typeValue);
        MetadataExchanger.put(to, "csm.remote_workload_canonical_service", (Value)remote.get(EXCHANGE_CANONICAL_SERVICE));
        if (TYPE_GKE.equals(type)) {
            MetadataExchanger.put(to, "csm.remote_workload_project_id", (Value)remote.get(EXCHANGE_PROJECT_ID));
            MetadataExchanger.put(to, "csm.remote_workload_location", (Value)remote.get(EXCHANGE_LOCATION));
            MetadataExchanger.put(to, "csm.remote_workload_cluster_name", (Value)remote.get(EXCHANGE_CLUSTER_NAME));
            MetadataExchanger.put(to, "csm.remote_workload_namespace_name", (Value)remote.get(EXCHANGE_NAMESPACE_NAME));
            MetadataExchanger.put(to, "csm.remote_workload_name", (Value)remote.get(EXCHANGE_WORKLOAD_NAME));
        } else if (TYPE_GCE.equals(type)) {
            MetadataExchanger.put(to, "csm.remote_workload_project_id", (Value)remote.get(EXCHANGE_PROJECT_ID));
            MetadataExchanger.put(to, "csm.remote_workload_location", (Value)remote.get(EXCHANGE_LOCATION));
            MetadataExchanger.put(to, "csm.remote_workload_name", (Value)remote.get(EXCHANGE_WORKLOAD_NAME));
        }
    }

    public boolean enablePluginForChannel(String target) {
        URI uri;
        try {
            uri = new URI(target);
        }
        catch (Exception ex) {
            return false;
        }
        String authority = uri.getAuthority();
        return "xds".equals(uri.getScheme()) && (authority == null || "traffic-director-global.xds.googleapis.com".equals(authority));
    }

    public InternalOpenTelemetryPlugin.ClientCallPlugin newClientCallPlugin() {
        return new ClientCallState();
    }

    public void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        serverBuilder.intercept((ServerInterceptor)new ServerCallInterceptor());
    }

    public OpenTelemetryPlugin.ServerStreamPlugin newServerStreamPlugin(Metadata inboundMetadata) {
        return new ServerStreamState((Struct)inboundMetadata.get(RECV_KEY));
    }

    static final class BinaryToAsciiMarshaller<T>
    implements Metadata.AsciiMarshaller<T> {
        private final Metadata.BinaryMarshaller<T> delegate;

        public BinaryToAsciiMarshaller(Metadata.BinaryMarshaller<T> delegate) {
            this.delegate = (Metadata.BinaryMarshaller)Preconditions.checkNotNull(delegate, (Object)"delegate");
        }

        public T parseAsciiString(String serialized) {
            return (T)this.delegate.parseBytes(BaseEncoding.base64().decode((CharSequence)serialized));
        }

        public String toAsciiString(T value) {
            return BaseEncoding.base64().encode(this.delegate.toBytes(value));
        }
    }

    static interface Supplier<T> {
        public T get() throws Exception;
    }

    static interface Lookup {
        public String get(String var1);
    }

    final class ServerStreamState
    implements OpenTelemetryPlugin.ServerStreamPlugin {
        private final Struct receivedExchange;

        ServerStreamState(Struct exchange) {
            if (exchange == null) {
                exchange = Struct.getDefaultInstance();
            }
            this.receivedExchange = exchange;
        }

        public void addLabels(AttributesBuilder to) {
            MetadataExchanger.this.addLabels(to, this.receivedExchange);
        }
    }

    final class ServerCallInterceptor
    implements ServerInterceptor {
        ServerCallInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            if (!headers.containsKey(RECV_KEY)) {
                return next.startCall(call, headers);
            }
            return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){
                private boolean headersSent;

                public void sendHeaders(Metadata headers) {
                    this.headersSent = true;
                    headers.put(SEND_KEY, (Object)MetadataExchanger.this.localMetadata);
                    super.sendHeaders(headers);
                }

                public void close(Status status, Metadata trailers) {
                    if (!this.headersSent) {
                        trailers.put(SEND_KEY, (Object)MetadataExchanger.this.localMetadata);
                    }
                    super.close(status, trailers);
                }
            }, headers);
        }
    }

    final class ClientCallState
    implements InternalOpenTelemetryPlugin.ClientCallPlugin {
        private volatile Value serviceName;
        private volatile Value serviceNamespace;

        ClientCallState() {
        }

        public InternalOpenTelemetryPlugin.ClientStreamPlugin newClientStreamPlugin() {
            return new ClientStreamState();
        }

        public CallOptions filterCallOptions(CallOptions options) {
            Consumer existingConsumer = (Consumer)options.getOption(ClusterImplLoadBalancerProvider.FILTER_METADATA_CONSUMER);
            return options.withOption(ClusterImplLoadBalancerProvider.FILTER_METADATA_CONSUMER, clusterMetadata -> {
                this.metadataConsumer((Map<String, Struct>)clusterMetadata);
                existingConsumer.accept(clusterMetadata);
            });
        }

        private void metadataConsumer(Map<String, Struct> clusterMetadata) {
            Struct struct = clusterMetadata.get("com.google.csm.telemetry_labels");
            if (struct == null) {
                struct = Struct.getDefaultInstance();
            }
            this.serviceName = (Value)struct.getFieldsMap().get("service_name");
            this.serviceNamespace = (Value)struct.getFieldsMap().get("service_namespace");
        }

        public void addMetadata(Metadata toMetadata) {
            toMetadata.put(SEND_KEY, (Object)MetadataExchanger.this.localMetadata);
        }

        class ClientStreamState
        implements InternalOpenTelemetryPlugin.ClientStreamPlugin {
            private Struct receivedExchange;

            ClientStreamState() {
            }

            public void inboundHeaders(Metadata headers) {
                this.setExchange(headers);
            }

            public void inboundTrailers(Metadata trailers) {
                if (this.receivedExchange != null) {
                    return;
                }
                this.setExchange(trailers);
            }

            private void setExchange(Metadata metadata) {
                Struct received = (Struct)metadata.get(RECV_KEY);
                this.receivedExchange = received == null ? Struct.getDefaultInstance() : received;
            }

            public void addLabels(AttributesBuilder to) {
                MetadataExchanger.put(to, "csm.service_name", ClientCallState.this.serviceName);
                MetadataExchanger.put(to, "csm.service_namespace_name", ClientCallState.this.serviceNamespace);
                Struct exchange = this.receivedExchange;
                if (exchange == null) {
                    exchange = Struct.getDefaultInstance();
                }
                MetadataExchanger.this.addLabels(to, exchange);
            }
        }
    }
}

