/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.net.InetSocketAddress;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumServerTest
extends ZKTestCase {
    private String ipv6n1 = "[2500:0:0:0:0:0:1:0]";
    private String ipv6n2 = "[2600:0:0:0:0:0:1:0]";
    private String ipv4config = "127.0.0.1:1234:1236";

    @AfterEach
    public void tearDown() {
        System.clearProperty("zookeeper.multiAddress.enabled");
    }

    @Test
    public void testToString() throws QuorumPeerConfig.ConfigException {
        String provided = this.ipv4config + ":participant;0.0.0.0:1237";
        String expected = this.ipv4config + ":participant;0.0.0.0:1237";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, provided);
        Assertions.assertEquals((Object)expected, (Object)qs.toString(), (String)"Use IP address");
        provided = this.ipv4config + ";0.0.0.0:1237";
        expected = this.ipv4config + ":participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assertions.assertEquals((Object)expected, (Object)qs.toString(), (String)"Type unspecified");
        provided = this.ipv4config + ":observer;0.0.0.0:1237";
        expected = this.ipv4config + ":observer;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assertions.assertEquals((Object)expected, (Object)qs.toString(), (String)"Observer type");
        provided = this.ipv4config + ":participant;1237";
        expected = this.ipv4config + ":participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assertions.assertEquals((Object)expected, (Object)qs.toString(), (String)"Client address unspecified");
        provided = this.ipv4config + ":participant;1.2.3.4:1237";
        expected = this.ipv4config + ":participant;1.2.3.4:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assertions.assertEquals((Object)expected, (Object)qs.toString(), (String)"Client address specified");
        provided = "example.com:1234:1236:participant;1237";
        expected = "example.com:1234:1236:participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assertions.assertEquals((Object)expected, (Object)qs.toString(), (String)"Use hostname");
    }

    @Test
    public void constructionUnderstandsIpv6LiteralsInServerConfig() throws QuorumPeerConfig.ConfigException {
        String config = "[::1]:1234:1236:participant";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, config);
        Assertions.assertEquals((Object)"[0:0:0:0:0:0:0:1]:1234:1236:participant", (Object)qs.toString());
    }

    @Test
    public void constructionUnderstandsIpv6LiteralsInClientConfig() throws QuorumPeerConfig.ConfigException {
        String config = this.ipv4config + ":participant;[::1]:1237";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, config);
        Assertions.assertEquals((Object)(this.ipv4config + ":participant;[0:0:0:0:0:0:0:1]:1237"), (Object)qs.toString());
    }

    @Test
    public void unbalancedIpv6LiteralsInServerConfigFailToBeParsed() {
        Assertions.assertThrows(QuorumPeerConfig.ConfigException.class, () -> new QuorumPeer.QuorumServer(0L, "[::1:1234:1236:participant"));
    }

    @Test
    public void unbalancedIpv6LiteralsInClientConfigFailToBeParsed() {
        Assertions.assertThrows(QuorumPeerConfig.ConfigException.class, () -> new QuorumPeer.QuorumServer(0L, this.ipv4config + ":participant;[::1:1237"));
    }

    @Test
    public void shouldNotAllowMultipleAddressesWhenMultiAddressFeatureIsDisabled() {
        Assertions.assertThrows(QuorumPeerConfig.ConfigException.class, () -> {
            System.setProperty("zookeeper.multiAddress.enabled", "false");
            new QuorumPeer.QuorumServer(0L, "127.0.0.1:1234:1236|127.0.0.1:2234:2236");
        });
    }

    @Test
    public void shouldAllowMultipleAddressesWhenMultiAddressFeatureIsEnabled() throws QuorumPeerConfig.ConfigException {
        System.setProperty("zookeeper.multiAddress.enabled", "true");
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, "127.0.0.1:1234:1236|127.0.0.1:2234:2236");
        Assertions.assertEquals((Object)"127.0.0.1:1234:1236|127.0.0.1:2234:2236:participant", (Object)qs.toString(), (String)"MultiAddress parse error");
    }

    @Test
    public void testWildcard() throws KeeperException.BadArgumentsException {
        String[] addrs = new String[]{"127.0.0.1", "[0:0:0:0:0:0:0:1]", "0.0.0.0", "[::]"};
        for (int i = 0; i < addrs.length; ++i) {
            for (int j = i; j < addrs.length; ++j) {
                QuorumPeer.QuorumServer server1 = new QuorumPeer.QuorumServer(1L, new InetSocketAddress(this.ipv6n1, 1234), new InetSocketAddress(this.ipv6n1, 1236), new InetSocketAddress(addrs[i], 1237));
                QuorumPeer.QuorumServer server2 = new QuorumPeer.QuorumServer(2L, new InetSocketAddress(this.ipv6n2, 1234), new InetSocketAddress(this.ipv6n2, 1236), new InetSocketAddress(addrs[j], 1237));
                server1.checkAddressDuplicate(server2);
            }
        }
    }

    @Test
    public void testDuplicate() {
        Assertions.assertThrows(KeeperException.BadArgumentsException.class, () -> {
            QuorumPeer.QuorumServer server1 = new QuorumPeer.QuorumServer(1L, new InetSocketAddress(this.ipv6n1, 1234), new InetSocketAddress(this.ipv6n1, 1236), new InetSocketAddress(this.ipv6n1, 1237));
            QuorumPeer.QuorumServer server2 = new QuorumPeer.QuorumServer(2L, new InetSocketAddress(this.ipv6n2, 1234), new InetSocketAddress(this.ipv6n2, 1236), new InetSocketAddress(this.ipv6n1, 1237));
            server1.checkAddressDuplicate(server2);
        });
    }
}

