/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.jute.BinaryInputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BufferSizeTest
extends ClientBase {
    public static final int TEST_MAXBUFFER = 100;
    private static final File TEST_DATA = new File(System.getProperty("test.data.dir", "src/test/resources/data"), "buffersize");
    private ZooKeeper zk;

    @BeforeEach
    public void setMaxBuffer() throws IOException, InterruptedException {
        System.setProperty("jute.maxbuffer", "100");
        Assertions.assertEquals((int)100, (int)BinaryInputArchive.maxBuffer, (String)"Can't set jute.maxbuffer!");
        this.zk = this.createClient();
    }

    @Test
    public void testCreatesReqs() throws Exception {
        this.testRequests(new ClientOp(){

            @Override
            public void execute(byte[] data) throws Exception {
                BufferSizeTest.this.zk.create("/create_test", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            }
        });
    }

    @Test
    public void testSetReqs() throws Exception {
        String path = "/set_test";
        this.zk.create("/set_test", new byte[1], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.testRequests(new ClientOp(){

            @Override
            public void execute(byte[] data) throws Exception {
                BufferSizeTest.this.zk.setData("/set_test", data, -1);
            }
        });
    }

    private void testRequests(ClientOp clientOp) throws Exception {
        clientOp.execute(new byte[40]);
        try {
            clientOp.execute(new byte[100]);
            Assertions.fail((String)"Request exceeding jute.maxbuffer succeeded!");
        }
        catch (KeeperException.ConnectionLossException connectionLossException) {
            // empty catch block
        }
        try {
            clientOp.execute(new byte[110]);
            Assertions.fail((String)"Request exceeding jute.maxbuffer succeeded!");
        }
        catch (KeeperException.ConnectionLossException connectionLossException) {
            // empty catch block
        }
    }

    @Test
    public void testStartup() throws Exception {
        String path = "/test_node";
        this.zk.create("/test_node", new byte[40], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.setData("/test_node", new byte[50], -1);
        this.stopServer();
        this.startServer();
    }

    @Test
    public void testStartupFailureCreate() throws Exception {
        this.testStartupFailure(new File(TEST_DATA, "create"), "Server started despite create exceeding jute.maxbuffer!");
    }

    @Test
    public void testStartupFailureSet() throws Exception {
        this.testStartupFailure(new File(TEST_DATA, "set"), "Server started despite set exceeding jute.maxbuffer!");
    }

    @Test
    public void testStartupFailureSnapshot() throws Exception {
        this.testStartupFailure(new File(TEST_DATA, "snapshot"), "Server started despite znode exceeding jute.maxbuffer!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStartupFailure(File testDir, String failureMsg) throws Exception {
        this.stopServer();
        File oldTmpDir = this.tmpDir;
        this.tmpDir = testDir;
        try {
            this.startServer();
            Assertions.fail((String)failureMsg);
        }
        catch (IOException e) {
            LOG.debug("Successfully caught IOException", (Throwable)e);
        }
        finally {
            this.tmpDir = oldTmpDir;
        }
    }

    private static interface ClientOp {
        public void execute(byte[] var1) throws Exception;
    }
}

