/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentIsOptionTest {
    private Options options;
    private CommandLineParser parser;

    ArgumentIsOptionTest() {
    }

    @BeforeEach
    public void setUp() {
        this.options = new Options().addOption("p", false, "Option p").addOption("attr", true, "Option accepts argument");
        this.parser = new PosixParser();
    }

    @Test
    void testOption() throws Exception {
        String[] args = new String[]{"-p"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertTrue((boolean)cl.hasOption("p"), (String)"Confirm -p is set");
        Assertions.assertFalse((boolean)cl.hasOption("attr"), (String)"Confirm -attr is not set");
        Assertions.assertEquals((int)0, (int)cl.getArgs().length, (String)"Confirm all arguments recognized");
    }

    @Test
    void testOptionAndOptionWithArgument() throws Exception {
        String[] args = new String[]{"-p", "-attr", "p"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertTrue((boolean)cl.hasOption("p"), (String)"Confirm -p is set");
        Assertions.assertTrue((boolean)cl.hasOption("attr"), (String)"Confirm -attr is set");
        Assertions.assertEquals((Object)"p", (Object)cl.getOptionValue("attr"), (String)"Confirm arg of -attr");
        Assertions.assertEquals((int)0, (int)cl.getArgs().length, (String)"Confirm all arguments recognized");
    }

    @Test
    void testOptionWithArgument() throws Exception {
        String[] args = new String[]{"-attr", "p"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assertions.assertFalse((boolean)cl.hasOption("p"), (String)"Confirm -p is set");
        Assertions.assertTrue((boolean)cl.hasOption("attr"), (String)"Confirm -attr is set");
        Assertions.assertEquals((Object)"p", (Object)cl.getOptionValue("attr"), (String)"Confirm arg of -attr");
        Assertions.assertEquals((int)0, (int)cl.getArgs().length, (String)"Confirm all arguments recognized");
    }
}

