/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.example;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.example.XhtmlHelpAppendable;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.TextStyle;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class XhtmlHelpAppendableTest {
    private StringBuilder sb;
    private XhtmlHelpAppendable underTest;

    XhtmlHelpAppendableTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.sb = new StringBuilder();
        this.underTest = new XhtmlHelpAppendable(this.sb);
    }

    @Test
    void testAppendHeaderTest() throws IOException {
        this.underTest.appendHeader(1, "Hello World");
        Assertions.assertEquals((Object)String.format("<h1>Hello World</h1>%n", new Object[0]), (Object)this.sb.toString());
        this.sb.setLength(0);
        this.underTest.appendHeader(2, "Hello World");
        Assertions.assertEquals((Object)String.format("<h2>Hello World</h2>%n", new Object[0]), (Object)this.sb.toString());
        this.sb.setLength(0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.underTest.appendHeader(0, "Hello World"));
    }

    @Test
    void testAppendListTest() throws IOException {
        String[] entries = new String[]{"one", "two", "three"};
        this.underTest.appendList(true, Arrays.asList(entries));
        Assertions.assertEquals((Object)String.format("<ol>%n  <li>one</li>%n  <li>two</li>%n  <li>three</li>%n</ol>%n", new Object[0]), (Object)this.sb.toString());
        this.sb.setLength(0);
        this.underTest.appendList(false, Arrays.asList(entries));
        Assertions.assertEquals((Object)String.format("<ul>%n  <li>one</li>%n  <li>two</li>%n  <li>three</li>%n</ul>%n", new Object[0]), (Object)this.sb.toString());
    }

    @Test
    void testAppendParagraphFormatTest() throws IOException {
        this.underTest.appendParagraphFormat("Hello %s World %,d", new Object[]{"Joe", 309});
        Assertions.assertEquals((Object)String.format("<p>Hello Joe World 309</p>%n", new Object[0]), (Object)this.sb.toString());
    }

    @Test
    void testAppendParagraphTest() throws IOException {
        this.underTest.appendParagraph("Hello World");
        Assertions.assertEquals((Object)String.format("<p>Hello World</p>%n", new Object[0]), (Object)this.sb.toString());
    }

    @Test
    void testAppendTableTest() throws IOException {
        List<TextStyle> styles = Arrays.asList(TextStyle.DEFAULT, TextStyle.DEFAULT, TextStyle.DEFAULT);
        String[] headers = new String[]{"one", "two", "three"};
        List<List> rows = Arrays.asList(Arrays.asList("uno", "dos", "tres"), Arrays.asList("aon", "dh\u00e1", "tr\u00ed"), Arrays.asList("\u0648\u0627\u062d\u062f", "\u0627\u062b\u0646\u064a\u0646", "\u062b\u0644\u0627\u062b\u0629"));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("<table class='commons_cli_table'>");
        expected.add("  <caption>The caption</caption>");
        expected.add("  <tr>");
        expected.add("    <th>one</th>");
        expected.add("    <th>two</th>");
        expected.add("    <th>three</th>");
        expected.add("  </tr>");
        expected.add("  <tr>");
        expected.add("    <td>uno</td>");
        expected.add("    <td>dos</td>");
        expected.add("    <td>tres</td>");
        expected.add("  </tr>");
        expected.add("  <tr>");
        expected.add("    <td>aon</td>");
        expected.add("    <td>dh&aacute;</td>");
        expected.add("    <td>tr&iacute;</td>");
        expected.add("  </tr>");
        expected.add("  <tr>");
        expected.add("    <td>\u0648\u0627\u062d\u062f</td>");
        expected.add("    <td>\u0627\u062b\u0646\u064a\u0646</td>");
        expected.add("    <td>\u062b\u0644\u0627\u062b\u0629</td>");
        expected.add("  </tr>");
        expected.add("</table>");
        TableDefinition table = TableDefinition.from((String)"The caption", styles, Arrays.asList(headers), rows);
        this.underTest.appendTable(table);
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"full table failed");
        table = TableDefinition.from(null, styles, Arrays.asList(headers), rows);
        expected.remove(1);
        this.sb.setLength(0);
        this.underTest.appendTable(table);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        table = TableDefinition.from(null, styles, Arrays.asList(headers), Collections.emptyList());
        expected = new ArrayList();
        expected.add("<table class='commons_cli_table'>");
        expected.add("  <tr>");
        expected.add("    <th>one</th>");
        expected.add("    <th>two</th>");
        expected.add("    <th>three</th>");
        expected.add("  </tr>");
        expected.add("</table>");
        this.sb.setLength(0);
        this.underTest.appendTable(table);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"no rows test failed");
    }

    @Test
    void testAppendTitleTest() throws IOException {
        this.underTest.appendTitle("Hello World");
        Assertions.assertEquals((Object)String.format("<span class='commons_cli_title'>Hello World</span>%n", new Object[0]), (Object)this.sb.toString());
    }
}

