/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.MemorySegmentRequestExample;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClassicQuantilesMemorySegmentRequestApp {
    @Test
    public void checkMemorySegmentRequestExample() {
        int k = 128;
        int itemsIn = 5120;
        MemorySegmentRequestExample mSegReqEx = new MemorySegmentRequestExample();
        int initalBytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)128, (long)256L);
        MemorySegment seg = mSegReqEx.request((long)initalBytes);
        UpdatableQuantilesDoublesSketch sk = QuantilesDoublesSketch.builder().setK(128).build(seg, (MemorySegmentRequest)mSegReqEx);
        for (int n = 1; n <= 5120; ++n) {
            sk.update((double)n);
        }
        Assert.assertEquals((double)sk.getMaxItem(), (double)5120.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((long)sk.getN(), (long)5120L);
        Assert.assertTrue((sk.getMemorySegment() != seg ? 1 : 0) != 0);
        mSegReqEx.cleanup();
    }
}

