/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.QuickSelect;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketchR;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.thetacommon.HashOperations;

final class ThetaUnionImpl
extends ThetaUnion {
    private final UpdatableThetaSketch gadget_;
    private final short expectedSeedHash_;
    private long unionThetaLong_;
    private boolean unionEmpty_;

    private ThetaUnionImpl(UpdatableThetaSketch gadget, long seed) {
        this.gadget_ = gadget;
        this.expectedSeedHash_ = Util.computeSeedHash(seed);
    }

    static ThetaUnionImpl initNewHeapInstance(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        HeapQuickSelectSketch gadget = new HeapQuickSelectSketch(lgNomLongs, seed, p, rf, true);
        ThetaUnionImpl unionImpl = new ThetaUnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = ((ThetaSketch)gadget).getThetaLong();
        unionImpl.unionEmpty_ = ((ThetaSketch)gadget).isEmpty();
        return unionImpl;
    }

    static ThetaUnionImpl initNewDirectInstance(int lgNomLongs, long seed, float p, ResizeFactor rf, MemorySegment dstSeg) {
        DirectQuickSelectSketch gadget = new DirectQuickSelectSketch(lgNomLongs, seed, p, rf, dstSeg, null, true);
        ThetaUnionImpl unionImpl = new ThetaUnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = ((ThetaSketch)gadget).getThetaLong();
        unionImpl.unionEmpty_ = ((ThetaSketch)gadget).isEmpty();
        return unionImpl;
    }

    static ThetaUnionImpl heapifyInstance(MemorySegment srcSeg, long expectedSeed) {
        MemorySegment srcSegRO = srcSeg.asReadOnly();
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcSegRO));
        HeapQuickSelectSketch gadget = HeapQuickSelectSketch.heapifyInstance(srcSegRO, expectedSeed);
        ThetaUnionImpl unionImpl = new ThetaUnionImpl(gadget, expectedSeed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcSegRO);
        unionImpl.unionEmpty_ = PreambleUtil.isEmptyFlag(srcSegRO);
        return unionImpl;
    }

    static ThetaUnionImpl fastWrapInstance(MemorySegment srcSeg, long expectedSeed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcSeg));
        DirectQuickSelectSketchR gadget = srcSeg.isReadOnly() ? DirectQuickSelectSketchR.fastReadOnlyWrap(srcSeg, expectedSeed) : DirectQuickSelectSketch.fastWritableWrap(srcSeg, null, expectedSeed);
        ThetaUnionImpl unionImpl = new ThetaUnionImpl(gadget, expectedSeed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcSeg);
        unionImpl.unionEmpty_ = PreambleUtil.isEmptyFlag(srcSeg);
        return unionImpl;
    }

    static ThetaUnionImpl wrapInstance(MemorySegment srcSeg, long expectedSeed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcSeg));
        DirectQuickSelectSketchR gadget = srcSeg.isReadOnly() ? DirectQuickSelectSketchR.readOnlyWrap(srcSeg, expectedSeed) : DirectQuickSelectSketch.writableWrap(srcSeg, null, expectedSeed);
        ThetaUnionImpl unionImpl = new ThetaUnionImpl(gadget, expectedSeed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcSeg);
        unionImpl.unionEmpty_ = PreambleUtil.isEmptyFlag(srcSeg);
        return unionImpl;
    }

    @Override
    public int getCurrentBytes() {
        return this.gadget_.getCurrentBytes();
    }

    @Override
    public int getMaxUnionBytes() {
        int lgK = this.gadget_.getLgNomLongs();
        return (16 << lgK) + (Family.UNION.getMaxPreLongs() << 3);
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.hasMemorySegment() ? this.gadget_.getMemorySegment() : null;
    }

    @Override
    public CompactThetaSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public CompactThetaSketch getResult(boolean dstOrdered, MemorySegment dstSeg) {
        int gadgetCurCount = this.gadget_.getRetainedEntries(true);
        int k = 1 << this.gadget_.getLgNomLongs();
        long[] gadgetCacheCopy = this.gadget_.hasMemorySegment() ? this.gadget_.getCache() : (long[])this.gadget_.getCache().clone();
        long curGadgetThetaLong = this.gadget_.getThetaLong();
        long adjGadgetThetaLong = gadgetCurCount > k ? QuickSelect.selectExcludingZeros(gadgetCacheCopy, gadgetCurCount, k + 1) : curGadgetThetaLong;
        long unionThetaLong = this.gadget_.hasMemorySegment() ? this.gadget_.getMemorySegment().get(ValueLayout.JAVA_LONG_UNALIGNED, 24L) : this.unionThetaLong_;
        long minThetaLong = Math.min(Math.min(curGadgetThetaLong, adjGadgetThetaLong), unionThetaLong);
        int curCountOut = minThetaLong < curGadgetThetaLong ? HashOperations.count(gadgetCacheCopy, minThetaLong) : gadgetCurCount;
        long[] compactCacheOut = CompactOperations.compactCache(gadgetCacheCopy, curCountOut, minThetaLong, dstOrdered);
        boolean empty = this.gadget_.isEmpty() && this.unionEmpty_;
        short seedHash = this.gadget_.getSeedHash();
        return CompactOperations.componentsToCompact(minThetaLong, curCountOut, seedHash, empty, true, dstOrdered, dstOrdered, dstSeg, compactCacheOut);
    }

    @Override
    public boolean hasMemorySegment() {
        return this.gadget_.hasMemorySegment();
    }

    @Override
    public boolean isOffHeap() {
        return this.gadget_.isOffHeap();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return this.gadget_.isSameResource(that);
    }

    @Override
    public void reset() {
        this.gadget_.reset();
        this.unionThetaLong_ = this.gadget_.getThetaLong();
        this.unionEmpty_ = this.gadget_.isEmpty();
    }

    @Override
    public byte[] toByteArray() {
        byte[] gadgetByteArr = this.gadget_.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(gadgetByteArr);
        PreambleUtil.insertUnionThetaLong(seg, this.unionThetaLong_);
        if (this.gadget_.isEmpty() != this.unionEmpty_) {
            PreambleUtil.clearEmpty(seg);
            this.unionEmpty_ = false;
        }
        return gadgetByteArr;
    }

    @Override
    public CompactThetaSketch union(ThetaSketch sketchA, ThetaSketch sketchB, boolean dstOrdered, MemorySegment dstSeg) {
        this.reset();
        this.union(sketchA);
        this.union(sketchB);
        CompactThetaSketch csk = this.getResult(dstOrdered, dstSeg);
        this.reset();
        return csk;
    }

    @Override
    public void union(ThetaSketch sketchIn) {
        if (sketchIn == null || sketchIn.isEmpty()) {
            return;
        }
        Util.checkSeedHashes(this.expectedSeedHash_, sketchIn.getSeedHash());
        if (sketchIn instanceof SingleItemSketch) {
            this.gadget_.hashUpdate(sketchIn.getCache()[0]);
            return;
        }
        ThetaUnionImpl.checkSketchAndMemorySegmentFlags(sketchIn);
        this.unionThetaLong_ = Math.min(Math.min(this.unionThetaLong_, sketchIn.getThetaLong()), this.gadget_.getThetaLong());
        this.unionEmpty_ = false;
        boolean isOrdered = sketchIn.isOrdered();
        HashIterator it = sketchIn.iterator();
        while (it.next()) {
            long hash = it.get();
            if (hash < this.unionThetaLong_ && hash < this.gadget_.getThetaLong()) {
                this.gadget_.hashUpdate(hash);
                continue;
            }
            if (!isOrdered) continue;
            break;
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.hasMemorySegment()) {
            MemorySegment wseg = this.gadget_.getMemorySegment();
            PreambleUtil.insertUnionThetaLong(wseg, this.unionThetaLong_);
            PreambleUtil.clearEmpty(wseg);
        }
    }

    @Override
    public void union(MemorySegment seg) {
        Objects.requireNonNull(seg, "MemorySegment must be non-null");
        this.union(ThetaSketch.wrap(seg.asReadOnly()));
    }

    @Override
    public void update(long datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(double datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(String datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(byte[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(ByteBuffer data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(char[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(int[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(long[] data) {
        this.gadget_.update(data);
    }

    @Override
    long[] getCache() {
        return this.gadget_.getCache();
    }

    @Override
    int getRetainedEntries() {
        return this.gadget_.getRetainedEntries(true);
    }

    @Override
    short getSeedHash() {
        return this.gadget_.getSeedHash();
    }

    @Override
    long getThetaLong() {
        return Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
    }

    @Override
    boolean isEmpty() {
        return this.gadget_.isEmpty() && this.unionEmpty_;
    }

    private static final void checkSketchAndMemorySegmentFlags(ThetaSketch sketch) {
        MemorySegment seg = sketch.getMemorySegment();
        if (seg == null) {
            return;
        }
        int flags = PreambleUtil.extractFlags(seg);
        if ((flags & 8) > 0 ^ sketch.isCompact()) {
            throw new SketchesArgumentException("Possible corruption: MemorySegment Compact Flag inconsistent with ThetaSketch Compact Flag");
        }
        if ((flags & 0x10) > 0 ^ sketch.isOrdered()) {
            throw new SketchesArgumentException("Possible corruption: MemorySegment Ordered Flag inconsistent with ThetaSketch Ordered Flag");
        }
    }
}

