/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;

public class JMXServiceURL
implements Serializable {
    private static final long serialVersionUID = 8173364409860779292L;
    private String protocol;
    private String host;
    private int port;
    private String urlPath;
    private transient int hash;

    public JMXServiceURL(String url) throws MalformedURLException {
        if (url == null) {
            throw new NullPointerException("Null JMXServiceURL string");
        }
        this.parse(url);
    }

    public JMXServiceURL(String protocol, String host, int port) throws MalformedURLException {
        this(protocol, host, port, null);
    }

    public JMXServiceURL(String protocol, String host, int port, String urlPath) throws MalformedURLException {
        if (port < 0) {
            throw new MalformedURLException("Port number cannot be less than zero");
        }
        this.setProtocol(protocol);
        this.setHost(host);
        this.setPort(port);
        this.setURLPath(urlPath);
    }

    private String resolveHost() throws MalformedURLException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            throw new MalformedURLException("Cannot resolve local host name");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    private void setProtocol(String protocol) {
        this.protocol = protocol != null ? protocol.toLowerCase() : "jmxmp";
    }

    public String getHost() {
        return this.host;
    }

    private void setHost(String host) throws MalformedURLException {
        this.host = host != null ? host.toLowerCase() : this.resolveHost().toLowerCase();
    }

    public int getPort() {
        return this.port;
    }

    private void setPort(int port) {
        this.port = port;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    private void setURLPath(String urlPath) {
        if (urlPath != null) {
            if (urlPath.length() > 0 && !urlPath.startsWith("/")) {
                urlPath = "/" + urlPath;
            }
            this.urlPath = urlPath;
        } else {
            this.urlPath = "";
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.getProtocol().hashCode();
            String host = this.getHost();
            this.hash = 29 * this.hash + (host != null ? host.hashCode() : 0);
            this.hash = 29 * this.hash + this.getPort();
            String path = this.getURLPath();
            this.hash = 29 * this.hash + (path != null ? path.hashCode() : 0);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JMXServiceURL)) {
            return false;
        }
        JMXServiceURL other = (JMXServiceURL)obj;
        if (!this.getProtocol().equalsIgnoreCase(other.getProtocol())) {
            return false;
        }
        String host = this.getHost();
        String otherHost = other.getHost();
        if (host != null ? !host.equalsIgnoreCase(otherHost) : otherHost != null) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String path = this.getURLPath();
        String otherPath = other.getURLPath();
        return !(path != null ? !path.equals(otherPath) : otherPath != null);
    }

    public String toString() {
        String path;
        StringBuffer buffer = new StringBuffer("service:jmx:");
        buffer.append(this.getProtocol()).append("://");
        buffer.append(this.getHost());
        int port = this.getPort();
        if (port > 0) {
            buffer.append(":").append(port);
        }
        if ((path = this.getURLPath()) != null) {
            if (!path.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(path);
        }
        return buffer.toString();
    }

    private void parse(String url) throws MalformedURLException {
        String hostSeparator;
        String prefix = "service:jmx:";
        if (url.length() <= prefix.length()) {
            throw new MalformedURLException("JMXServiceURL " + url + " must start with " + prefix);
        }
        String servicejmx = url.substring(0, prefix.length());
        if (!servicejmx.equalsIgnoreCase(prefix)) {
            throw new MalformedURLException("JMXServiceURL " + url + " must start with " + prefix);
        }
        String parse = url.substring(prefix.length());
        int index = parse.indexOf(hostSeparator = "://");
        if (index < 0) {
            throw new MalformedURLException("No protocol defined for JMXServiceURL " + url);
        }
        String protocol = parse.substring(0, index);
        this.checkProtocol(url, protocol);
        this.setProtocol(protocol);
        String hostAndMore = parse.substring(index + hostSeparator.length());
        index = hostAndMore.indexOf(47);
        if (index < 0) {
            this.parseHostAndPort(url, hostAndMore);
            this.setURLPath(null);
        } else {
            String hostAndPort = hostAndMore.substring(0, index);
            this.parseHostAndPort(url, hostAndPort);
            String pathAndMore = hostAndMore.substring(index);
            if (pathAndMore.length() > 0) {
                this.checkURLPath(url, pathAndMore);
                String path = "/".equals(pathAndMore) ? "" : pathAndMore;
                this.setURLPath(path);
            }
        }
    }

    private void parseHostAndPort(String url, String hostAndPort) throws MalformedURLException {
        if (hostAndPort.length() == 0) {
            this.setHost(null);
            this.setPort(0);
            return;
        }
        int colon = hostAndPort.indexOf(58);
        if (colon == 0) {
            throw new MalformedURLException("No host defined for JMXServiceURL " + url);
        }
        if (colon > 0) {
            String host = hostAndPort.substring(0, colon);
            this.checkHost(url, host);
            this.setHost(host);
            String portString = hostAndPort.substring(colon + 1);
            try {
                int port = Integer.parseInt(portString);
                this.setPort(port);
            }
            catch (NumberFormatException x) {
                throw new MalformedURLException("Invalid port " + portString + " for JMXServiceURL " + url);
            }
        } else {
            this.checkHost(url, hostAndPort);
            this.setHost(hostAndPort);
            this.setPort(0);
        }
    }

    private void checkProtocol(String url, String protocol) throws MalformedURLException {
        if (protocol.length() == 0) {
            throw new MalformedURLException("No protocol defined for JMXServiceURL " + url);
        }
        if (!protocol.trim().equals(protocol)) {
            throw new MalformedURLException("No leading or trailing white space allowed in protocol for JMXServiceURL " + url);
        }
    }

    private void checkHost(String url, String host) throws MalformedURLException {
        if (host.length() == 0) {
            throw new MalformedURLException("No host defined for JMXServiceURL " + url);
        }
        if (!host.trim().equals(host)) {
            throw new MalformedURLException("No leading or trailing white space allowed in host for JMXServiceURL " + url);
        }
    }

    private void checkURLPath(String url, String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw new MalformedURLException("Invalid path for JMXServiceURL " + url);
        }
        if (!path.trim().equals(path)) {
            throw new MalformedURLException("No leading or trailing white space allowed in path for JMXServiceURL " + url);
        }
    }
}

