/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.ArrayList;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.RegionAttributesDataPolicy;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.connectors.jdbc.internal.cli.PreconditionException;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.distributed.ConfigurationPersistenceService;

public class MappingCommandUtils {
    public static CacheConfig getCacheConfig(ConfigurationPersistenceService configService, String group) throws PreconditionException {
        CacheConfig result = configService.getCacheConfig(group);
        if (result == null) {
            throw new PreconditionException("Cache Configuration not found" + (group.equals("cluster") ? "." : " for group " + group + "."));
        }
        return result;
    }

    public static RegionConfig checkForRegion(String regionName, CacheConfig cacheConfig, String groupName) throws PreconditionException {
        RegionConfig regionConfig = MappingCommandUtils.findRegionConfig(cacheConfig, regionName);
        if (regionConfig == null) {
            String groupClause = "A region named " + regionName + " must already exist" + (!groupName.equals("cluster") ? " for group " + groupName + "." : ".");
            throw new PreconditionException(groupClause);
        }
        return regionConfig;
    }

    private static RegionConfig findRegionConfig(CacheConfig cacheConfig, String regionName) {
        return cacheConfig.getRegions().stream().filter(region -> region.getName().equals(regionName)).findFirst().orElse(null);
    }

    public static ArrayList<RegionMapping> getMappingsFromRegionConfig(CacheConfig cacheConfig, RegionConfig regionConfig, String group) {
        ArrayList<RegionMapping> results = new ArrayList<RegionMapping>();
        for (CacheElement element : regionConfig.getCustomRegionElements()) {
            if (!(element instanceof RegionMapping)) continue;
            ((RegionMapping)element).setRegionName(regionConfig.getName());
            results.add((RegionMapping)element);
        }
        return results;
    }

    public static boolean isMappingSynchronous(CacheConfig cacheConfig, RegionConfig regionConfig) {
        return MappingCommandUtils.findAsyncEventQueue(cacheConfig, regionConfig) == null;
    }

    public static CacheConfig.AsyncEventQueue findAsyncEventQueue(CacheConfig cacheConfig, RegionConfig regionConfig) {
        for (CacheConfig.AsyncEventQueue queue : cacheConfig.getAsyncEventQueues()) {
            if (!queue.getId().equals(MappingCommandUtils.createAsyncEventQueueName(regionConfig.getName()))) continue;
            return queue;
        }
        return null;
    }

    public static boolean isAccessor(RegionAttributesType attributesType) {
        return attributesType.getDataPolicy() == RegionAttributesDataPolicy.EMPTY || attributesType.getPartitionAttributes() != null && attributesType.getPartitionAttributes().getLocalMaxMemory() != null && attributesType.getPartitionAttributes().getLocalMaxMemory().equals("0");
    }

    public static boolean isPartition(RegionAttributesType attributesType) {
        boolean isPartitioned = false;
        if (attributesType.getDataPolicy() != null) {
            isPartitioned = attributesType.getDataPolicy().isPartition();
        } else if (attributesType.getRefid() != null) {
            isPartitioned = RegionShortcut.valueOf((String)attributesType.getRefid()).isPartition();
        }
        return isPartitioned;
    }

    public static String createAsyncEventQueueName(String regionPath) {
        if (regionPath.startsWith("/")) {
            regionPath = regionPath.substring(1);
        }
        return "JDBC#" + regionPath.replace('/', '_');
    }
}

