/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.CacheServer;
import org.apache.geode.admin.CacheServerConfig;
import org.apache.geode.admin.DistributedSystemConfig;
import org.apache.geode.admin.DistributionLocator;
import org.apache.geode.admin.DistributionLocatorConfig;
import org.apache.geode.admin.ManagedEntityConfig;
import org.apache.geode.admin.internal.ManagedEntityConfigXml;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.Assert;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

@Deprecated
public class ManagedEntityConfigXmlGenerator
extends ManagedEntityConfigXml
implements XMLReader {
    @Immutable
    private static final Attributes EMPTY = new AttributesImpl();
    private final AdminDistributedSystem system;
    private ContentHandler handler;

    public static void generate(AdminDistributedSystem system, PrintWriter pw) {
        new ManagedEntityConfigXmlGenerator(system).generate(pw);
    }

    private ManagedEntityConfigXmlGenerator(AdminDistributedSystem system) {
        this.system = system;
    }

    private void generate(PrintWriter pw) {
        try {
            SAXSource src = new SAXSource(this, new InputSource());
            StreamResult res = new StreamResult(pw);
            TransformerFactory xFactory = TransformerFactory.newInstance();
            Transformer xform = xFactory.newTransformer();
            xform.setOutputProperty("method", "xml");
            xform.setOutputProperty("indent", "yes");
            xform.setOutputProperty("doctype-system", "http://www.gemstone.com/dtd/ds5_0.dtd");
            xform.setOutputProperty("doctype-public", "-//GemStone Systems, Inc.//GemFire Distributed System 5.0//EN");
            xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xform.transform(src, res);
            pw.flush();
        }
        catch (Exception ex) {
            RuntimeException ex2 = new RuntimeException("Exception thrown while generating XML.", ex);
            throw ex2;
        }
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        Assert.assertTrue(this.handler != null);
        this.handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "id", "", String.valueOf(this.system.getConfig().getSystemId()));
        this.handler.startElement("", "distributed-system", "distributed-system", atts);
        try {
            this.generateRemoteCommand();
            this.generateDiscovery();
            this.generateSSL();
            this.generateCacheServers();
        }
        catch (AdminException ex) {
            throw new SAXException("An AdminException was thrown while generating XML.", ex);
        }
        this.handler.endElement("", "distributed-system", "distributed-system");
        this.handler.endDocument();
    }

    private void generateRemoteCommand() throws SAXException {
        String remoteCommand = this.system.getRemoteCommand();
        this.handler.startElement("", "remote-command", "remote-command", EMPTY);
        this.handler.characters(remoteCommand.toCharArray(), 0, remoteCommand.length());
        this.handler.endElement("", "remote-command", "remote-command");
    }

    private void generateDiscovery() throws SAXException {
        this.handler.startElement("", "locators", "locators", EMPTY);
        this.generateLocators();
        this.handler.endElement("", "locators", "locators");
    }

    private void generateLocators() throws SAXException {
        DistributionLocator[] locators;
        for (DistributionLocator locator : locators = this.system.getDistributionLocators()) {
            this.generateLocator(locator.getConfig());
        }
    }

    private void generateLocator(DistributionLocatorConfig config) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "port", "", String.valueOf(config.getPort()));
        this.handler.startElement("", "locator", "locator", atts);
        this.generateEntityConfig(config);
        this.handler.endElement("", "locator", "locator");
    }

    private void generateEntityConfig(ManagedEntityConfig config) throws SAXException {
        String productDirectory;
        String workingDirectory;
        String remoteCommand;
        String host = config.getHost();
        if (host != null) {
            this.handler.startElement("", "host", "host", EMPTY);
            this.handler.characters(host.toCharArray(), 0, host.length());
            this.handler.endElement("", "host", "host");
        }
        if ((remoteCommand = config.getRemoteCommand()) != null) {
            this.handler.startElement("", "remote-command", "remote-command", EMPTY);
            this.handler.characters(remoteCommand.toCharArray(), 0, remoteCommand.length());
            this.handler.endElement("", "remote-command", "remote-command");
        }
        if ((workingDirectory = config.getWorkingDirectory()) != null) {
            this.handler.startElement("", "working-directory", "working-directory", EMPTY);
            this.handler.characters(workingDirectory.toCharArray(), 0, workingDirectory.length());
            this.handler.endElement("", "working-directory", "working-directory");
        }
        if ((productDirectory = config.getProductDirectory()) != null) {
            this.handler.startElement("", "product-directory", "product-directory", EMPTY);
            this.handler.characters(productDirectory.toCharArray(), 0, productDirectory.length());
            this.handler.endElement("", "product-directory", "product-directory");
        }
    }

    private void generateSSL() throws SAXException {
        String ciphers;
        DistributedSystemConfig config = this.system.getConfig();
        boolean sslEnabled = config.isSSLEnabled();
        if (!sslEnabled) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "authentication-required", "", String.valueOf(config.isSSLAuthenticationRequired()));
        this.handler.startElement("", "ssl", "ssl", atts);
        String protocols = config.getSSLProtocols();
        if (protocols != null) {
            this.handler.startElement("", "protocols", "protocols", EMPTY);
            this.handler.characters(protocols.toCharArray(), 0, protocols.length());
            this.handler.endElement("", "protocols", "protocols");
        }
        if ((ciphers = config.getSSLCiphers()) != null) {
            this.handler.startElement("", "ciphers", "ciphers", EMPTY);
            this.handler.characters(ciphers.toCharArray(), 0, ciphers.length());
            this.handler.endElement("", "ciphers", "ciphers");
        }
        Properties sslProps = config.getSSLProperties();
        Iterator<Map.Entry<Object, Object>> iterator = sslProps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> objectObjectEntry;
            Map.Entry<Object, Object> entry = objectObjectEntry = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.handler.startElement("", "property", "property", EMPTY);
            this.handler.startElement("", "key", "key", EMPTY);
            this.handler.characters(key.toCharArray(), 0, key.length());
            this.handler.endElement("", "key", "key");
            this.handler.startElement("", "value", "value", EMPTY);
            this.handler.characters(value.toCharArray(), 0, value.length());
            this.handler.endElement("", "value", "value");
            this.handler.endElement("", "property", "property");
        }
        this.handler.endElement("", "ssl", "ssl");
    }

    private void generateCacheServers() throws SAXException, AdminException {
        CacheServer[] servers;
        for (CacheServer server : servers = this.system.getCacheServers()) {
            this.generateCacheServer(server.getConfig());
        }
    }

    private void generateCacheServer(CacheServerConfig config) throws SAXException {
        this.handler.startElement("", "cache-server", "cache-server", EMPTY);
        this.generateEntityConfig(config);
        String classpath = config.getClassPath();
        if (classpath != null) {
            this.handler.startElement("", "classpath", "classpath", EMPTY);
            this.handler.characters(classpath.toCharArray(), 0, classpath.length());
            this.handler.endElement("", "classpath", "classpath");
        }
        this.handler.endElement("", "cache-server", "cache-server");
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }
}

