/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal;

import org.apache.geode.alerting.internal.AlertingSessionNotifier;
import org.apache.geode.alerting.internal.AlertingSessionRegistryProvider;
import org.apache.geode.alerting.internal.api.AlertingService;
import org.apache.geode.annotations.VisibleForTesting;

public class AlertingSession {
    private final AlertingSessionNotifier alertingSessionNotifier;
    private State state = State.STOPPED;

    public static AlertingSession create() {
        return AlertingSession.create(AlertingSessionRegistryProvider.get());
    }

    @VisibleForTesting
    static AlertingSession create(AlertingSessionNotifier alertingSessionListeners) {
        return new AlertingSession(alertingSessionListeners);
    }

    private AlertingSession(AlertingSessionNotifier alertingSessionNotifier) {
        this.alertingSessionNotifier = alertingSessionNotifier;
    }

    public synchronized void createSession(AlertingService alertingService) {
        this.state = this.state.changeTo(State.CREATED);
        this.alertingSessionNotifier.createSession(alertingService);
    }

    public synchronized void startSession() {
        this.state = this.state.changeTo(State.STARTED);
        this.alertingSessionNotifier.startSession();
    }

    public synchronized void stopSession() {
        this.state = this.state.changeTo(State.STOPPED);
        this.alertingSessionNotifier.stopSession();
    }

    public synchronized void shutdown() {
    }

    @VisibleForTesting
    AlertingSessionNotifier getAlertingSessionNotifier() {
        return this.alertingSessionNotifier;
    }

    synchronized State getState() {
        return this.state;
    }

    static enum State {
        CREATED,
        STARTED,
        STOPPED;


        State changeTo(State newState) {
            switch (newState) {
                case CREATED: {
                    if (this != STOPPED) {
                        throw new IllegalStateException("Session must not exist before creating");
                    }
                    return CREATED;
                }
                case STARTED: {
                    if (this != CREATED) {
                        throw new IllegalStateException("Session must be created before starting");
                    }
                    return STARTED;
                }
                case STOPPED: {
                    if (this == STARTED) break;
                    throw new IllegalStateException("Session must be started before stopping");
                }
            }
            return STOPPED;
        }
    }
}

