/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.execute;

import java.util.Collection;
import java.util.Collections;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.internal.security.ResourcePermissions;
import org.apache.geode.security.ResourcePermission;

@FunctionalInterface
public interface Function<T>
extends Identifiable<String> {
    default public boolean hasResult() {
        return true;
    }

    public void execute(FunctionContext<T> var1);

    default public String getId() {
        Class<?> clazz = this.getClass();
        String canonicalName = clazz.getCanonicalName();
        if (canonicalName == null) {
            return clazz.getName();
        }
        return canonicalName;
    }

    default public boolean optimizeForWrite() {
        return false;
    }

    default public boolean isHA() {
        return true;
    }

    default public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.singletonList(ResourcePermissions.DATA_WRITE);
    }

    default public Collection<ResourcePermission> getRequiredPermissions(String regionName, Object args) {
        return this.getRequiredPermissions(regionName);
    }
}

