/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.aggregate.Avg;
import org.apache.geode.cache.query.internal.aggregate.AvgBucketNode;
import org.apache.geode.cache.query.internal.aggregate.AvgDistinct;
import org.apache.geode.cache.query.internal.aggregate.AvgDistinctPRQueryNode;
import org.apache.geode.cache.query.internal.aggregate.AvgPRQueryNode;
import org.apache.geode.cache.query.internal.aggregate.Count;
import org.apache.geode.cache.query.internal.aggregate.CountDistinct;
import org.apache.geode.cache.query.internal.aggregate.CountDistinctPRQueryNode;
import org.apache.geode.cache.query.internal.aggregate.CountPRQueryNode;
import org.apache.geode.cache.query.internal.aggregate.DistinctAggregator;
import org.apache.geode.cache.query.internal.aggregate.MaxMin;
import org.apache.geode.cache.query.internal.aggregate.Sum;
import org.apache.geode.cache.query.internal.aggregate.SumDistinct;
import org.apache.geode.cache.query.internal.aggregate.SumDistinctPRQueryNode;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;

public class CompiledAggregateFunction
extends AbstractCompiledValue {
    private final CompiledValue expr;
    private final int aggFuncType;
    private final boolean distinctOnly;

    public CompiledAggregateFunction(CompiledValue expr, int aggFunc) {
        this(expr, aggFunc, false);
    }

    public CompiledAggregateFunction(CompiledValue expr, int aggFunc, boolean distinctOnly) {
        this.expr = expr;
        this.aggFuncType = aggFunc;
        this.distinctOnly = distinctOnly;
    }

    @Override
    public int getType() {
        return 61;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean isPRQueryNode = context.getIsPRQueryNode();
        boolean isBucketNode = context.getBucketList() != null;
        switch (this.aggFuncType) {
            case 62: {
                if (isPRQueryNode) {
                    return this.distinctOnly ? new SumDistinctPRQueryNode() : new Sum();
                }
                return this.distinctOnly ? (isBucketNode ? new DistinctAggregator() : new SumDistinct()) : new Sum();
            }
            case 65: {
                return new MaxMin(true);
            }
            case 66: {
                return new MaxMin(false);
            }
            case 63: {
                if (isPRQueryNode) {
                    return this.distinctOnly ? new AvgDistinctPRQueryNode() : new AvgPRQueryNode();
                }
                return this.distinctOnly ? (isBucketNode ? new DistinctAggregator() : new AvgDistinct()) : (isBucketNode ? new AvgBucketNode() : new Avg());
            }
            case 64: {
                if (isPRQueryNode) {
                    return this.distinctOnly ? new CountDistinctPRQueryNode() : new CountPRQueryNode();
                }
                return this.distinctOnly ? (isBucketNode ? new DistinctAggregator() : new CountDistinct()) : new Count();
            }
        }
        throw new UnsupportedOperationException("Aggregate function not implemented");
    }

    private String getStringRep() {
        switch (this.aggFuncType) {
            case 62: {
                return "sum";
            }
            case 65: {
                return "max";
            }
            case 66: {
                return "min";
            }
            case 63: {
                return "avg";
            }
            case 64: {
                return "count";
            }
        }
        throw new UnsupportedOperationException("Aggregate function not implemented");
    }

    public int getFunctionType() {
        return this.aggFuncType;
    }

    public CompiledValue getParameter() {
        return this.expr;
    }

    public ObjectType getObjectType() {
        switch (this.aggFuncType) {
            case 62: 
            case 63: 
            case 65: 
            case 66: {
                return new ObjectTypeImpl(Number.class);
            }
            case 64: {
                return new ObjectTypeImpl(Integer.class);
            }
        }
        throw new UnsupportedOperationException("Aggregate function not implemented");
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ')');
        if (this.expr != null) {
            this.expr.generateCanonicalizedExpression(clauseBuffer, context);
        } else {
            clauseBuffer.insert(0, '*');
        }
        if (this.distinctOnly) {
            clauseBuffer.insert(0, "distinct ");
        }
        clauseBuffer.insert(0, '(');
        clauseBuffer.insert(0, this.getStringRep());
    }
}

