/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.ResultsBag;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.offheap.StoredObject;

public class DummyQRegion
extends QRegion {
    private RegionEntry entry = null;
    private ObjectType valueType = TypeUtils.OBJECT_TYPE;
    private ObjectType keyType = TypeUtils.OBJECT_TYPE;
    private ResultsBag values = null;
    private ResultsSet keys = null;
    private ResultsSet entries = null;
    private List valueInList = null;
    private Object[] valueInArray = null;

    public DummyQRegion(Region region) {
        super(region, false);
        Class<Object> constraint = region.getAttributes().getValueConstraint();
        if (constraint != null) {
            this.valueType = TypeUtils.getObjectType(constraint);
        }
        if ((constraint = region.getAttributes().getKeyConstraint()) != null) {
            this.keyType = TypeUtils.getObjectType(constraint);
        }
        this.values = new ResultsBag(((HasCachePerfStats)((Object)region.getCache())).getCachePerfStats());
        this.values.setElementType(this.valueType);
        this.keys = new ResultsSet();
        this.keys.setElementType(this.keyType);
        this.entries = new ResultsSet();
        this.entries.setElementType(TypeUtils.getRegionEntryType(region));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void setEntry(RegionEntry e) {
        this.entry = e;
    }

    public RegionEntry getEntry() {
        return this.entry;
    }

    @Override
    public SelectResults getKeys() {
        if (this.keys == null) {
            this.keys = new ResultsSet();
            this.keys.setElementType(this.keyType);
        }
        this.keys.clear();
        this.keys.add(this.entry.getKey());
        return this.keys;
    }

    @Override
    public Set keySet() {
        return (Set)((Object)this.getKeys());
    }

    @Override
    public Set keys() {
        return this.keySet();
    }

    @Override
    public Collection values() {
        return this.getValues();
    }

    @Override
    public Set asSet() {
        return this.getValues().asSet();
    }

    @Override
    public List asList() {
        if (this.valueInList == null) {
            this.valueInList = new ArrayList(1);
        }
        this.valueInList.clear();
        Object val = this.entry.getValueOffHeapOrDiskWithoutFaultIn((LocalRegion)this.getRegion());
        if (val instanceof StoredObject) {
            StoredObject ohval = (StoredObject)val;
            try {
                val = ohval.getDeserializedValue(this.getRegion(), this.entry);
            }
            finally {
                ohval.release();
            }
        } else if (val instanceof CachedDeserializable) {
            val = ((CachedDeserializable)val).getDeserializedValue(this.getRegion(), this.entry);
        }
        this.valueInList.add(val);
        return this.valueInList;
    }

    @Override
    public Object[] toArray() {
        Object val;
        if (this.valueInArray == null) {
            this.valueInArray = new Object[1];
        }
        if ((val = this.entry.getValueOffHeapOrDiskWithoutFaultIn((LocalRegion)this.getRegion())) instanceof StoredObject) {
            StoredObject ohval = (StoredObject)val;
            try {
                val = ohval.getDeserializedValue(this.getRegion(), this.entry);
            }
            finally {
                ohval.release();
            }
        } else if (val instanceof CachedDeserializable) {
            val = ((CachedDeserializable)val).getDeserializedValue(this.getRegion(), this.entry);
        }
        this.valueInArray[0] = val;
        return this.valueInArray;
    }

    @Override
    public SelectResults getValues() {
        if (this.values == null) {
            this.values = new ResultsBag(((HasCachePerfStats)((Object)this.getRegion().getCache())).getCachePerfStats());
            this.values.setElementType(this.valueType);
        }
        this.values.clear();
        Object val = this.entry.getValueOffHeapOrDiskWithoutFaultIn((LocalRegion)this.getRegion());
        if (val instanceof StoredObject) {
            StoredObject ohval = (StoredObject)val;
            try {
                val = ohval.getDeserializedValue(this.getRegion(), this.entry);
            }
            finally {
                ohval.release();
            }
        } else if (val instanceof CachedDeserializable) {
            val = ((CachedDeserializable)val).getDeserializedValue(this.getRegion(), this.entry);
        }
        this.values.add(val);
        return this.values;
    }

    @Override
    public SelectResults getEntries() {
        if (this.entries == null) {
            this.entries = new ResultsSet();
            this.entries.setElementType(TypeUtils.getRegionEntryType(this.getRegion()));
        }
        this.entries.clear();
        Region rgn = this.getRegion();
        while (!(rgn instanceof LocalRegion)) {
            rgn = TypeUtils.checkCast(rgn, QRegion.class).getRegion();
        }
        this.entries.add(new NonTXEntry((LocalRegion)rgn, this.entry));
        return this.entries;
    }

    @Override
    public SelectResults entrySet() {
        return this.getEntries();
    }

    @Override
    public Set entrySet(boolean recursive) {
        return (Set)((Object)this.getEntries());
    }

    @Override
    public Region.Entry getEntry(Object key) {
        NonTXEntry e = (NonTXEntry)super.getEntry(key);
        NonTXEntry retVal = null;
        if (e != null && this.entry == e.getRegionEntry()) {
            retVal = e;
        }
        return retVal;
    }

    @Override
    public Iterator iterator() {
        return this.values().iterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object[] toArray(Object[] obj) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String toString() {
        return "DQR " + super.toString();
    }
}

