/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SerialAckedMessage
extends SerialDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private InternalDistributedMember id;
    private int processorId;
    transient ClusterDistributionManager originDm;
    private transient ReplyProcessor21 rp;

    public SerialAckedMessage() {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        if (ds != null) {
            this.originDm = (ClusterDistributionManager)ds.getDistributionManager();
            this.id = this.originDm.getDistributionManagerId();
        }
    }

    public void send(Collection recipients, boolean multicast) throws InterruptedException, ReplyException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        recipients = new HashSet(recipients);
        InternalDistributedMember me = this.originDm.getDistributionManagerId();
        recipients.remove(me);
        if (isDebugEnabled) {
            logger.debug("Recipients for SerialAckedMessage are {}", recipients);
        }
        this.rp = new ReplyProcessor21((DistributionManager)this.originDm, recipients);
        this.processorId = this.rp.getProcessorId();
        this.setRecipients(recipients);
        this.setMulticast(multicast);
        Set<InternalDistributedMember> failures = this.originDm.putOutgoing(this);
        if (failures != null && failures.size() > 0) {
            Iterator<InternalDistributedMember> iterator = failures.iterator();
            while (iterator.hasNext()) {
                InternalDistributedMember failure;
                InternalDistributedMember mbr = failure = iterator.next();
                if (!isDebugEnabled) continue;
                logger.debug("Unable to send serial acked message to {}", (Object)mbr);
            }
        }
        this.rp.waitForReplies();
    }

    void setDistributionManagerId(InternalDistributedMember id) {
        this.id = id;
    }

    public void setProcessorId(int pid) {
        this.processorId = pid;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        Assert.assertTrue(this.id != null);
        ReplyMessage reply = new ReplyMessage();
        reply.setProcessorId(this.processorId);
        reply.setRecipient(this.getSender());
        dm.putOutgoing(reply);
    }

    public int getDSFID() {
        return 2001;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.id, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
        this.id = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "SerialAckedMessage from=" + this.id + ";processorId=" + this.processorId;
    }
}

