/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class AdminConsoleMessage
extends PooledDistributionMessage {
    private int level;

    public static AdminConsoleMessage create(int level) {
        AdminConsoleMessage m = new AdminConsoleMessage();
        m.setLevel(level);
        return m;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        if (this.level != Integer.MAX_VALUE) {
            dm.getAlertingService().addAlertListener(this.getSender(), AlertLevel.find(this.level));
        }
        dm.addAdminConsole(this.getSender());
    }

    public int getDSFID() {
        return 1005;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.level);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.level = in.readInt();
    }

    @Override
    public String toString() {
        return "AdminConsoleMessage from " + this.getSender() + " level=" + this.level;
    }
}

