/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.DurableClientInfoResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class DurableClientInfoRequest
extends AdminRequest {
    static final int HAS_DURABLE_CLIENT_REQUEST = 10;
    static final int IS_PRIMARY_FOR_DURABLE_CLIENT_REQUEST = 11;
    String durableId;
    int action = 0;

    public static DurableClientInfoRequest create(String id, int operation) {
        DurableClientInfoRequest m = new DurableClientInfoRequest();
        m.durableId = id;
        m.action = operation;
        DurableClientInfoRequest.setFriendlyName(m);
        return m;
    }

    public DurableClientInfoRequest() {
        DurableClientInfoRequest.setFriendlyName(this);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return DurableClientInfoResponse.create(dm, this.getSender(), this);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.durableId, out);
        out.writeInt(this.action);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.durableId = DataSerializer.readString(in);
        this.action = in.readInt();
        DurableClientInfoRequest.setFriendlyName(this);
    }

    @Override
    public String toString() {
        return "DurableClientInfoRequest from " + this.getSender();
    }

    public int getDSFID() {
        return -22;
    }

    private static void setFriendlyName(DurableClientInfoRequest o) {
        switch (o.action) {
            case 10: {
                o.friendlyName = "Find whether the server has durable-queue for this client";
                break;
            }
            case 11: {
                o.friendlyName = "Find whether the server is primary for this durable-client";
                break;
            }
            default: {
                o.friendlyName = "Unknown operation " + o.action;
            }
        }
    }
}

