/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Properties;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DiskWriteAttributes;

public class DiskWriteAttributesImpl
implements DiskWriteAttributes {
    private static final long serialVersionUID = -4269181954992768424L;
    private final boolean isSynchronous;
    private final long timeInterval;
    private final long bytesThreshold;
    private final boolean compactOplogs;
    private final long maxOplogSize;
    private static final long DEFAULT_MAX_OPLOG_SIZE = Long.getLong("gemfire.DEFAULT_MAX_OPLOG_SIZE", 1024L) * 0x100000L;
    private static final long DEFAULT_MAX_OPLOG_SIZE_LIMIT = 0x7FFFFFFF00000L;
    private static final boolean DEFAULT_ROLL_OPLOGS = true;
    private static final boolean DEFAULT_ALLOW_FORCE_COMPACTION = false;
    private static final boolean DEFAULT_IS_SYNCHRONOUS = false;
    static final long DEFAULT_TIME_INTERVAL = 1000L;
    private static final int DEFAULT_COMPACTION_THRESHOLD = 50;
    public static final String SYNCHRONOUS_PROPERTY = "synchronous";
    public static final int DEFAULT_DISK_DIR_SIZE = Integer.MAX_VALUE;
    @Immutable
    private static final DiskWriteAttributes DEFAULT_ASYNC_DWA;
    @Immutable
    private static final DiskWriteAttributes DEFAULT_SYNC_DWA;

    public DiskWriteAttributesImpl(Properties properties) {
        String isSynchronousString = properties.getProperty(SYNCHRONOUS_PROPERTY);
        if (isSynchronousString == null) {
            this.isSynchronous = false;
        } else {
            this.verifyBooleanString(isSynchronousString, SYNCHRONOUS_PROPERTY);
            this.isSynchronous = Boolean.parseBoolean(isSynchronousString);
        }
        String compactOplogsString = properties.getProperty("roll-oplogs");
        if (compactOplogsString == null) {
            this.compactOplogs = true;
        } else {
            this.verifyBooleanString(compactOplogsString, "roll-oplogs");
            this.compactOplogs = Boolean.parseBoolean(compactOplogsString);
        }
        String bytesThresholdString = properties.getProperty("bytes-threshold");
        if (bytesThresholdString != null) {
            if (this.isSynchronous) {
                // empty if block
            }
            this.bytesThreshold = this.verifyLongInString(bytesThresholdString, "bytes-threshold");
        } else {
            this.bytesThreshold = 0L;
        }
        String timeIntervalString = properties.getProperty("time-interval");
        if (timeIntervalString != null) {
            if (this.isSynchronous) {
                // empty if block
            }
            this.timeInterval = this.verifyLongInString(timeIntervalString, "time-interval");
        } else {
            this.timeInterval = !this.isSynchronous && this.bytesThreshold == 0L ? 1000L : 0L;
        }
        String maxOplogSizeString = properties.getProperty("max-oplog-size");
        if (maxOplogSizeString != null) {
            long opSize = this.verifyLongInString(maxOplogSizeString, "max-oplog-size");
            if (opSize == 0L && this.compactOplogs) {
                throw new IllegalStateException("Compaction cannot be set to true if max-oplog-size is set to infinite (infinite is represented by size zero : 0)");
            }
            if (opSize == 0L || opSize == 0x7FFFFFFF00000L) {
                if (this.compactOplogs) {
                    throw new IllegalArgumentException("Cannot set maxOplogs size to infinity (0) if compaction is set to true");
                }
                this.maxOplogSize = 0x7FFFFFFF00000L;
            } else {
                this.maxOplogSize = opSize;
            }
        } else {
            this.maxOplogSize = DEFAULT_MAX_OPLOG_SIZE;
        }
    }

    private void verifyBooleanString(String propertyString, String property) {
        if (!propertyString.equalsIgnoreCase("true") && !propertyString.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException(String.format("%s property has to be true or false or null and cannot be %s", property, propertyString));
        }
    }

    private long verifyLongInString(String propertyString, String property) {
        long returnValue;
        try {
            returnValue = Long.parseLong(propertyString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("%s has to be a valid number and not %s", property, propertyString));
        }
        if (returnValue < 0L) {
            throw new IllegalArgumentException(String.format("%s has to be positive number and the value given %s is not acceptable", property, returnValue));
        }
        return returnValue;
    }

    private int verifyPercentInString(String propertyString, String property) {
        int returnValue;
        try {
            returnValue = Integer.parseInt(propertyString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("%s has to be a valid number and not %s", property, propertyString));
        }
        if (returnValue < 0) {
            throw new IllegalArgumentException(String.format("%s has to be positive number and the value given %s is not acceptable", property, returnValue));
        }
        if (returnValue > 100) {
            throw new IllegalArgumentException(String.format("%s has to be a number that does not exceed %s so the value given %s is not acceptable", property, returnValue, 100));
        }
        return returnValue;
    }

    @Override
    public boolean isSynchronous() {
        return this.isSynchronous;
    }

    @Override
    public boolean isRollOplogs() {
        return this.compactOplogs;
    }

    @Override
    public int getMaxOplogSize() {
        return (int)(this.maxOplogSize / 0x100000L);
    }

    long getMaxOplogSizeInBytes() {
        return this.maxOplogSize;
    }

    @Override
    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public long getBytesThreshold() {
        return this.bytesThreshold;
    }

    @Override
    public boolean equals(Object o) {
        boolean result;
        if (!(o instanceof DiskWriteAttributesImpl)) {
            return false;
        }
        DiskWriteAttributesImpl other = (DiskWriteAttributesImpl)o;
        if (other.isSynchronous() != this.isSynchronous()) {
            return false;
        }
        boolean bl = result = other.isRollOplogs() == this.isRollOplogs() && other.getMaxOplogSize() == this.getMaxOplogSize();
        if (!this.isSynchronous()) {
            result = result && other.getTimeInterval() == this.getTimeInterval() && other.getBytesThreshold() == this.getBytesThreshold();
        }
        return result;
    }

    public int hashCode() {
        long result = 0L;
        if (this.isSynchronous()) {
            if (this.isRollOplogs()) {
                result += 2L;
            }
        } else {
            ++result;
            result += this.getTimeInterval();
            result += this.getBytesThreshold();
        }
        return (int)((result += (long)this.getMaxOplogSize()) & 0xFFFFFFFFFFFFFFFFL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isSynchronous()) {
            sb.append("Synchronous writes to disk");
        } else {
            sb.append("Asynchronous writes to disk after a threshold of ");
            sb.append(this.getTimeInterval());
            sb.append("ms or ");
            sb.append(this.getBytesThreshold());
            sb.append(" bytes");
        }
        sb.append(". MaxOplog size is        : " + this.maxOplogSize);
        sb.append(". RollOplogs is          : " + this.compactOplogs);
        return sb.toString();
    }

    public static int getDefaultMaxOplogSizeLimit() {
        return Integer.MAX_VALUE;
    }

    public static boolean getDefaultRollOplogsValue() {
        return true;
    }

    public static int getDefaultMaxOplogSize() {
        return (int)(DEFAULT_MAX_OPLOG_SIZE / 0x100000L);
    }

    public static DiskWriteAttributes getDefaultAsyncInstance() {
        return DEFAULT_ASYNC_DWA;
    }

    public static DiskWriteAttributes getDefaultSyncInstance() {
        return DEFAULT_SYNC_DWA;
    }

    static {
        Properties props = new Properties();
        props.setProperty(SYNCHRONOUS_PROPERTY, "false");
        DEFAULT_ASYNC_DWA = new DiskWriteAttributesImpl(props);
        props = new Properties();
        props.setProperty(SYNCHRONOUS_PROPERTY, "true");
        DEFAULT_SYNC_DWA = new DiskWriteAttributesImpl(props);
    }
}

