/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.TransactionDataRebalancedException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.TransactionInDoubtException;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.TXManagerCancelledException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DistTXState;
import org.apache.geode.internal.cache.DistTXStateProxyImplOnCoordinator;
import org.apache.geode.internal.cache.DistTXStateProxyImplOnDatanode;
import org.apache.geode.internal.cache.ExpireDisconnectedClientTransactionsMessage;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PausedTXStateProxyImpl;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEvent;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TXStateProxyImpl;
import org.apache.geode.internal.cache.TransactionMessage;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TXManagerImpl
implements CacheTransactionManager,
MembershipListener {
    private static final Logger logger = LogService.getLogger();
    private final ThreadLocal<TXStateProxy> txContext;
    private final ThreadLocal<Boolean> pauseJTA;
    @MakeNotStatic
    private static TXManagerImpl currentInstance = null;
    private final AtomicInteger uniqId;
    private final DistributionManager dm;
    private final InternalCache cache;
    private final InternalDistributedMember distributionMgrId;
    private final CachePerfStats cachePerfStats;
    @Immutable
    private static final TransactionListener[] EMPTY_LISTENERS = new TransactionListener[0];
    public static final int NOTX = -1;
    private final List<TransactionListener> txListeners = new ArrayList<TransactionListener>(8);
    public TransactionWriter writer = null;
    private volatile boolean closed = false;
    private final Map<TXId, TXStateProxy> hostedTXStates;
    private final Set<TXId> scheduledToBeRemovedTx = Boolean.getBoolean("gemfire.trackScheduledToBeRemovedTx") ? ConcurrentHashMap.newKeySet() : null;
    public static final int FAILOVER_TX_MAP_SIZE = Integer.getInteger("gemfire.transactionFailoverMapSize", 1000);
    private final Map<TXId, TXCommitMessage> failoverMap = Collections.synchronizedMap(new LinkedHashMap<TXId, TXCommitMessage>(){
        private static final long serialVersionUID = -4156018226167594134L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (logger.isDebugEnabled()) {
                logger.debug("TX: removing client initiated transaction from failover map:{} :{}", eldest.getKey(), (Object)(this.size() > FAILOVER_TX_MAP_SIZE ? 1 : 0));
            }
            return this.size() > FAILOVER_TX_MAP_SIZE;
        }
    });
    @MutableForTesting
    public static boolean ALLOW_PERSISTENT_TRANSACTIONS = Boolean.getBoolean("gemfire.ALLOW_PERSISTENT_TRANSACTIONS");
    @MutableForTesting
    static int INITIAL_UNIQUE_ID_VALUE = 0;
    private final ConcurrentMap<TXId, TXStateProxy> localTxMap = new ConcurrentHashMap<TXId, TXStateProxy>();
    private volatile long suspendedTXTimeout = Long.getLong("gemfire.suspendedTxTimeout", 30L);
    private final ThreadLocal<Boolean> isTXDistributed;
    private int transactionTimeToLive;
    private final StatisticsClock statisticsClock;
    @Immutable
    private static final TXStateProxy PAUSED = new PausedTXStateProxyImpl();
    private final ConcurrentMap<TransactionId, TXStateProxy> suspendedTXs = new ConcurrentHashMap<TransactionId, TXStateProxy>();
    private final ConcurrentMap<TransactionId, Queue<Thread>> waitMap = new ConcurrentHashMap<TransactionId, Queue<Thread>>();
    private final ConcurrentMap<TransactionId, SystemTimer.SystemTimerTask> expiryTasks = new ConcurrentHashMap<TransactionId, SystemTimer.SystemTimerTask>();
    private final CustomEntryConcurrentHashMap<AbstractRegionEntry, RefCountMapEntry> refCountMap = new CustomEntryConcurrentHashMap<AbstractRegionEntry, RefCountMapEntry>(16, 0.75f, 16, true, new RefCountMapEntryCreator());
    @Immutable
    private static final CustomEntryConcurrentHashMap.MapCallback<AbstractRegionEntry, RefCountMapEntry, Object, Object> incCallback = new CustomEntryConcurrentHashMap.MapCallback<AbstractRegionEntry, RefCountMapEntry, Object, Object>(){

        @Override
        public RefCountMapEntry newValue(AbstractRegionEntry key, Object context, Object createParams) {
            return new RefCountMapEntry(key);
        }

        @Override
        public void oldValueRead(RefCountMapEntry value) {
            value.incRefCount();
        }

        @Override
        public boolean doRemoveValue(RefCountMapEntry value, Object context, Object removeParams) {
            throw new IllegalStateException("doRemoveValue should not be called from create");
        }
    };
    @Immutable
    private static final CustomEntryConcurrentHashMap.MapCallback<AbstractRegionEntry, RefCountMapEntry, Object, Object> decCallback = new CustomEntryConcurrentHashMap.MapCallback<AbstractRegionEntry, RefCountMapEntry, Object, Object>(){

        @Override
        public RefCountMapEntry newValue(AbstractRegionEntry key, Object context, Object createParams) {
            throw new IllegalStateException("newValue should not be called from remove");
        }

        @Override
        public void oldValueRead(RefCountMapEntry value) {
            throw new IllegalStateException("oldValueRead should not be called from remove");
        }

        @Override
        public boolean doRemoveValue(RefCountMapEntry value, Object context, Object removeParams) {
            return value.decRefCount();
        }
    };
    private final Set<InternalDistributedMember> departedProxyServers = Boolean.getBoolean("gemfire.trackScheduledToBeRemovedTx") ? ConcurrentHashMap.newKeySet() : null;

    public TXManagerImpl(CachePerfStats cachePerfStats, InternalCache cache, StatisticsClock statisticsClock) {
        this.cache = cache;
        this.dm = ((InternalDistributedSystem)cache.getDistributedSystem()).getDistributionManager();
        this.distributionMgrId = this.dm.getDistributionManagerId();
        this.uniqId = new AtomicInteger(INITIAL_UNIQUE_ID_VALUE);
        this.cachePerfStats = cachePerfStats;
        this.hostedTXStates = new HashMap<TXId, TXStateProxy>();
        this.txContext = new ThreadLocal();
        this.pauseJTA = new ThreadLocal();
        this.isTXDistributed = new ThreadLocal();
        this.transactionTimeToLive = Integer.getInteger("gemfire.cacheServer.transactionTimeToLive", 180);
        currentInstance = this;
        this.statisticsClock = statisticsClock;
    }

    public static TXManagerImpl getCurrentInstanceForTest() {
        return currentInstance;
    }

    public static void setCurrentInstanceForTest(TXManagerImpl instance) {
        currentInstance = instance;
    }

    InternalCache getCache() {
        return this.cache;
    }

    @Override
    public TransactionWriter getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(TransactionWriter writer) {
        if (this.cache.isClient()) {
            throw new IllegalStateException("A TransactionWriter cannot be registered on a client");
        }
        this.writer = writer;
    }

    @Override
    public TransactionListener getListener() {
        List<TransactionListener> list = this.txListeners;
        synchronized (list) {
            if (this.txListeners.isEmpty()) {
                return null;
            }
            if (this.txListeners.size() == 1) {
                return this.txListeners.get(0);
            }
            throw new IllegalStateException("More than one transaction listener exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionListener[] getListeners() {
        List<TransactionListener> list = this.txListeners;
        synchronized (list) {
            int size = this.txListeners.size();
            if (size == 0) {
                return EMPTY_LISTENERS;
            }
            TransactionListener[] result = new TransactionListener[size];
            this.txListeners.toArray(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionListener setListener(TransactionListener newListener) {
        List<TransactionListener> list = this.txListeners;
        synchronized (list) {
            TransactionListener result = this.getListener();
            this.txListeners.clear();
            if (newListener != null) {
                this.txListeners.add(newListener);
            }
            if (result != null) {
                this.closeListener(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TransactionListener aListener) {
        if (aListener == null) {
            throw new IllegalArgumentException("addListener parameter was null");
        }
        List<TransactionListener> list = this.txListeners;
        synchronized (list) {
            if (!this.txListeners.contains(aListener)) {
                this.txListeners.add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TransactionListener aListener) {
        if (aListener == null) {
            throw new IllegalArgumentException("removeListener parameter was null");
        }
        List<TransactionListener> list = this.txListeners;
        synchronized (list) {
            if (this.txListeners.remove(aListener)) {
                this.closeListener(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initListeners(TransactionListener[] newListeners) {
        List<TransactionListener> list = this.txListeners;
        synchronized (list) {
            if (!this.txListeners.isEmpty()) {
                for (TransactionListener txListener : this.txListeners) {
                    this.closeListener(txListener);
                }
                this.txListeners.clear();
            }
            if (newListeners != null && newListeners.length > 0) {
                List<TransactionListener> nl = Arrays.asList(newListeners);
                if (nl.contains(null)) {
                    throw new IllegalArgumentException("initListeners parameter had a null element");
                }
                this.txListeners.addAll(nl);
            }
        }
    }

    CachePerfStats getCachePerfStats() {
        return this.cachePerfStats;
    }

    private TXId getNewTXId() {
        return new TXId(this.distributionMgrId, this.uniqId.updateAndGet(i -> i == Integer.MAX_VALUE ? 1 : i + 1));
    }

    @Override
    public void begin() {
        this.checkClosed();
        TransactionId tid = this.getTransactionId();
        if (tid != null) {
            throw new IllegalStateException(String.format("Transaction %s already in progress", tid));
        }
        TXStateProxy curProxy = this.txContext.get();
        if (curProxy == PAUSED) {
            throw new IllegalStateException("Current thread has paused its transaction so it can not start a new transaction");
        }
        TXId id = this.getNewTXId();
        TXStateProxyImpl proxy = null;
        proxy = this.isDistributed() ? new DistTXStateProxyImplOnCoordinator(this.cache, this, id, null, this.statisticsClock) : new TXStateProxyImpl(this.cache, this, id, null, this.statisticsClock);
        this.setTXState(proxy);
        if (logger.isDebugEnabled()) {
            logger.debug("begin tx: {}", (Object)proxy);
        }
        this.localTxMap.put(id, proxy);
    }

    public TXStateProxy beginJTA() {
        this.checkClosed();
        TXId id = this.getNewTXId();
        TXStateProxyImpl newState = null;
        newState = this.isDistributed() ? new DistTXStateProxyImplOnCoordinator(this.cache, this, id, true, this.statisticsClock) : new TXStateProxyImpl(this.cache, this, id, true, this.statisticsClock);
        this.setTXState(newState);
        return newState;
    }

    public void precommit() throws CommitConflictException {
        this.checkClosed();
        TXStateProxy tx = this.getTXState();
        if (tx == null) {
            throw new IllegalStateException("Thread does not have an active transaction");
        }
        tx.checkJTA("Can not commit this transaction because it is enlisted with a JTA transaction, use the JTA manager to perform the commit.");
        tx.precommit();
    }

    @Override
    public void commit() throws CommitConflictException {
        this.checkClosed();
        TXStateProxy tx = this.getTXState();
        if (tx == null) {
            throw new IllegalStateException("Thread does not have an active transaction");
        }
        tx.checkJTA("Can not commit this transaction because it is enlisted with a JTA transaction, use the JTA manager to perform the commit.");
        long opStart = this.statisticsClock.getTime();
        long lifeTime = opStart - tx.getBeginTime();
        try {
            this.setTXState(null);
            tx.commit();
        }
        catch (CommitConflictException ex) {
            this.saveTXStateForClientFailover(tx, TXCommitMessage.CMT_CONFLICT_MSG);
            this.noteCommitFailure(opStart, lifeTime, tx);
            this.cleanup(tx.getTransactionId());
            throw ex;
        }
        catch (TransactionDataRebalancedException reb) {
            this.saveTXStateForClientFailover(tx, TXCommitMessage.REBALANCE_MSG);
            this.cleanup(tx.getTransactionId());
            throw reb;
        }
        catch (UnsupportedOperationInTransactionException e) {
            this.setTXState(tx);
            throw e;
        }
        catch (RuntimeException e) {
            this.saveTXStateForClientFailover(tx, TXCommitMessage.EXCEPTION_MSG);
            this.cleanup(tx.getTransactionId());
            throw e;
        }
        this.saveTXStateForClientFailover(tx);
        this.cleanup(tx.getTransactionId());
        this.noteCommitSuccess(opStart, lifeTime, tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteCommitFailure(long opStart, long lifeTime, TXStateInterface tx) {
        long opEnd = this.statisticsClock.getTime();
        this.cachePerfStats.txFailure(opEnd - opStart, lifeTime, tx.getChanges());
        TransactionListener[] listeners = this.getListeners();
        if (tx.isFireCallbacks() && listeners.length > 0) {
            TXEvent e = tx.getEvent();
            try {
                for (TransactionListener listener : listeners) {
                    try {
                        listener.afterFailedCommit(e);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        logger.error("Exception occurred in TransactionListener", t);
                    }
                }
            }
            finally {
                e.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteCommitSuccess(long opStart, long lifeTime, TXStateInterface tx) {
        long opEnd = this.statisticsClock.getTime();
        this.cachePerfStats.txSuccess(opEnd - opStart, lifeTime, tx.getChanges());
        TransactionListener[] listeners = this.getListeners();
        if (tx.isFireCallbacks() && listeners.length > 0) {
            TXEvent e = tx.getEvent();
            try {
                for (TransactionListener listener : listeners) {
                    try {
                        listener.afterCommit(e);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        logger.error("Exception occurred in TransactionListener", t);
                    }
                }
            }
            finally {
                e.release();
            }
        }
    }

    @Override
    public void rollback() {
        this.checkClosed();
        TXStateProxy tx = this.getTXState();
        if (tx == null) {
            throw new IllegalStateException("Thread does not have an active transaction");
        }
        tx.checkJTA("Can not rollback this transaction is enlisted with a JTA transaction, use the JTA manager to perform the rollback.");
        long opStart = this.statisticsClock.getTime();
        long lifeTime = opStart - tx.getBeginTime();
        this.setTXState(null);
        tx.rollback();
        this.saveTXStateForClientFailover(tx);
        this.cleanup(tx.getTransactionId());
        this.noteRollbackSuccess(opStart, lifeTime, tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteRollbackSuccess(long opStart, long lifeTime, TXStateInterface tx) {
        long opEnd = this.statisticsClock.getTime();
        this.cachePerfStats.txRollback(opEnd - opStart, lifeTime, tx.getChanges());
        TransactionListener[] listeners = this.getListeners();
        if (tx.isFireCallbacks() && listeners.length > 0) {
            TXEvent e = tx.getEvent();
            try {
                for (TransactionListener listener : listeners) {
                    try {
                        listener.afterRollback(e);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        logger.error("Exception occurred in TransactionListener", t);
                    }
                }
            }
            finally {
                e.release();
            }
        }
    }

    private void cleanup(TransactionId txId) {
        Queue waitingThreads;
        TXStateProxy proxy = (TXStateProxy)this.localTxMap.remove(txId);
        if (proxy != null) {
            proxy.close();
        }
        if ((waitingThreads = (Queue)this.waitMap.get(txId)) != null && !waitingThreads.isEmpty()) {
            for (Thread waitingThread : waitingThreads) {
                LockSupport.unpark(waitingThread);
            }
            this.waitMap.remove(txId);
        }
    }

    @Override
    public boolean exists() {
        return null != this.getTXState();
    }

    @Override
    public TransactionId getTransactionId() {
        TXStateProxy t = this.getTXState();
        TransactionId ret = null;
        if (t != null) {
            ret = t.getTransactionId();
        }
        return ret;
    }

    public TXStateProxy getTXState() {
        TXStateProxy tsp = this.txContext.get();
        if (tsp == PAUSED) {
            return null;
        }
        if (tsp != null && !tsp.isInProgress()) {
            this.txContext.set(null);
            tsp = null;
        }
        return tsp;
    }

    public boolean setInProgress(boolean progress) {
        boolean retVal = false;
        TXStateProxy tsp = this.txContext.get();
        assert (tsp != PAUSED);
        if (tsp != null) {
            retVal = tsp.isInProgress();
            tsp.setInProgress(progress);
        }
        return retVal;
    }

    public void setTXState(TXStateProxy val) {
        this.txContext.set(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            return;
        }
        TXStateProxy[] proxies = null;
        TXStateProxy[] tXStateProxyArray = this.hostedTXStates;
        synchronized (this.hostedTXStates) {
            TransactionListener[] listeners;
            this.closed = true;
            proxies = this.hostedTXStates.values().toArray(new TXStateProxy[0]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (TXStateProxy proxy : proxies) {
                proxy.getLock().lock();
                try {
                    proxy.close();
                }
                finally {
                    proxy.getLock().unlock();
                }
            }
            for (TXStateProxy proxy : this.localTxMap.values()) {
                proxy.close();
            }
            for (TransactionListener listener : listeners = this.getListeners()) {
                this.closeListener(listener);
            }
            return;
        }
    }

    private void closeListener(TransactionListener tl) {
        try {
            tl.close();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.error("Exception occurred in TransactionListener", t);
        }
    }

    public TXStateProxy pauseTransaction() {
        return this.internalSuspend(true);
    }

    public TXStateProxy internalSuspend() {
        return this.internalSuspend(false);
    }

    private TXStateProxy internalSuspend(boolean needToResumeBySameThread) {
        TXStateProxy result = this.getTXState();
        if (result != null) {
            result.suspend();
            if (needToResumeBySameThread) {
                this.setTXState(PAUSED);
            } else {
                this.setTXState(null);
            }
        } else if (needToResumeBySameThread) {
            this.pauseJTA.set(true);
        }
        return result;
    }

    public void unpauseTransaction(TXStateProxy tx) {
        this.internalResume(tx, true);
    }

    public void internalResume(TXStateProxy tx) {
        this.internalResume(tx, false);
    }

    private void internalResume(TXStateProxy tx, boolean needToResumeBySameThread) {
        if (tx != null) {
            TXStateProxy result;
            TransactionId tid = this.getTransactionId();
            if (tid != null) {
                throw new IllegalStateException(String.format("Transaction %s already in progress", tid));
            }
            if (needToResumeBySameThread && (result = this.txContext.get()) != PAUSED) {
                throw new IllegalStateException("try to unpause a transaction not paused by the same thread");
            }
            this.setTXState(tx);
            tx.resume();
        } else if (needToResumeBySameThread) {
            this.pauseJTA.set(false);
        }
    }

    public boolean isTransactionPaused() {
        return this.txContext.get() == PAUSED;
    }

    public boolean isJTAPaused() {
        Boolean jtaPaused = this.pauseJTA.get();
        if (jtaPaused == null) {
            return false;
        }
        return jtaPaused;
    }

    @Deprecated
    public void resume(TXStateProxy tx) {
        this.internalResume(tx);
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void checkClosed() {
        this.cache.getCancelCriterion().checkCancelInProgress(null);
        if (this.closed) {
            throw new TXManagerCancelledException("This transaction manager is closed.");
        }
    }

    DistributionManager getDM() {
        return this.dm;
    }

    public static int getCurrentTXUniqueId() {
        if (currentInstance == null) {
            return -1;
        }
        return currentInstance.getMyTXUniqueId();
    }

    public static TXStateProxy getCurrentTXState() {
        if (currentInstance == null) {
            return null;
        }
        return currentInstance.getTXState();
    }

    public int getMyTXUniqueId() {
        TXStateProxy t = this.txContext.get();
        if (t != null && t != PAUSED) {
            return t.getTxId().getUniqId();
        }
        return -1;
    }

    public TXStateProxy masqueradeAs(TransactionMessage msg) throws InterruptedException {
        if (msg.getTXUniqId() == -1 || !msg.canParticipateInTransaction()) {
            return null;
        }
        TXId key = new TXId(msg.getMemberToMasqueradeAs(), msg.getTXUniqId());
        TXStateProxy val = this.getOrSetHostedTXState(key, msg);
        if (val != null) {
            boolean success = this.getLock(val, key);
            while (!success && (val = this.getOrSetHostedTXState(key, msg)) != null) {
                success = this.getLock(val, key);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("masqueradeAs tx {} for msg {} ", (Object)val, (Object)msg);
        }
        this.setTXState(val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TXStateProxy getOrSetHostedTXState(TXId key, TransactionMessage msg) {
        TXStateProxy val = this.hostedTXStates.get(key);
        if (val == null) {
            Map<TXId, TXStateProxy> map = this.hostedTXStates;
            synchronized (map) {
                val = this.hostedTXStates.get(key);
                if (val == null && msg.canStartRemoteTransaction()) {
                    if (msg.isTransactionDistributed()) {
                        val = new DistTXStateProxyImplOnDatanode(this.cache, this, key, msg.getTXOriginatorClient(), this.statisticsClock);
                        val.setLocalTXState(new DistTXState(val, true, this.statisticsClock));
                    } else {
                        val = new TXStateProxyImpl(this.cache, this, key, msg.getTXOriginatorClient(), this.statisticsClock);
                        val.setLocalTXState(new TXState(val, true, this.statisticsClock));
                        val.setTarget(this.cache.getDistributedSystem().getDistributedMember());
                    }
                    this.hostedTXStates.put(key, val);
                }
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getLock(TXStateProxy val, TXId key) {
        if (!val.getLock().isHeldByCurrentThread()) {
            val.getLock().lock();
            Map<TXId, TXStateProxy> map = this.hostedTXStates;
            synchronized (map) {
                TXStateProxy curVal = this.hostedTXStates.get(key);
                if (curVal == null) {
                    if (!this.isHostedTxRecentlyCompleted(key)) {
                        this.hostedTXStates.put(key, val);
                    } else {
                        logger.info("{} has already finished.", (Object)val.getTxId());
                    }
                } else if (val != curVal) {
                    val.getLock().unlock();
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXStateProxy masqueradeAs(Message msg, InternalDistributedMember memberId, boolean probeOnly) throws InterruptedException {
        Map<TXId, TXStateProxy> map;
        if (msg.getTransactionId() == -1) {
            return null;
        }
        TXId key = new TXId(memberId, msg.getTransactionId());
        TXStateProxy val = this.hostedTXStates.get(key);
        if (val == null) {
            map = this.hostedTXStates;
            synchronized (map) {
                val = this.hostedTXStates.get(key);
                if (val == null) {
                    val = msg instanceof TransactionMessage && ((TransactionMessage)((Object)msg)).isTransactionDistributed() ? new DistTXStateProxyImplOnDatanode(this.cache, this, key, memberId, this.statisticsClock) : new TXStateProxyImpl(this.cache, this, key, memberId, this.statisticsClock);
                    this.hostedTXStates.put(key, val);
                }
            }
        }
        if (!probeOnly) {
            if (val != null && !val.getLock().isHeldByCurrentThread()) {
                val.getLock().lock();
                map = this.hostedTXStates;
                synchronized (map) {
                    this.hostedTXStates.put(key, val);
                }
            }
            this.setTXState(val);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("masqueradeAs tx {} for client message {}", (Object)val, (Object)MessageType.getString(msg.getMessageType()));
        }
        return val;
    }

    public void masqueradeAs(TXStateProxy txState) {
        assert (txState != null);
        if (!txState.getLock().isHeldByCurrentThread()) {
            txState.getLock().lock();
        }
        this.setTXState(txState);
        if (logger.isDebugEnabled()) {
            logger.debug("masqueradeAs tx {}", (Object)txState);
        }
    }

    public void unmasquerade(TXStateProxy tx) {
        if (tx != null) {
            if (tx.isOnBehalfOfClient()) {
                this.updateLastOperationTime(tx);
            }
            try {
                this.cleanupTransactionIfNoLongerHostCausedByFailover(tx);
            }
            finally {
                this.setTXState(null);
                tx.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupTransactionIfNoLongerHostCausedByFailover(TXStateProxy tx) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            if (!this.hostedTXStates.containsKey(tx.getTxId()) && tx.isRealDealLocal() && ((TXStateProxyImpl)tx).isRemovedCausedByFailover()) {
                ((TXStateProxyImpl)tx).getLocalRealDeal().cleanup();
            }
        }
    }

    void updateLastOperationTime(TXStateProxy tx) {
        ((TXStateProxyImpl)tx).setLastOperationTimeFromClient(System.currentTimeMillis());
    }

    public TXStateProxy removeHostedTXState(TXId txId) {
        return this.removeHostedTXState(txId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXStateProxy removeHostedTXState(TXId txId, boolean causedByFailover) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            TXStateProxy result = this.hostedTXStates.remove(txId);
            if (result != null) {
                result.close();
                if (causedByFailover) {
                    ((TXStateProxyImpl)result).setRemovedCausedByFailover(true);
                }
            }
            return result;
        }
    }

    public void removeHostedTXState(Set<TXId> txIds) {
        for (TXId txId : txIds) {
            this.removeHostedTXState(txId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHostedTXStatesForClients() {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            Iterator<Map.Entry<TXId, TXStateProxy>> iterator = this.hostedTXStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TXId, TXStateProxy> entry = iterator.next();
                if (!entry.getValue().isOnBehalfOfClient()) continue;
                entry.getValue().close();
                if (logger.isDebugEnabled()) {
                    logger.debug("Cleaning up TXStateProxy for {}", (Object)entry.getKey());
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHostedTxInProgress(TXId txId) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            TXStateProxy tx = this.hostedTXStates.get(txId);
            if (tx == null) {
                return false;
            }
            return tx.isRealDealLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXStateProxy getHostedTXState(TXId txId) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            return this.hostedTXStates.get(txId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hostedTransactionsInProgressForTest() {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            return this.hostedTXStates.size();
        }
    }

    public int localTransactionsInProgressForTest() {
        return this.localTxMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            Iterator<Map.Entry<TXId, TXStateProxy>> iterator = this.hostedTXStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TXId, TXStateProxy> me = iterator.next();
                TXId txId = me.getKey();
                if (!txId.getMemberId().equals(id)) continue;
                me.getValue().close();
                if (logger.isDebugEnabled()) {
                    logger.debug("Received memberDeparted, cleaning up txState:{}", (Object)txId);
                }
                iterator.remove();
            }
        }
        this.expireClientTransactionsSentFromDepartedProxy(id);
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TXId> getTransactionsForClient(InternalDistributedMember id) {
        HashSet<TXId> result = new HashSet<TXId>();
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            for (Map.Entry<TXId, TXStateProxy> entry : this.hostedTXStates.entrySet()) {
                if (!entry.getKey().getMemberId().equals(id)) continue;
                result.add(entry.getKey());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TXStateProxy> getTransactionStatesForClient(InternalDistributedMember id) {
        HashSet<TXStateProxy> result = new HashSet<TXStateProxy>();
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            for (Map.Entry<TXId, TXStateProxy> entry : this.hostedTXStates.entrySet()) {
                if (!entry.getKey().getMemberId().equals(id)) continue;
                result.add(entry.getValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredClientTransactions(Set<TXId> txIds) {
        if (logger.isDebugEnabled()) {
            logger.debug("expiring the following transactions: {}", txIds);
        }
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            for (TXId txId : txIds) {
                this.scheduleToRemoveExpiredClientTransaction(txId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void removeTransactions(Set<TXId> txIds, boolean distribute) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            Iterator<Map.Entry<TXId, TXStateProxy>> iterator = this.hostedTXStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TXId, TXStateProxy> entry = iterator.next();
                if (!txIds.contains(entry.getKey())) continue;
                entry.getValue().close();
                iterator.remove();
            }
        }
    }

    void saveTXStateForClientFailover(TXStateProxy tx) {
        if (tx.isOnBehalfOfClient() && tx.isRealDealLocal()) {
            TXCommitMessage commitMessage = tx.getCommitMessage() == null ? TXCommitMessage.ROLLBACK_MSG : tx.getCommitMessage();
            this.failoverMap.put(tx.getTxId(), commitMessage);
            if (logger.isDebugEnabled()) {
                logger.debug("TX: storing client initiated transaction:{}; now there are {} entries in the failoverMap", (Object)tx.getTxId(), (Object)this.failoverMap.size());
            }
        }
    }

    private void saveTXStateForClientFailover(TXStateProxy tx, TXCommitMessage msg) {
        if (tx.isOnBehalfOfClient() && tx.isRealDealLocal()) {
            this.failoverMap.put(tx.getTxId(), msg);
            if (logger.isDebugEnabled()) {
                logger.debug("TX: storing client initiated transaction:{}; now there are {} entries in the failoverMap", (Object)tx.getTxId(), (Object)this.failoverMap.size());
            }
        }
    }

    public void saveTXCommitMessageForClientFailover(TXId txId, TXCommitMessage msg) {
        this.failoverMap.put(txId, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHostedTxRecentlyCompleted(TXId txId) {
        Map<TXId, TXCommitMessage> map = this.failoverMap;
        synchronized (map) {
            if (this.failoverMap.containsKey(txId)) {
                TXCommitMessage msg = this.failoverMap.remove(txId);
                this.failoverMap.put(txId, msg);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCompletingTransaction(TXId txId) {
        TXStateProxy val = this.hostedTXStates.get(txId);
        if (val == null) {
            Map<TXId, TXStateProxy> map = this.hostedTXStates;
            synchronized (map) {
                val = this.hostedTXStates.get(txId);
            }
        }
        if (val != null && val.isRealDealLocal()) {
            TXStateProxyImpl impl = (TXStateProxyImpl)val;
            TXState state = impl.getLocalRealDeal();
            return state.waitForPreviousCompletion();
        }
        return false;
    }

    public TXCommitMessage getRecentlyCompletedMessage(TXId txId) {
        return this.failoverMap.get(txId);
    }

    public boolean isExceptionToken(TXCommitMessage msg) {
        return msg == TXCommitMessage.CMT_CONFLICT_MSG || msg == TXCommitMessage.REBALANCE_MSG || msg == TXCommitMessage.EXCEPTION_MSG;
    }

    public RuntimeException getExceptionForToken(TXCommitMessage msg, TXId txId) {
        if (msg == TXCommitMessage.CMT_CONFLICT_MSG) {
            return new CommitConflictException(String.format("Conflict detected in GemFire transaction %s", txId));
        }
        if (msg == TXCommitMessage.REBALANCE_MSG) {
            return new TransactionDataRebalancedException("Transactional data moved, due to rebalancing.");
        }
        if (msg == TXCommitMessage.EXCEPTION_MSG) {
            return new TransactionInDoubtException("Commit failed on cache server");
        }
        throw new InternalGemFireError("the parameter TXCommitMessage is not an exception token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireDisconnectedClientTransactions(Set<TXId> txIds, boolean distribute) {
        long timeout = (long)((double)TimeUnit.SECONDS.toMillis(this.getTransactionTimeToLive()) * 1.1);
        if (timeout <= 0L) {
            this.removeHostedTXState(txIds);
        }
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            for (Map.Entry<TXId, TXStateProxy> entry : this.hostedTXStates.entrySet()) {
                if (!txIds.contains(entry.getKey())) continue;
                this.scheduleToRemoveClientTransaction(entry.getKey(), timeout);
            }
        }
        if (distribute) {
            this.expireClientTransactionsOnRemoteServer(txIds);
        }
    }

    void expireClientTransactionsOnRemoteServer(Set<TXId> txIds) {
        ExpireDisconnectedClientTransactionsMessage.send(this.dm, this.dm.getOtherDistributionManagerIds(), txIds);
    }

    void scheduleToRemoveClientTransaction(final TXId txId, long timeout) {
        if (timeout <= 0L) {
            this.removeHostedTXState(txId);
        } else {
            if (this.scheduledToBeRemovedTx != null) {
                this.scheduledToBeRemovedTx.add(txId);
            }
            SystemTimer.SystemTimerTask task = new SystemTimer.SystemTimerTask(){

                @Override
                public void run2() {
                    TXManagerImpl.this.scheduleToRemoveExpiredClientTransaction(txId);
                    if (TXManagerImpl.this.scheduledToBeRemovedTx != null) {
                        TXManagerImpl.this.scheduledToBeRemovedTx.remove(txId);
                    }
                }
            };
            this.getCache().getCCPTimer().schedule(task, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleToRemoveExpiredClientTransaction(TXId txId) {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            TXStateProxy result = this.hostedTXStates.get(txId);
            if (result != null && ((TXStateProxyImpl)result).isOverTransactionTimeoutLimit()) {
                result.close();
                this.hostedTXStates.remove(txId);
            }
        }
    }

    @Override
    public TransactionId suspend() {
        return this.suspend(TimeUnit.MINUTES);
    }

    TransactionId suspend(TimeUnit expiryTimeUnit) {
        TXStateProxy result = this.getTXState();
        if (result != null) {
            TransactionId txId = result.getTransactionId();
            result.suspend();
            this.setTXState(null);
            this.suspendedTXs.put(txId, result);
            Queue waitingThreads = (Queue)this.waitMap.get(txId);
            if (waitingThreads != null) {
                Thread waitingThread = null;
                while ((waitingThread = (Thread)waitingThreads.poll()) != null && Thread.currentThread().equals(waitingThread)) {
                }
                if (waitingThread != null) {
                    LockSupport.unpark(waitingThread);
                }
            }
            this.scheduleExpiry(txId, expiryTimeUnit);
            return txId;
        }
        return null;
    }

    @Override
    public void resume(TransactionId transactionId) {
        if (transactionId == null) {
            throw new IllegalStateException("Trying to resume unknown transaction, or transaction resumed by another thread");
        }
        if (this.getTXState() != null) {
            throw new IllegalStateException("Cannot resume transaction, current thread has an active transaction");
        }
        TXStateProxy txProxy = (TXStateProxy)this.suspendedTXs.remove(transactionId);
        if (txProxy == null) {
            throw new IllegalStateException("Trying to resume unknown transaction, or transaction resumed by another thread");
        }
        this.resumeProxy(txProxy);
    }

    @Override
    public boolean isSuspended(TransactionId transactionId) {
        return this.suspendedTXs.containsKey(transactionId);
    }

    @Override
    public boolean tryResume(TransactionId transactionId) {
        if (transactionId == null || this.getTXState() != null) {
            return false;
        }
        TXStateProxy txProxy = (TXStateProxy)this.suspendedTXs.remove(transactionId);
        if (txProxy != null) {
            this.resumeProxy(txProxy);
            return true;
        }
        return false;
    }

    private void resumeProxy(TXStateProxy txProxy) {
        assert (txProxy != null);
        assert (this.getTXState() == null);
        this.setTXState(txProxy);
        txProxy.resume();
        SystemTimer.SystemTimerTask task = (SystemTimer.SystemTimerTask)this.expiryTasks.remove(txProxy.getTransactionId());
        if (task != null && task.cancel()) {
            this.cache.purgeCCPTimer();
        }
    }

    Queue<Thread> getWaitQueue(TransactionId transactionId) {
        return (Queue)this.waitMap.get(transactionId);
    }

    private Queue<Thread> getOrCreateWaitQueue(TransactionId transactionId) {
        Queue<Thread> oldq;
        Queue<Thread> threadq = this.getWaitQueue(transactionId);
        if (threadq == null && (oldq = this.waitMap.putIfAbsent(transactionId, threadq = new ConcurrentLinkedQueue<Thread>())) != null) {
            threadq = oldq;
        }
        return threadq;
    }

    @Override
    public boolean tryResume(TransactionId transactionId, long time, TimeUnit unit) {
        if (transactionId == null || this.getTXState() != null || !this.exists(transactionId)) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        long endTime = System.nanoTime() + unit.toNanos(time);
        Queue<Thread> threadq = this.getOrCreateWaitQueue(transactionId);
        try {
            while (true) {
                if (!threadq.contains(currentThread)) {
                    threadq.add(currentThread);
                }
                if (this.tryResume(transactionId)) {
                    boolean bl = true;
                    return bl;
                }
                if (!this.exists(transactionId)) {
                    boolean bl = false;
                    return bl;
                }
                long parkTimeout = endTime - System.nanoTime();
                if (parkTimeout <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                this.parkToRetryResume(parkTimeout);
            }
        }
        finally {
            threadq.remove(currentThread);
        }
    }

    void parkToRetryResume(long timeout) {
        LockSupport.parkNanos(timeout);
    }

    @Override
    public boolean exists(TransactionId transactionId) {
        return this.isHostedTxInProgress((TXId)transactionId) || this.isSuspended(transactionId) || this.localTxMap.containsKey(transactionId);
    }

    public void setSuspendedTransactionTimeout(long timeout) {
        this.suspendedTXTimeout = timeout;
    }

    public long getSuspendedTransactionTimeout() {
        return this.suspendedTXTimeout;
    }

    private void scheduleExpiry(TransactionId txId, TimeUnit expiryTimeUnit) {
        if (this.suspendedTXTimeout < 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug("TX: transaction: {} not scheduled to expire", (Object)txId);
            }
            return;
        }
        TXExpiryTask task = new TXExpiryTask(txId);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: scheduling transaction: {} to expire after:{}", (Object)txId, (Object)this.suspendedTXTimeout);
        }
        this.cache.getCCPTimer().schedule((SystemTimer.SystemTimerTask)task, TimeUnit.MILLISECONDS.convert(this.suspendedTXTimeout, expiryTimeUnit));
        this.expiryTasks.put(txId, task);
    }

    public static void incRefCount(AbstractRegionEntry re) {
        TXManagerImpl mgr = currentInstance;
        if (mgr != null) {
            mgr.refCountMap.create(re, incCallback, null, null, true);
        }
    }

    public static boolean decRefCount(AbstractRegionEntry re) {
        TXManagerImpl mgr = currentInstance;
        if (mgr != null) {
            return mgr.refCountMap.removeConditionally(re, decCallback, null, null) != null;
        }
        return true;
    }

    public Set<TXId> getLocalTxIds() {
        return this.localTxMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TXId> getHostedTxIds() {
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            return new ArrayList<TXId>(this.hostedTXStates.keySet());
        }
    }

    public void setTransactionTimeToLiveForTest(int seconds) {
        this.transactionTimeToLive = seconds;
    }

    public int getTransactionTimeToLive() {
        return this.transactionTimeToLive;
    }

    public InternalDistributedMember getMemberId() {
        return this.distributionMgrId;
    }

    private void expireClientTransactionsSentFromDepartedProxy(final InternalDistributedMember proxyServer) {
        block7: {
            if (this.cache.isClosed()) {
                return;
            }
            long timeout = (long)this.getTransactionTimeToLive() * 1000L;
            if (timeout <= 0L) {
                this.removeTransactionsSentFromDepartedProxy(proxyServer);
            } else {
                if (this.departedProxyServers != null) {
                    this.departedProxyServers.add(proxyServer);
                }
                SystemTimer.SystemTimerTask task = new SystemTimer.SystemTimerTask(){

                    @Override
                    public void run2() {
                        TXManagerImpl.this.removeTransactionsSentFromDepartedProxy(proxyServer);
                        if (TXManagerImpl.this.departedProxyServers != null) {
                            TXManagerImpl.this.departedProxyServers.remove(proxyServer);
                        }
                    }
                };
                try {
                    this.cache.getCCPTimer().schedule(task, timeout);
                }
                catch (IllegalStateException ise) {
                    if (!this.cache.isClosed()) {
                        throw ise;
                    }
                    if (this.departedProxyServers == null) break block7;
                    this.departedProxyServers.remove(proxyServer);
                }
            }
        }
    }

    public Set<InternalDistributedMember> getDepartedProxyServers() {
        return this.departedProxyServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionsSentFromDepartedProxy(InternalDistributedMember proxyServer) {
        Set<TXId> txIds = this.getTransactionsSentFromDepartedProxy(proxyServer);
        if (txIds.isEmpty()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("expiring the following transactions: {}", (Object)Arrays.toString(txIds.toArray()));
        }
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            Iterator<Map.Entry<TXId, TXStateProxy>> iterator = this.hostedTXStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TXId, TXStateProxy> entry = iterator.next();
                if (!txIds.contains(entry.getKey())) continue;
                entry.getValue().close();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<TXId> getTransactionsSentFromDepartedProxy(InternalDistributedMember proxyServer) {
        HashSet<TXId> result = new HashSet<TXId>();
        Map<TXId, TXStateProxy> map = this.hostedTXStates;
        synchronized (map) {
            for (Map.Entry<TXId, TXStateProxy> entry : this.hostedTXStates.entrySet()) {
                TXState txstate;
                TXStateProxy tx = entry.getValue();
                if (!tx.isRealDealLocal() || !tx.isOnBehalfOfClient() || !proxyServer.equals((txstate = (TXState)((TXStateProxyImpl)tx).realDeal).getProxyServer())) continue;
                result.add(entry.getKey());
            }
        }
        return result;
    }

    @Override
    public void setDistributed(boolean flag) {
        this.checkClosed();
        TXStateProxy tx = this.getTXState();
        if (tx != null && flag != this.isDistributed()) {
            throw new IllegalStateException("Transaction mode cannot be changed when the thread has an active transaction");
        }
        this.isTXDistributed.set(flag);
    }

    @Override
    public boolean isDistributed() {
        Boolean value = this.isTXDistributed.get();
        if (value == null) {
            InternalDistributedSystem ids = (InternalDistributedSystem)this.cache.getDistributedSystem();
            return ids.getOriginalConfig().getDistributedTransactions();
        }
        return value;
    }

    Map<TXId, TXStateProxy> getHostedTXStates() {
        return this.hostedTXStates;
    }

    public boolean isHostedTXStatesEmpty() {
        return this.hostedTXStates.isEmpty();
    }

    public Set<TXId> getScheduledToBeRemovedTx() {
        return this.scheduledToBeRemovedTx;
    }

    @VisibleForTesting
    public int getFailoverMapSize() {
        return this.failoverMap.size();
    }

    private static class RefCountMapEntry
    implements CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> {
        private final AbstractRegionEntry key;
        private CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> next;
        private volatile int refCount;
        private static final AtomicIntegerFieldUpdater<RefCountMapEntry> refCountUpdater = AtomicIntegerFieldUpdater.newUpdater(RefCountMapEntry.class, "refCount");

        public RefCountMapEntry(AbstractRegionEntry k) {
            this.key = k;
            this.refCount = 1;
        }

        @Override
        public AbstractRegionEntry getKey() {
            return this.key;
        }

        @Override
        public boolean isKeyEqual(Object k) {
            return this.key.equals(k);
        }

        @Override
        public RefCountMapEntry getMapValue() {
            return this;
        }

        @Override
        public void setMapValue(RefCountMapEntry newValue) {
            if (newValue != this) {
                throw new IllegalStateException("Expected newValue " + newValue + " to be this " + this);
            }
        }

        @Override
        public int getEntryHash() {
            return this.key.getEntryHash();
        }

        @Override
        public CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> getNextEntry() {
            return this.next;
        }

        @Override
        public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> n) {
            this.next = n;
        }

        public void incRefCount() {
            refCountUpdater.addAndGet(this, 1);
        }

        public boolean decRefCount() {
            int rc = refCountUpdater.decrementAndGet(this);
            if (rc < 0) {
                throw new IllegalStateException("rc=" + rc);
            }
            return rc == 0;
        }
    }

    private static class RefCountMapEntryCreator
    implements CustomEntryConcurrentHashMap.HashEntryCreator<AbstractRegionEntry, RefCountMapEntry> {
        private RefCountMapEntryCreator() {
        }

        @Override
        public CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> newEntry(AbstractRegionEntry key, int hash, CustomEntryConcurrentHashMap.HashEntry<AbstractRegionEntry, RefCountMapEntry> next, RefCountMapEntry value) {
            value.setNextEntry(next);
            return value;
        }

        @Override
        public int keyHashCode(Object key, boolean compareValues) {
            return ((AbstractRegionEntry)key).getEntryHash();
        }
    }

    public static class TXExpiryTask
    extends SystemTimer.SystemTimerTask {
        private final TransactionId txId;

        public TXExpiryTask(TransactionId txId) {
            this.txId = txId;
        }

        @Override
        public void run2() {
            TXManagerImpl mgr = currentInstance;
            TXStateProxy tx = (TXStateProxy)mgr.suspendedTXs.remove(this.txId);
            if (tx != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("TX: Expiry task rolling back transaction: {}", (Object)this.txId);
                    }
                    tx.rollback();
                }
                catch (GemFireException e) {
                    logger.warn(String.format("Exception occurred while rolling back timed out transaction %s", this.txId), (Throwable)e);
                }
            }
        }
    }
}

