/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.event;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.event.BulkOperationHolder;
import org.apache.geode.internal.cache.event.EventSequenceNumberHolder;
import org.apache.geode.internal.cache.event.EventTracker;

public class EventTrackerExpiryTask
extends SystemTimer.SystemTimerTask {
    private final long lifetimeInMillis;
    private final List<EventTracker> trackers = new LinkedList<EventTracker>();
    private final boolean traceEnabled = logger.isTraceEnabled();

    public EventTrackerExpiryTask(long lifetimeInMillis) {
        this.lifetimeInMillis = lifetimeInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTracker(EventTracker tracker) {
        List<EventTracker> list = this.trackers;
        synchronized (list) {
            this.trackers.add(tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTracker(EventTracker tracker) {
        List<EventTracker> list = this.trackers;
        synchronized (list) {
            this.trackers.remove(tracker);
        }
    }

    int getNumberOfTrackers() {
        return this.trackers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run2() {
        long now = System.currentTimeMillis();
        long expirationTime = now - this.lifetimeInMillis;
        List<EventTracker> list = this.trackers;
        synchronized (list) {
            for (EventTracker tracker : this.trackers) {
                if (this.traceEnabled) {
                    logger.trace("{} sweeper: starting", (Object)tracker.getName());
                }
                this.removeExpiredSequenceTracker(tracker, now, expirationTime);
                this.removeExpiredBulkOperations(tracker, now, expirationTime);
                if (!this.traceEnabled) continue;
                logger.trace("{} sweeper: done", (Object)tracker.getName());
            }
        }
    }

    private void removeExpiredSequenceTracker(EventTracker tracker, long now, long expirationTime) {
        Iterator entryIterator = tracker.getRecordedEvents().entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            EventSequenceNumberHolder evh = (EventSequenceNumberHolder)entry.getValue();
            if (!evh.expire(now, expirationTime)) continue;
            if (this.traceEnabled) {
                logger.trace("{} sweeper: removing {}", (Object)tracker.getName(), entry.getKey());
            }
            entryIterator.remove();
        }
    }

    private void removeExpiredBulkOperations(EventTracker tracker, long now, long expirationTime) {
        Iterator entryIterator = tracker.getRecordedBulkOpVersionTags().entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            BulkOperationHolder evh = (BulkOperationHolder)entry.getValue();
            if (!evh.expire(now, expirationTime)) continue;
            if (this.traceEnabled) {
                logger.trace("{} sweeper: removing bulkOp {}", (Object)tracker.getName(), entry.getKey());
            }
            entryIterator.remove();
        }
    }
}

