/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXStateProxyImpl;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DefaultResultCollector;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.NoResult;
import org.apache.geode.internal.cache.execute.TimeoutHelper;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.execute.util.SynchronizedResultCollector;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ServerRegionFunctionExecutor
extends AbstractExecution {
    private static final Logger logger = LogService.getLogger();
    private final LocalRegion region;
    private boolean executeOnBucketSet = false;

    ServerRegionFunctionExecutor(Region r, ProxyCache proxyCache) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "Region"));
        }
        this.region = (LocalRegion)r;
        this.proxyCache = proxyCache;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, Object args) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(serverRegionFunctionExecutor.filter);
        this.args = args;
        this.executeOnBucketSet = serverRegionFunctionExecutor.executeOnBucketSet;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, MemberMappedArgument memberMapargs) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(serverRegionFunctionExecutor.filter);
        this.memberMappedArg = memberMapargs;
        this.executeOnBucketSet = serverRegionFunctionExecutor.executeOnBucketSet;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, ResultCollector rc) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(serverRegionFunctionExecutor.filter);
        this.rc = rc != null ? new SynchronizedResultCollector(rc) : null;
        this.executeOnBucketSet = serverRegionFunctionExecutor.executeOnBucketSet;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, Set filter2) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(filter2);
        this.executeOnBucketSet = serverRegionFunctionExecutor.executeOnBucketSet;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, Set<Integer> bucketsAsFilter, boolean executeOnBucketSet) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(bucketsAsFilter);
        this.executeOnBucketSet = executeOnBucketSet;
    }

    public Execution withFilter(Set fltr) {
        if (fltr == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "filter"));
        }
        this.executeOnBucketSet = false;
        return new ServerRegionFunctionExecutor(this, fltr);
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        if (bucketIDs == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "buckets as filter"));
        }
        return new ServerRegionFunctionExecutor(this, bucketIDs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResultCollector executeFunction(Function function, long timeout, TimeUnit unit) {
        byte hasResult = 0;
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            if (function.hasResult()) {
                int timeoutMs = TimeoutHelper.toMillis(timeout, unit);
                hasResult = 1;
                if (this.rc == null) {
                    DefaultResultCollector defaultCollector = new DefaultResultCollector();
                    ResultCollector resultCollector = this.executeOnServer(function, defaultCollector, hasResult, timeoutMs);
                    return resultCollector;
                }
                ResultCollector resultCollector = this.executeOnServer(function, this.rc, hasResult, timeoutMs);
                return resultCollector;
            }
            this.executeOnServerNoAck(function, hasResult);
            NoResult noResult = new NoResult();
            return noResult;
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultCollector executeFunction(String functionId, boolean resultReq, boolean isHA, boolean optimizeForWrite, long timeout, TimeUnit unit) {
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            byte hasResult = 0;
            if (resultReq) {
                hasResult = 1;
                int timeoutMs = TimeoutHelper.toMillis(timeout, unit);
                if (this.rc == null) {
                    DefaultResultCollector defaultCollector = new DefaultResultCollector();
                    ResultCollector resultCollector = this.executeOnServer(functionId, defaultCollector, hasResult, isHA, optimizeForWrite, timeoutMs);
                    return resultCollector;
                }
                ResultCollector resultCollector = this.executeOnServer(functionId, this.rc, hasResult, isHA, optimizeForWrite, timeoutMs);
                return resultCollector;
            }
            this.executeOnServerNoAck(functionId, hasResult, isHA, optimizeForWrite);
            NoResult noResult = new NoResult();
            return noResult;
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
    }

    private ResultCollector executeOnServer(Function function, ResultCollector collector, byte hasResult, int timeoutMs) throws FunctionException {
        ServerRegionProxy srp = this.getServerRegionProxy();
        FunctionStats stats = FunctionStatsManager.getFunctionStats(function.getId(), this.region.getSystem());
        long start = stats.startFunctionExecution(true);
        try {
            this.validateExecution(function, (Set)null);
            srp.executeFunction(function, this, collector, hasResult, timeoutMs);
            stats.endFunctionExecution(start, true);
            return collector;
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(start, true);
            throw functionException;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(start, true);
            throw new FunctionException(exception);
        }
    }

    private ResultCollector executeOnServer(String functionId, ResultCollector collector, byte hasResult, boolean isHA, boolean optimizeForWrite, int timeoutMs) throws FunctionException {
        ServerRegionProxy srp = this.getServerRegionProxy();
        FunctionStats stats = FunctionStatsManager.getFunctionStats(functionId, this.region.getSystem());
        long start = stats.startFunctionExecution(true);
        try {
            this.validateExecution((Function)null, (Set)null);
            srp.executeFunction(functionId, this, collector, hasResult, isHA, optimizeForWrite, timeoutMs);
            stats.endFunctionExecution(start, true);
            return collector;
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(start, true);
            throw functionException;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(start, true);
            throw new FunctionException(exception);
        }
    }

    private void executeOnServerNoAck(Function function, byte hasResult) throws FunctionException {
        ServerRegionProxy srp = this.getServerRegionProxy();
        FunctionStats stats = FunctionStatsManager.getFunctionStats(function.getId(), this.region.getSystem());
        long start = stats.startFunctionExecution(false);
        try {
            this.validateExecution(function, (Set)null);
            srp.executeFunctionNoAck(this.region.getFullPath(), function, this, hasResult);
            stats.endFunctionExecution(start, false);
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(start, false);
            throw functionException;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(start, false);
            throw new FunctionException(exception);
        }
    }

    private void executeOnServerNoAck(String functionId, byte hasResult, boolean isHA, boolean optimizeForWrite) throws FunctionException {
        ServerRegionProxy srp = this.getServerRegionProxy();
        FunctionStats stats = FunctionStatsManager.getFunctionStats(functionId, this.region.getSystem());
        long start = stats.startFunctionExecution(false);
        try {
            this.validateExecution((Function)null, (Set)null);
            srp.executeFunctionNoAck(this.region.getFullPath(), functionId, this, hasResult, isHA, optimizeForWrite);
            stats.endFunctionExecution(start, false);
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(start, false);
            throw functionException;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(start, false);
            throw new FunctionException(exception);
        }
    }

    private ServerRegionProxy getServerRegionProxy() throws FunctionException {
        ServerRegionProxy srp = this.region.getServerProxy();
        if (srp != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found server region proxy on region. RegionName: {}", (Object)this.region.getName());
            }
            return srp;
        }
        String message = srp + ": No available connection was found. Server Region Proxy is not available for this region " + this.region.getName();
        throw new FunctionException(message);
    }

    public LocalRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return "[ ServerRegionExecutor: args=" + this.args + " ;filter=" + this.filter + " ;region=" + this.region.getName() + "]";
    }

    public Execution setArguments(Object args) {
        if (args == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "args"));
        }
        return new ServerRegionFunctionExecutor(this, args);
    }

    public Execution withArgs(Object args) {
        return this.setArguments(args);
    }

    public Execution withCollector(ResultCollector rs) {
        if (rs == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "Result Collector"));
        }
        return new ServerRegionFunctionExecutor(this, rs);
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "MemberMappedArgument"));
        }
        return new ServerRegionFunctionExecutor(this, argument);
    }

    public void validateExecution(Function function, Set targetMembers) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && cache.getTxManager().getTXState() != null) {
            TXStateProxyImpl tx = (TXStateProxyImpl)cache.getTxManager().getTXState();
            tx.getRealDeal(null, this.region);
            tx.incOperationCount();
        }
    }

    @Override
    public ResultCollector execute(String functionName) {
        return this.execute(functionName, (long)this.getTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCollector execute(String functionName, long timeout, TimeUnit unit) {
        if (functionName == null) {
            throw new FunctionException("The input function for the execute function request is null");
        }
        int timeoutInMs = (int)TimeUnit.MILLISECONDS.convert(timeout, unit);
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            byte[] functionAttributes = this.getFunctionAttributes(functionName);
            if (functionAttributes == null) {
                try {
                    if (this.proxyCache != null) {
                        if (this.proxyCache.isClosed()) {
                            throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                        }
                        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                    }
                    ServerRegionProxy srp = this.getServerRegionProxy();
                    byte[] obj = srp.getFunctionAttributes(functionName);
                    functionAttributes = obj;
                    this.addFunctionAttributes(functionName, functionAttributes);
                }
                finally {
                    UserAttributes.userAttributes.set(null);
                }
            }
            boolean isHA = functionAttributes[1] == 1;
            boolean hasResult = functionAttributes[0] == 1;
            boolean optimizeForWrite = functionAttributes[2] == 1;
            return this.executeFunction(functionName, hasResult, isHA, optimizeForWrite, timeout, unit);
        }
        return this.executeFunction(functionObject, timeout, unit);
    }

    public boolean getExecuteOnBucketSetFlag() {
        return this.executeOnBucketSet;
    }
}

