/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetails;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;

public class OfflineMemberDetailsImpl
implements OfflineMemberDetails,
Serializable,
DataSerializable {
    private Set<PersistentMemberID>[] offlineMembers;

    public OfflineMemberDetailsImpl() {
    }

    public OfflineMemberDetailsImpl(Set<PersistentMemberID>[] offlineMembers) {
        this.offlineMembers = offlineMembers;
    }

    @Override
    public Set<PersistentMemberID> getOfflineMembers(int bucketId) {
        return this.offlineMembers[bucketId];
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int offlineMembersLength = in.readInt();
        this.offlineMembers = new Set[offlineMembersLength];
        for (int i = 0; i < offlineMembersLength; ++i) {
            int setSize = in.readInt();
            HashSet<PersistentMemberID> set = new HashSet<PersistentMemberID>(setSize);
            for (int j = 0; j < setSize; ++j) {
                PersistentMemberID id = new PersistentMemberID();
                InternalDataSerializer.invokeFromData(id, in);
                set.add(id);
            }
            this.offlineMembers[i] = set;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.offlineMembers.length);
        for (Set<PersistentMemberID> set : this.offlineMembers) {
            out.writeInt(set.size());
            for (PersistentMemberID id : set) {
                InternalDataSerializer.invokeToData(id, out);
            }
        }
    }
}

