/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.geode.CancelException;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.InterestRegistrationEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class ClientInterestList {
    private static final Logger logger = LogService.getLogger();
    final CacheClientProxy cacheClientProxy;
    final Object id;
    private final Object interestListLock = new Object();
    protected final Set<String> regions = new HashSet<String>();

    protected ClientInterestList(@NotNull CacheClientProxy cacheClientProxy, @NotNull Object id) {
        this.cacheClientProxy = cacheClientProxy;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClientInterest(@NotNull String regionName, @NotNull Object keyOfInterest, @NotNull InterestType interestType2, boolean sendUpdatesAsInvalidates) {
        Set keysRegistered;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: registerClientInterest region={} key={}", (Object)this.cacheClientProxy, (Object)regionName, keyOfInterest);
        }
        Object object = this.interestListLock;
        synchronized (object) {
            LocalRegion r = (LocalRegion)this.cacheClientProxy._cache.getRegion(regionName, true);
            if (r == null) {
                throw new RegionDestroyedException("Region could not be found for interest registration", regionName);
            }
            if (!(r instanceof CacheDistributionAdvisee)) {
                throw new IllegalArgumentException("region " + regionName + " is not distributed and does not support interest registration");
            }
            FilterProfile p = r.getFilterProfile();
            keysRegistered = p.registerClientInterest(this.id, keyOfInterest, interestType2, sendUpdatesAsInvalidates);
            this.regions.add(regionName);
        }
        if (keysRegistered != null && this.containsInterestRegistrationListeners() && !keysRegistered.isEmpty()) {
            this.handleInterestEvent(regionName, keysRegistered, interestType2, true);
        }
    }

    protected FilterProfile getProfile(String regionName) {
        try {
            return this.cacheClientProxy._cache.getFilterProfile(regionName);
        }
        catch (CancelException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterClientInterest(String regionName, Object keyOfInterest, @NotNull InterestType interestType2) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: unregisterClientInterest region={} key={}", (Object)this.cacheClientProxy, (Object)regionName, keyOfInterest);
        }
        FilterProfile p = this.getProfile(regionName);
        Set keysUnregistered = null;
        Object object = this.interestListLock;
        synchronized (object) {
            if (p != null) {
                keysUnregistered = p.unregisterClientInterest(this.id, keyOfInterest, interestType2);
                if (!p.hasInterestFor(this.id)) {
                    this.regions.remove(regionName);
                }
            } else {
                this.regions.remove(regionName);
            }
        }
        if (keysUnregistered != null && !keysUnregistered.isEmpty()) {
            this.handleInterestEvent(regionName, keysUnregistered, interestType2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClientInterestList(@NotNull String regionName, @NotNull List<?> keysOfInterest, boolean sendUpdatesAsInvalidates) {
        Set keysRegistered;
        FilterProfile p = this.getProfile(regionName);
        if (p == null) {
            throw new RegionDestroyedException("Region not found during client interest registration", regionName);
        }
        Object object = this.interestListLock;
        synchronized (object) {
            keysRegistered = p.registerClientInterestList(this.id, keysOfInterest, sendUpdatesAsInvalidates);
            this.regions.add(regionName);
        }
        if (this.containsInterestRegistrationListeners() && !keysRegistered.isEmpty()) {
            this.handleInterestEvent(regionName, keysRegistered, InterestType.KEY, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterClientInterestList(@NotNull String regionName, @NotNull List<?> keysOfInterest) {
        FilterProfile p = this.getProfile(regionName);
        Set keysUnregistered = null;
        Object object = this.interestListLock;
        synchronized (object) {
            if (p != null) {
                keysUnregistered = p.unregisterClientInterestList(this.id, keysOfInterest);
                if (!p.hasInterestFor(this.id)) {
                    this.regions.remove(regionName);
                }
            } else {
                this.regions.remove(regionName);
            }
        }
        if (!ObjectUtils.isEmpty((Object)keysUnregistered)) {
            this.handleInterestEvent(regionName, keysUnregistered, InterestType.KEY, false);
        }
    }

    protected boolean hasInterest() {
        return this.regions.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearClientInterestList() {
        boolean isClosed = this.cacheClientProxy.getCache().isClosed();
        Object object = this.interestListLock;
        synchronized (object) {
            for (String regionName : this.regions) {
                FilterProfile p = this.getProfile(regionName);
                if (p == null) continue;
                if (!isClosed) {
                    Map<String, Pattern> patternsOfInterest;
                    Set keysOfInterest;
                    if (p.hasAllKeysInterestFor(this.id)) {
                        Set<String> allKeys = Collections.singleton(".*");
                        this.handleInterestEvent(regionName, allKeys, InterestType.REGULAR_EXPRESSION, false);
                    }
                    if ((keysOfInterest = p.getKeysOfInterestFor(this.id)) != null && keysOfInterest.size() > 0) {
                        this.handleInterestEvent(regionName, keysOfInterest, InterestType.KEY, false);
                    }
                    if ((patternsOfInterest = p.getPatternsOfInterestFor(this.id)) != null && patternsOfInterest.size() > 0) {
                        this.handleInterestEvent(regionName, patternsOfInterest.keySet(), InterestType.REGULAR_EXPRESSION, false);
                    }
                }
                p.clearInterestFor(this.id);
            }
            this.regions.clear();
        }
    }

    private void handleInterestEvent(@NotNull String regionName, @NotNull Set<?> keysOfInterest, @NotNull InterestType interestType2, boolean isRegister) {
        InterestRegistrationEventImpl event = null;
        if (CacheClientProxy.NOTIFY_REGION_ON_INTEREST && this.cacheClientProxy.isPrimary() && interestType2 == InterestType.KEY) {
            event = new InterestRegistrationEventImpl(this.cacheClientProxy, regionName, keysOfInterest, interestType2, isRegister);
            try {
                this.notifyRegionOfInterest(event);
            }
            catch (Exception e) {
                logger.warn("Region notification of interest failed", (Throwable)e);
            }
        }
        if (this.containsInterestRegistrationListeners()) {
            if (event == null) {
                event = new InterestRegistrationEventImpl(this.cacheClientProxy, regionName, keysOfInterest, interestType2, isRegister);
            }
            this.notifyInterestRegistrationListeners(event);
        }
    }

    private void notifyRegionOfInterest(InterestRegistrationEvent event) {
        this.cacheClientProxy.getCacheClientNotifier().handleInterestEvent(event);
    }

    private void notifyInterestRegistrationListeners(InterestRegistrationEvent event) {
        this.cacheClientProxy.getCacheClientNotifier().notifyInterestRegistrationListeners(event);
    }

    private boolean containsInterestRegistrationListeners() {
        return this.cacheClientProxy.getCacheClientNotifier().containsInterestRegistrationListeners();
    }
}

