/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.operations.RegionClearOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class ClearRegion
extends BaseCommand {
    @Immutable
    private static final ClearRegion singleton = new ClearRegion();

    private ClearRegion() {
    }

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Part eventPart = null;
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadClearRegionRequestTime(start - oldStart);
        regionNamePart = clientMessage.getPart(0);
        eventPart = clientMessage.getPart(1);
        if (clientMessage.getNumberOfParts() > 2) {
            callbackArgPart = clientMessage.getPart(2);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                ClearRegion.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getCachedString();
        if (logger.isDebugEnabled()) {
            logger.debug(serverConnection.getName() + ": Received clear region request (" + clientMessage.getPayloadLength() + " bytes) from " + serverConnection.getSocketString() + " for region " + regionName);
        }
        if (regionName == null) {
            logger.warn("{}: The input region name for the clear region request is null", (Object)serverConnection.getName());
            String errMessage = "The input region name for the clear region request is null";
            ClearRegion.writeErrorResponse(clientMessage, 37, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
        if (region == null) {
            String reason = "was not found during clear region request";
            ClearRegion.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptimizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptimizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                RegionClearOperationContext clearContext = authzRequest.clearAuthorize(regionName, callbackArg);
                callbackArg = clearContext.getCallbackArg();
            }
            region.basicBridgeClear(callbackArg, serverConnection.getProxyID(), true, eventId);
        }
        catch (Exception e) {
            ClearRegion.checkForInterrupt(serverConnection, e);
            ClearRegion.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessClearRegionTime(start - oldStart2);
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug(serverConnection.getName() + ": Sent clear region response for region " + regionName);
        }
        stats.incWriteClearRegionResponseTime(DistributionStats.getStatTime() - start);
    }
}

