/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.serial;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.asyncqueue.AsyncEvent;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.event.EventTracker;
import org.apache.geode.internal.cache.event.NonDistributedEventTracker;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.serial.BatchDestroyOperation;
import org.apache.geode.internal.cache.wan.serial.SerialSecondaryGatewayListener;
import org.apache.geode.internal.offheap.OffHeapClearRequired;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.beans.AsyncEventQueueMBean;
import org.apache.geode.management.internal.beans.GatewaySenderMBean;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.logging.log4j.Logger;

public class SerialGatewaySenderQueue
implements RegionQueue {
    private static final Logger logger = LogService.getLogger();
    private long headKey;
    private final AtomicLong tailKey = new AtomicLong();
    private final AtomicLong lastPeekedId = new AtomicLong(-1L);
    private final Deque<Long> peekedIds = new LinkedBlockingDeque<Long>();
    private final Set<Long> extraPeekedIds = ConcurrentHashMap.newKeySet();
    private final Set<Long> extraPeekedIdsRemovedButPreviousIdNotRemoved = ConcurrentHashMap.newKeySet();
    private final String regionName;
    private Region<Long, AsyncEvent<?, ?>> region;
    private final String diskStoreName;
    private final int maximumQueueMemory;
    private final boolean enableConflation;
    private final boolean enablePersistence;
    private final boolean cleanQueues;
    private final boolean isDiskSynchronous;
    private final Map<String, Map<Object, Long>> indexes;
    private final GatewaySenderStats stats;
    private static final long MAXIMUM_KEY = Long.MAX_VALUE;
    private static final boolean NO_ACK = Boolean.getBoolean("gemfire.gateway-queue-no-ack");
    private volatile long lastDispatchedKey = -1L;
    private volatile long lastDestroyedKey = -1L;
    public static final int DEFAULT_MESSAGE_SYNC_INTERVAL = 1;
    @Immutable
    private static final int messageSyncInterval = 1;
    private final BatchRemovalThread removalThread;
    private final AbstractGatewaySender sender;
    private final MetaRegionFactory metaRegionFactory;

    public SerialGatewaySenderQueue(AbstractGatewaySender abstractSender, String regionName, CacheListener<Long, AsyncEvent<?, ?>> listener, boolean cleanQueues) {
        this(abstractSender, regionName, listener, cleanQueues, new MetaRegionFactory());
    }

    public SerialGatewaySenderQueue(AbstractGatewaySender abstractSender, String regionName, CacheListener<Long, AsyncEvent<?, ?>> listener, boolean cleanQueues, MetaRegionFactory metaRegionFactory) {
        this.regionName = regionName;
        this.cleanQueues = cleanQueues;
        this.metaRegionFactory = metaRegionFactory;
        this.headKey = -1L;
        this.tailKey.set(-1L);
        this.indexes = new HashMap<String, Map<Object, Long>>();
        this.enableConflation = abstractSender.isBatchConflationEnabled();
        this.diskStoreName = abstractSender.getDiskStoreName();
        this.enablePersistence = abstractSender.isPersistenceEnabled();
        this.isDiskSynchronous = this.enablePersistence ? abstractSender.isDiskSynchronous() : false;
        this.maximumQueueMemory = abstractSender.getMaximumMemeoryPerDispatcherQueue();
        this.stats = abstractSender.getStatistics();
        this.initializeRegion(abstractSender, listener);
        this.stats.incQueueSize(this.region.size());
        this.removalThread = new BatchRemovalThread(abstractSender.getCache());
        this.removalThread.start();
        this.sender = abstractSender;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Contains {} elements", (Object)this, (Object)this.size());
        }
    }

    @Override
    public Region<Long, AsyncEvent<?, ?>> getRegion() {
        return this.region;
    }

    public void destroy() {
        this.getRegion().localDestroyRegion();
    }

    @Override
    public synchronized boolean put(Object event) throws CacheException {
        GatewaySenderEventImpl eventImpl = (GatewaySenderEventImpl)event;
        Region<?, ?> r = eventImpl.getRegion();
        boolean isPDXRegion = r instanceof DistributedRegion && r.getName().equals("PdxTypes");
        boolean isWbcl = this.regionName.startsWith("AsyncEventQueue_");
        if (!isPDXRegion || !isWbcl) {
            this.putAndGetKey(event);
            return true;
        }
        return false;
    }

    private void putAndGetKey(Object object) throws CacheException {
        Long key = this.getTailKey();
        this.region.put(key, (AsyncEvent)object);
        this.incrementTailKey();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Inserted {} -> {}", (Object)this, (Object)key, object);
        }
        if (object instanceof Conflatable) {
            this.removeOldEntry((Conflatable)object, key);
        }
    }

    @Override
    public AsyncEvent<?, ?> take() throws CacheException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AsyncEvent<?, ?>> take(int batchSize) throws CacheException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove() throws CacheException {
        Long key;
        boolean wasEmpty;
        block11: {
            if (this.peekedIds.isEmpty()) {
                return;
            }
            wasEmpty = this.lastDispatchedKey == this.lastDestroyedKey;
            key = this.peekedIds.remove();
            boolean isExtraPeekedId = this.extraPeekedIds.contains(key);
            if (!isExtraPeekedId) {
                this.updateHeadKey(key);
                this.lastDispatchedKey = key;
            } else {
                this.extraPeekedIdsRemovedButPreviousIdNotRemoved.add(key);
            }
            this.removeIndex(key);
            try {
                this.region.localDestroy(key, "WAN_QUEUE_TOKEN");
                this.stats.decQueueSize();
            }
            catch (EntryNotFoundException ok) {
                if (!logger.isDebugEnabled()) break block11;
                logger.debug("{}: Did not destroy entry at {} it was not there. It should have been removed by conflation.", (Object)this, (Object)key);
            }
        }
        long tmpKey = this.lastDispatchedKey;
        while (this.extraPeekedIdsRemovedButPreviousIdNotRemoved.contains(tmpKey = this.inc(tmpKey))) {
            this.extraPeekedIdsRemovedButPreviousIdNotRemoved.remove(tmpKey);
            this.extraPeekedIds.remove(tmpKey);
            this.updateHeadKey(tmpKey);
            this.lastDispatchedKey = tmpKey;
        }
        if (wasEmpty) {
            SerialGatewaySenderQueue serialGatewaySenderQueue = this;
            synchronized (serialGatewaySenderQueue) {
                this.notifyAll();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Destroyed entry at key {} setting the lastDispatched Key to {}. The last destroyed entry was {}", (Object)this, (Object)key, (Object)this.lastDispatchedKey, (Object)this.lastDestroyedKey);
        }
    }

    @Override
    public void remove(int size) throws CacheException {
        for (int i = 0; i < size; ++i) {
            this.remove();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Removed a batch of {} entries", (Object)this, (Object)size);
        }
    }

    @Override
    public Object peek() throws CacheException {
        KeyAndEventPair object = this.peekAhead();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Peeked {} -> {}", (Object)this, this.peekedIds, (Object)object);
        }
        return object.event;
    }

    @Override
    public List<AsyncEvent<?, ?>> peek(int size) throws CacheException {
        return this.peek(size, -1);
    }

    @Override
    public List<AsyncEvent<?, ?>> peek(int size, int timeToWait) throws CacheException {
        boolean isTraceEnabled = logger.isTraceEnabled();
        long start = System.currentTimeMillis();
        long end = start + (long)timeToWait;
        if (isTraceEnabled) {
            logger.trace("{}: Peek start time={} end time={} time to wait={}", (Object)this, (Object)start, (Object)end, (Object)timeToWait);
        }
        ArrayList batch = new ArrayList(size == BATCH_BASED_ON_TIME_ONLY ? 100 : size);
        long lastKey = -1L;
        while (size == BATCH_BASED_ON_TIME_ONLY || batch.size() < size) {
            KeyAndEventPair pair = this.peekAhead();
            if (pair != null) {
                AsyncEvent<?, ?> object = pair.event;
                lastKey = pair.key;
                batch.add(object);
                continue;
            }
            long currentTime = System.currentTimeMillis();
            if (isTraceEnabled) {
                logger.trace("{}: Peek current time: {}", (Object)this, (Object)currentTime);
            }
            if (timeToWait == -1 || end <= currentTime) {
                if (!isTraceEnabled) break;
                logger.trace("{}: Peek breaking", (Object)this);
                break;
            }
            if (isTraceEnabled) {
                logger.trace("{}: Peek continuing", (Object)this);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (batch.size() > 0) {
            this.peekEventsFromIncompleteTransactions(batch, lastKey);
        }
        if (isTraceEnabled) {
            logger.trace("{}: Peeked a batch of {} entries", (Object)this, (Object)batch.size());
        }
        return batch;
    }

    @VisibleForTesting
    void peekEventsFromIncompleteTransactions(List<AsyncEvent<?, ?>> batch, long lastKey) {
        if (!this.mustGroupTransactionEvents()) {
            return;
        }
        Set<TransactionId> incompleteTransactionIdsInBatch = this.getIncompleteTransactionsInBatch(batch);
        if (incompleteTransactionIdsInBatch.size() == 0) {
            return;
        }
        int retries = 0;
        while (true) {
            Iterator<TransactionId> iter = incompleteTransactionIdsInBatch.iterator();
            while (iter.hasNext()) {
                TransactionId transactionId = iter.next();
                List<KeyAndEventPair> keyAndEventPairs = this.peekEventsWithTransactionId(transactionId, lastKey);
                if (keyAndEventPairs.size() <= 0 || !((GatewaySenderEventImpl)keyAndEventPairs.get((int)(keyAndEventPairs.size() - 1)).event).isLastEventInTransaction()) continue;
                for (KeyAndEventPair object : keyAndEventPairs) {
                    GatewaySenderEventImpl event = (GatewaySenderEventImpl)object.event;
                    batch.add(event);
                    this.peekedIds.add(object.key);
                    this.extraPeekedIds.add(object.key);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Peeking extra event: {}, isLastEventInTransaction: {}, batch size: {}", event.getKey(), (Object)event.isLastEventInTransaction(), (Object)batch.size());
                }
                iter.remove();
            }
            if (incompleteTransactionIdsInBatch.size() == 0 || retries >= this.sender.getRetriesToGetTransactionEventsFromQueue()) break;
            ++retries;
            try {
                Thread.sleep(GatewaySender.GET_TRANSACTION_EVENTS_FROM_QUEUE_WAIT_TIME_MS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (incompleteTransactionIdsInBatch.size() > 0) {
            logger.warn("Not able to retrieve all events for transactions: {} after {} retries of {}ms", incompleteTransactionIdsInBatch, (Object)retries, (Object)GatewaySender.GET_TRANSACTION_EVENTS_FROM_QUEUE_WAIT_TIME_MS);
            this.stats.incBatchesWithIncompleteTransactions();
        }
    }

    protected boolean mustGroupTransactionEvents() {
        return this.sender.mustGroupTransactionEvents();
    }

    private Set<TransactionId> getIncompleteTransactionsInBatch(List<AsyncEvent<?, ?>> batch) {
        HashSet<TransactionId> incompleteTransactionsInBatch = new HashSet<TransactionId>();
        for (AsyncEvent<?, ?> object : batch) {
            GatewaySenderEventImpl event;
            if (!(object instanceof GatewaySenderEventImpl) || (event = (GatewaySenderEventImpl)object).getTransactionId() == null) continue;
            if (event.isLastEventInTransaction()) {
                incompleteTransactionsInBatch.remove(event.getTransactionId());
                continue;
            }
            incompleteTransactionsInBatch.add(event.getTransactionId());
        }
        return incompleteTransactionsInBatch;
    }

    public String toString() {
        return "SerialGatewaySender queue :" + this.regionName;
    }

    @Override
    public int size() {
        int size = ((LocalRegion)this.region).entryCount();
        return size + this.sender.getTmpQueuedEventSize();
    }

    @Override
    public void addCacheListener(CacheListener listener) {
        AttributesMutator<Long, AsyncEvent<?, ?>> mutator = this.region.getAttributesMutator();
        mutator.addCacheListener((CacheListener)UncheckedUtils.uncheckedCast((Object)listener));
    }

    @Override
    public void removeCacheListener() {
        CacheListener<Long, AsyncEvent<?, ?>>[] listeners;
        AttributesMutator<Long, AsyncEvent<?, ?>> mutator = this.region.getAttributesMutator();
        for (CacheListener<Long, AsyncEvent<?, ?>> listener : listeners = this.region.getAttributes().getCacheListeners()) {
            if (!(listener instanceof SerialSecondaryGatewayListener)) continue;
            mutator.removeCacheListener(listener);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldEntry(Conflatable object, Long tailKey) throws CacheException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.enableConflation && object.shouldBeConflated()) {
            boolean keepOldEntry;
            Long previousIndex;
            if (isDebugEnabled) {
                logger.debug("{}: Conflating {} at queue index={} queue size={} head={} tail={}", (Object)this, (Object)object, (Object)tailKey, (Object)this.size(), (Object)this.headKey, (Object)tailKey);
            }
            String rName = object.getRegionToConflate();
            Object key = object.getKeyToConflate();
            SerialGatewaySenderQueue serialGatewaySenderQueue = this;
            synchronized (serialGatewaySenderQueue) {
                Map latestIndexesForRegion = this.indexes.computeIfAbsent(rName, k -> new HashMap());
                previousIndex = latestIndexesForRegion.put(key, tailKey);
            }
            if (isDebugEnabled) {
                logger.debug("{}: Adding index key={}->index={} for {} head={} tail={}", (Object)this, key, (Object)tailKey, (Object)object, (Object)this.headKey, (Object)tailKey);
            }
            if (previousIndex != null) {
                if (isDebugEnabled) {
                    logger.debug("{}: Indexes contains index={} for key={} head={} tail={} and it can be used.", (Object)this, (Object)previousIndex, key, (Object)this.headKey, (Object)tailKey);
                }
                keepOldEntry = false;
            } else {
                if (isDebugEnabled) {
                    logger.debug("{}: No old entry for key={} head={} tail={} not removing old entry.", (Object)this, key, (Object)this.headKey, (Object)tailKey);
                }
                this.stats.incConflationIndexesMapSize();
                keepOldEntry = true;
            }
            if (!keepOldEntry) {
                Conflatable previous = (Conflatable)((Object)this.region.remove(previousIndex));
                this.stats.decQueueSize(1);
                if (isDebugEnabled) {
                    logger.debug("{}: Previous conflatable at key={} head={} tail={}: {}", (Object)this, (Object)previousIndex, (Object)this.headKey, (Object)tailKey, (Object)previous);
                    logger.debug("{}: Current conflatable at key={} head={} tail={}: {}", (Object)this, (Object)tailKey, (Object)this.headKey, (Object)tailKey, (Object)object);
                    if (previous != null) {
                        logger.debug("{}: Removed {} and added {} for key={} head={} tail={} in queue for region={} old event={}", (Object)this, previous.getValueToConflate(), object.getValueToConflate(), key, (Object)this.headKey, (Object)tailKey, (Object)rName, (Object)previous);
                    }
                }
            }
        } else if (isDebugEnabled) {
            logger.debug("{}: Not conflating {} queue size: {} head={} tail={}", (Object)this, (Object)object, (Object)this.size(), (Object)this.headKey, (Object)tailKey);
        }
    }

    private AsyncEvent<?, ?> optimalGet(Long k) {
        LocalRegion lr = (LocalRegion)this.region;
        Object o = null;
        try {
            o = lr.getValueInVMOrDiskWithoutFaultIn(k);
            if (o instanceof CachedDeserializable) {
                o = ((CachedDeserializable)o).getDeserializedValue(lr, lr.getRegionEntry(k));
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        if (o == Token.TOMBSTONE) {
            o = null;
        }
        return (AsyncEvent)o;
    }

    private void removeIndex(Long qkey) {
        Conflatable object;
        AsyncEvent<?, ?> o;
        if (this.enableConflation && (o = this.optimalGet(qkey)) instanceof Conflatable && (object = (Conflatable)((Object)o)).shouldBeConflated()) {
            String rName = object.getRegionToConflate();
            Object key = object.getKeyToConflate();
            Map<Object, Long> latestIndexesForRegion = this.indexes.get(rName);
            if (latestIndexesForRegion != null) {
                Long index = latestIndexesForRegion.remove(key);
                if (index != null) {
                    this.stats.decConflationIndexesMapSize();
                }
                if (logger.isDebugEnabled() && index != null) {
                    logger.debug("{}: Removed index {} for {}", (Object)this, (Object)index, (Object)object);
                }
            }
        }
    }

    private boolean before(long a, long b) {
        return a < b ^ a - b > 0x3FFFFFFFFFFFFFFFL;
    }

    private long inc(long value) {
        long val = value + 1L;
        val = val == Long.MAX_VALUE ? 0L : val;
        return val;
    }

    public void resetLastPeeked() {
        this.peekedIds.clear();
        this.extraPeekedIds.clear();
        this.lastPeekedId.set(-1L);
    }

    private Long getCurrentKey() {
        long currentKey = this.lastPeekedId.get() == -1L ? this.getHeadKey() : this.inc(this.lastPeekedId.get());
        return currentKey;
    }

    private AsyncEvent<?, ?> getObjectInSerialSenderQueue(Long currentKey) {
        GatewaySenderEventImpl object = this.optimalGet(currentKey);
        if (null != object && logger.isDebugEnabled()) {
            logger.debug("{}: Peeked {}->{}", (Object)this, (Object)currentKey, object);
        }
        if (object instanceof GatewaySenderEventImpl) {
            GatewaySenderEventImpl copy = ((GatewaySenderEventImpl)object).makeHeapCopyIfOffHeap();
            if (copy == null) {
                logger.debug("Unable to make heap copy and will not be added to peekedIds for object : {} ", (Object)((Object)object).toString());
            }
            object = copy;
        }
        return object;
    }

    @VisibleForTesting
    public KeyAndEventPair peekAhead() throws CacheException {
        AsyncEvent<?, ?> object = null;
        Long currentKey = this.getCurrentKey();
        if (currentKey == null) {
            return null;
        }
        while (this.before(currentKey, this.getTailKey()) && (this.extraPeekedIds.contains(currentKey) || (object = this.getObjectInSerialSenderQueue(currentKey)) == null)) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Trying head key + offset: {}", (Object)this, (Object)currentKey);
            }
            currentKey = this.inc(currentKey);
            if (this.mustGroupTransactionEvents() || this.stats == null) continue;
            this.stats.incEventsNotQueuedConflated();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Peeked {}->{}", (Object)this, (Object)currentKey, object);
        }
        if (object != null) {
            this.peekedIds.add(currentKey);
            this.lastPeekedId.set(currentKey);
            return new KeyAndEventPair(currentKey, object);
        }
        return null;
    }

    private List<KeyAndEventPair> peekEventsWithTransactionId(TransactionId transactionId, long lastKey) {
        Predicate<GatewaySenderEventImpl> hasTransactionIdPredicate = x -> transactionId.equals(x.getTransactionId());
        Predicate<GatewaySenderEventImpl> isLastEventInTransactionPredicate = GatewaySenderEventImpl::isLastEventInTransaction;
        return this.getElementsMatching(hasTransactionIdPredicate, isLastEventInTransactionPredicate, lastKey);
    }

    List<KeyAndEventPair> getElementsMatching(Predicate<GatewaySenderEventImpl> condition, Predicate<GatewaySenderEventImpl> stopCondition, long lastKey) {
        ArrayList<KeyAndEventPair> elementsMatching = new ArrayList<KeyAndEventPair>();
        long currentKey = lastKey;
        while ((currentKey = this.inc(currentKey)) != this.getTailKey()) {
            GatewaySenderEventImpl event;
            if (this.extraPeekedIds.contains(currentKey) || (event = (GatewaySenderEventImpl)this.optimalGet(currentKey)) == null || !condition.test(event)) continue;
            elementsMatching.add(new KeyAndEventPair(currentKey, event));
            if (!stopCondition.test(event)) continue;
            break;
        }
        return elementsMatching;
    }

    private long getTailKey() throws CacheException {
        this.initializeKeys();
        long tlKey = this.tailKey.get();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Determined tail key: {}", (Object)this, (Object)tlKey);
        }
        return tlKey;
    }

    private void incrementTailKey() throws CacheException {
        this.tailKey.set(this.inc(this.tailKey.get()));
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Incremented TAIL_KEY for region {} to {}", (Object)this, (Object)this.region.getName(), (Object)this.tailKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeys() throws CacheException {
        if (this.tailKey.get() != -1L) {
            return;
        }
        SerialGatewaySenderQueue serialGatewaySenderQueue = this;
        synchronized (serialGatewaySenderQueue) {
            long largestKey = -1L;
            long largestKeyLessThanHalfMax = -1L;
            long smallestKey = -1L;
            long smallestKeyGreaterThanHalfMax = -1L;
            Set<Long> keySet = this.region.keySet();
            for (Long key : keySet) {
                long k = key;
                if (k > largestKey) {
                    largestKey = k;
                }
                if (k > largestKeyLessThanHalfMax && k < 0x3FFFFFFFFFFFFFFFL) {
                    largestKeyLessThanHalfMax = k;
                }
                if (k < smallestKey || smallestKey == -1L) {
                    smallestKey = k;
                }
                if (k >= smallestKeyGreaterThanHalfMax && smallestKeyGreaterThanHalfMax != -1L || k <= 0x3FFFFFFFFFFFFFFFL) continue;
                smallestKeyGreaterThanHalfMax = k;
            }
            if (smallestKeyGreaterThanHalfMax != -1L && largestKeyLessThanHalfMax != -1L && smallestKeyGreaterThanHalfMax - largestKeyLessThanHalfMax > 0x3FFFFFFFFFFFFFFFL) {
                this.headKey = smallestKeyGreaterThanHalfMax;
                this.tailKey.set(this.inc(largestKeyLessThanHalfMax));
                logger.info("{}: During failover, detected that keys have wrapped tailKey={} headKey={}", new Object[]{this, this.tailKey, this.headKey});
            } else {
                this.headKey = smallestKey == -1L ? 0L : smallestKey;
                this.tailKey.set(this.inc(largestKey));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Initialized tail key to: {}, head key to: {}", (Object)this, (Object)this.tailKey, (Object)this.headKey);
            }
        }
    }

    private long getHeadKey() throws CacheException {
        this.initializeKeys();
        long hKey = this.headKey;
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Determined head key: {}", (Object)this, (Object)hKey);
        }
        return hKey;
    }

    private void updateHeadKey(long destroyedKey) throws CacheException {
        this.headKey = this.inc(destroyedKey);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Incremented HEAD_KEY for region {} to {}", (Object)this, (Object)this.region.getName(), (Object)this.headKey);
        }
    }

    private void initializeRegion(AbstractGatewaySender sender, CacheListener<Long, AsyncEvent<?, ?>> listener) {
        InternalCache gemCache = sender.getCache();
        this.region = gemCache.getRegion(this.regionName);
        if (this.region == null) {
            RegionShortcut regionShortcut = this.enablePersistence ? RegionShortcut.REPLICATE_PERSISTENT : RegionShortcut.REPLICATE;
            InternalRegionFactory<Long, AsyncEvent<?, ?>> factory = gemCache.createInternalRegionFactory(regionShortcut);
            if (NO_ACK) {
                factory.setScope(Scope.DISTRIBUTED_NO_ACK);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("The policy of region is {}", (Object)(this.enablePersistence ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE));
            }
            if (listener != null) {
                factory.addCacheListener(listener);
            }
            EvictionAttributes ea = EvictionAttributes.createLIFOMemoryAttributes(this.maximumQueueMemory, EvictionAction.OVERFLOW_TO_DISK);
            factory.setEvictionAttributes(ea);
            factory.setConcurrencyChecksEnabled(false);
            factory.setDiskStoreName(this.diskStoreName);
            factory.setDiskSynchronous(this.isDiskSynchronous);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Attempting to create queue region: {}", (Object)this, (Object)this.regionName);
            }
            RegionAttributes ra = factory.getCreateAttributes();
            try {
                SerialGatewaySenderQueueMetaRegion meta = this.metaRegionFactory.newMetaRegion(gemCache, this.regionName, ra, sender);
                factory.setInternalMetaRegion(meta).setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForSerialGatewaySenderQueue(true).setInternalRegion(true).setSerialGatewaySender(sender);
                this.region = factory.create(this.regionName);
                this.addOverflowStatisticsToMBean(gemCache, sender);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Created queue region: {}", (Object)this, this.region);
                }
            }
            catch (CacheException e) {
                logger.fatal(String.format("%s: The queue region named %s could not be created", this, this.regionName), (Throwable)e);
            }
        } else if (listener != null) {
            this.addCacheListener(listener);
        }
        if (this.region != null && this.cleanQueues) {
            this.region.clear();
        }
    }

    @VisibleForTesting
    protected void addOverflowStatisticsToMBean(Cache cache, AbstractGatewaySender sender) {
        LocalRegion lr = (LocalRegion)this.region;
        ManagementService service = ManagementService.getManagementService(cache);
        if (sender.getId().contains("AsyncEventQueue_")) {
            AsyncEventQueueMBean bean = (AsyncEventQueueMBean)service.getLocalAsyncEventQueueMXBean(AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(sender.getId()));
            if (bean != null) {
                bean.getBridge().addOverflowStatistics(lr.getEvictionStatistics());
                bean.getBridge().addOverflowStatistics(lr.getDiskRegion().getStats().getStats());
            }
        } else {
            GatewaySenderMBean bean = (GatewaySenderMBean)service.getLocalGatewaySenderMXBean(sender.getId());
            if (bean != null) {
                bean.getBridge().addOverflowStatistics(lr.getEvictionStatistics());
                bean.getBridge().addOverflowStatistics(lr.getDiskRegion().getStats().getStats());
            }
        }
    }

    public void cleanUp() {
        if (this.removalThread != null) {
            this.removalThread.shutdown();
        }
    }

    public boolean isRemovalThreadAlive() {
        if (this.removalThread != null) {
            return this.removalThread.isAlive();
        }
        return false;
    }

    @Override
    public void close() {
        Region<Long, AsyncEvent<?, ?>> r = this.getRegion();
        if (r != null && !r.isDestroyed()) {
            try {
                r.close();
            }
            catch (RegionDestroyedException regionDestroyedException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    long getLastPeekedId() {
        return this.lastPeekedId.get();
    }

    @VisibleForTesting
    Set<Long> getExtraPeekedIds() {
        return Collections.unmodifiableSet(this.extraPeekedIds);
    }

    public String displayContent() {
        return this.region.keySet().toString();
    }

    static class MetaRegionFactory {
        MetaRegionFactory() {
        }

        SerialGatewaySenderQueueMetaRegion newMetaRegion(InternalCache cache, String regionName, RegionAttributes<?, ?> ra, AbstractGatewaySender sender) {
            return new SerialGatewaySenderQueueMetaRegion(regionName, ra, null, cache, sender, sender.getStatisticsClock());
        }
    }

    public static class SerialGatewaySenderQueueMetaRegion
    extends DistributedRegion {
        final AbstractGatewaySender sender;

        protected SerialGatewaySenderQueueMetaRegion(String regionName, RegionAttributes<?, ?> attrs, LocalRegion parentRegion, InternalCache cache, AbstractGatewaySender sender, StatisticsClock statisticsClock) {
            super(regionName, attrs, parentRegion, cache, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForSerialGatewaySenderQueue(true).setSerialGatewaySender(sender), statisticsClock);
            this.sender = sender;
        }

        @Override
        protected boolean supportsConcurrencyChecks() {
            return false;
        }

        @Override
        public boolean isCopyOnRead() {
            return false;
        }

        @Override
        public boolean isSecret() {
            return true;
        }

        @Override
        public EventTracker createEventTracker() {
            return NonDistributedEventTracker.getInstance();
        }

        @Override
        public boolean shouldNotifyBridgeClients() {
            return false;
        }

        @Override
        public boolean generateEventID() {
            return false;
        }

        @Override
        protected boolean isUsedForSerialGatewaySenderQueue() {
            return true;
        }

        @Override
        public AbstractGatewaySender getSerialGatewaySender() {
            return this.sender;
        }

        @Override
        public void closeEntries() {
            OffHeapClearRequired.doWithOffHeapClear(() -> super.closeEntries());
        }

        @Override
        public Set<VersionSource> clearEntries(RegionVersionVector rvv) {
            AtomicReference result = new AtomicReference();
            OffHeapClearRequired.doWithOffHeapClear(() -> result.set(super.clearEntries(rvv)));
            return (Set)result.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
            try {
                super.basicDestroy(event, cacheWrite, expectedOldValue);
            }
            finally {
                GatewaySenderEventImpl.release(event.getRawOldValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed, boolean invokeCallbacks, boolean throwConcurrentModificaiton) throws TimeoutException, CacheWriterException {
            try {
                boolean success = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, invokeCallbacks, throwConcurrentModificaiton);
                if (!success) {
                    GatewaySenderEventImpl.release(event.getRawNewValue());
                }
                boolean bl = success;
                return bl;
            }
            finally {
                GatewaySenderEventImpl.release(event.getRawOldValue());
            }
        }
    }

    private class BatchRemovalThread
    extends Thread {
        private volatile boolean shutdown = false;
        private final InternalCache cache;

        public BatchRemovalThread(InternalCache c) {
            this.setDaemon(true);
            this.cache = c;
        }

        private boolean checkCancelled() {
            if (this.shutdown) {
                return true;
            }
            return this.cache.getCancelCriterion().isCancelInProgress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block32: {
                try {
                    while (true) {
                        try {
                            while (true) {
                                long temp;
                                if (this.checkCancelled()) {
                                    break block32;
                                }
                                boolean interrupted = Thread.interrupted();
                                try {
                                    BatchRemovalThread batchRemovalThread = this;
                                    synchronized (batchRemovalThread) {
                                        this.wait(1000L);
                                    }
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                    if (this.checkCancelled()) {
                                        // empty if block
                                    }
                                    break block32;
                                }
                                finally {
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug("BatchRemovalThread about to send the last Dispatched key {}", (Object)SerialGatewaySenderQueue.this.lastDispatchedKey);
                                }
                                SerialGatewaySenderQueue serialGatewaySenderQueue = SerialGatewaySenderQueue.this;
                                synchronized (serialGatewaySenderQueue) {
                                    boolean wasEmpty;
                                    temp = SerialGatewaySenderQueue.this.lastDispatchedKey;
                                    boolean bl = wasEmpty = temp == SerialGatewaySenderQueue.this.lastDestroyedKey;
                                    while (SerialGatewaySenderQueue.this.lastDispatchedKey == SerialGatewaySenderQueue.this.lastDestroyedKey) {
                                        SerialGatewaySenderQueue.this.wait();
                                        temp = SerialGatewaySenderQueue.this.lastDispatchedKey;
                                    }
                                    if (wasEmpty) {
                                        continue;
                                    }
                                }
                                EntryEventImpl event = EntryEventImpl.create((InternalRegion)((LocalRegion)SerialGatewaySenderQueue.this.region), Operation.DESTROY, (Object)(SerialGatewaySenderQueue.this.lastDestroyedKey + 1L), null, null, false, this.cache.getMyId());
                                event.disallowOffHeapValues();
                                event.setTailKey(temp);
                                BatchDestroyOperation op = new BatchDestroyOperation(event);
                                op.distribute();
                                if (logger.isDebugEnabled()) {
                                    logger.debug("BatchRemovalThread completed destroy of keys from {} to {}", (Object)SerialGatewaySenderQueue.this.lastDestroyedKey, (Object)temp);
                                }
                                SerialGatewaySenderQueue.this.lastDestroyedKey = temp;
                            }
                        }
                        catch (CancelException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("BatchRemovalThread is exiting due to cancellation");
                            }
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            if (this.checkCancelled()) {
                                break;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("BatchRemovalThread: ignoring exception", t);
                            continue;
                        }
                        break;
                    }
                }
                catch (CancelException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("BatchRemovalThread exiting due to cancellation: " + e);
                    }
                }
                finally {
                    logger.info("The QueueRemovalThread is done.");
                }
            }
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
            boolean interrupted = Thread.interrupted();
            try {
                this.join(15000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isAlive()) {
                logger.warn("QueueRemovalThread ignored cancellation");
            }
        }
    }

    @VisibleForTesting
    static class KeyAndEventPair {
        public final long key;
        public final AsyncEvent<?, ?> event;

        KeyAndEventPair(Long key, AsyncEvent<?, ?> event) {
            this.key = key;
            this.event = event;
        }
    }
}

