/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.Collections;
import java.util.List;
import org.apache.geode.internal.offheap.FreeListManager;
import org.apache.geode.internal.offheap.MemoryBlock;
import org.apache.geode.internal.offheap.MemoryInspector;

public class MemoryInspectorImpl
implements MemoryInspector {
    private List<MemoryBlock> memoryBlocks;
    private final FreeListManager freeList;

    public MemoryInspectorImpl(FreeListManager freeList) {
        this.freeList = freeList;
    }

    @Override
    public synchronized void clearSnapshot() {
        this.memoryBlocks = null;
    }

    @Override
    public synchronized void createSnapshot() {
        List<MemoryBlock> value = this.memoryBlocks;
        if (value == null) {
            this.memoryBlocks = value = this.getOrderedBlocks();
        }
    }

    @Override
    public synchronized List<MemoryBlock> getSnapshot() {
        List<MemoryBlock> value = this.memoryBlocks;
        if (value == null) {
            return Collections.emptyList();
        }
        return value;
    }

    @Override
    public MemoryBlock getFirstBlock() {
        List<MemoryBlock> value = this.getSnapshot();
        if (value.isEmpty()) {
            return null;
        }
        return value.get(0);
    }

    @Override
    public List<MemoryBlock> getAllBlocks() {
        return this.getOrderedBlocks();
    }

    @Override
    public List<MemoryBlock> getAllocatedBlocks() {
        return this.freeList.getAllocatedBlocks();
    }

    @Override
    public MemoryBlock getBlockAfter(MemoryBlock block) {
        if (block == null) {
            return null;
        }
        List<MemoryBlock> blocks = this.getSnapshot();
        int nextBlock = blocks.indexOf(block) + 1;
        if (nextBlock > 0 && blocks.size() > nextBlock) {
            return blocks.get(nextBlock);
        }
        return null;
    }

    private List<MemoryBlock> getOrderedBlocks() {
        return this.freeList.getOrderedBlocks();
    }
}

