/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.logging.internal.executors.LoggingExecutors;

public class NonRealTimeStatsUpdater {
    private final Runnable updateTask;
    private final ScheduledExecutorService updateNonRealTimeStatsExecutor;
    private final AtomicReference<ScheduledFuture<?>> updateNonRealTimeStatsFuture = new AtomicReference();

    NonRealTimeStatsUpdater(Runnable updateTask) {
        this.updateTask = updateTask;
        this.updateNonRealTimeStatsExecutor = LoggingExecutors.newSingleThreadScheduledExecutor((String)"Update Freelist Stats thread");
    }

    void start(int updateOffHeapStatsFrequencyMs) {
        this.updateNonRealTimeStatsFuture.set(this.updateNonRealTimeStatsExecutor.scheduleAtFixedRate(this.updateTask, 0L, updateOffHeapStatsFrequencyMs, TimeUnit.MILLISECONDS));
    }

    void stop() {
        this.updateNonRealTimeStatsFuture.get().cancel(true);
        this.updateNonRealTimeStatsExecutor.shutdown();
    }
}

