/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.StoredObject;

public class OffHeapHelper {
    private OffHeapHelper() {
    }

    public static Object getHeapForm(Object o) {
        if (o instanceof StoredObject) {
            return ((StoredObject)o).getValueAsDeserializedHeapObject();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object copyAndReleaseIfNeeded(Object v, InternalCache cache) {
        if (v instanceof StoredObject) {
            StoredObject ohv = (StoredObject)v;
            try {
                if (ohv.isSerialized()) {
                    CachedDeserializable cachedDeserializable = CachedDeserializableFactory.create(ohv.getSerializedValue(), cache);
                    return cachedDeserializable;
                }
                Object object = ohv.getDeserializedForReading();
                return object;
            }
            finally {
                OffHeapHelper.release(ohv);
            }
        }
        return v;
    }

    public static Object copyIfNeeded(Object v, InternalCache cache) {
        if (v instanceof StoredObject) {
            StoredObject ohv = (StoredObject)v;
            v = ohv.isSerialized() ? CachedDeserializableFactory.create(ohv.getSerializedValue(), cache) : ohv.getDeserializedForReading();
        }
        return v;
    }

    public static boolean release(Object o) {
        if (o instanceof StoredObject) {
            ((StoredObject)o).release();
            return true;
        }
        return false;
    }

    public static boolean releaseWithNoTracking(Object o) {
        if (o instanceof StoredObject) {
            StoredObject so = (StoredObject)o;
            if (!so.hasRefCount()) {
                so.release();
                return true;
            }
            ReferenceCountHelper.skipRefCountTracking();
            so.release();
            ReferenceCountHelper.unskipRefCountTracking();
            return true;
        }
        return false;
    }

    public static boolean releaseAndTrackOwner(Object o, Object owner) {
        if (o instanceof StoredObject) {
            StoredObject so = (StoredObject)o;
            if (!so.hasRefCount()) {
                so.release();
                return true;
            }
            ReferenceCountHelper.setReferenceCountOwner(owner);
            so.release();
            ReferenceCountHelper.setReferenceCountOwner(null);
            return true;
        }
        return false;
    }
}

