/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.offheap.AbstractStoredObject;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.offheap.StoredObject;

public class TinyStoredObject
extends AbstractStoredObject {
    private final long address;

    public TinyStoredObject(long addr) {
        this.address = addr;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TinyStoredObject) {
            return this.getAddress() == ((TinyStoredObject)o).getAddress();
        }
        return false;
    }

    public int hashCode() {
        long value = this.getAddress();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public int getSizeInBytes() {
        return 0;
    }

    public byte[] getDecompressedBytes(RegionEntryContext r) {
        if (this.isCompressed()) {
            byte[] bytes = OffHeapRegionEntryHelper.decodeAddressToRawBytes(this.getAddress());
            long time = r.getCachePerfStats().startDecompression();
            bytes = r.getCompressor().decompress(bytes);
            r.getCachePerfStats().endDecompression(time);
            return bytes;
        }
        return this.getRawBytes();
    }

    public byte[] getRawBytes() {
        return OffHeapRegionEntryHelper.decodeUncompressedAddressToBytes(this.getAddress());
    }

    @Override
    public byte[] getSerializedValue() {
        byte[] value = this.getRawBytes();
        if (!this.isSerialized()) {
            value = EntryEventImpl.serialize(value);
        }
        return value;
    }

    @Override
    public Object getDeserializedValue(Region r, RegionEntry re) {
        return OffHeapRegionEntryHelper.decodeAddressToObject(this.address);
    }

    @Override
    public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
        byte[] value;
        if (this.isSerialized()) {
            value = this.getSerializedValue();
            userBits = EntryBits.setSerialized(userBits, true);
        } else {
            value = (byte[])this.getDeserializedForReading();
        }
        wrapper.setData(value, userBits, value.length, true);
    }

    @Override
    public int getValueSizeInBytes() {
        return 0;
    }

    @Override
    public boolean isSerialized() {
        return OffHeapRegionEntryHelper.isSerialized(this.address);
    }

    @Override
    public boolean isCompressed() {
        return OffHeapRegionEntryHelper.isCompressed(this.address);
    }

    @Override
    public void release() {
    }

    @Override
    public boolean retain() {
        return true;
    }

    @Override
    public int getRefCount() {
        return -1;
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public int getDataSize() {
        return OffHeapRegionEntryHelper.decodeAddressToDataSize(this.address);
    }

    @Override
    public byte readDataByte(int offset) {
        return this.getRawBytes()[offset];
    }

    @Override
    public void writeDataByte(int offset, byte value) {
        throw new UnsupportedOperationException("ObjectStoredAsAddress does not support modifying the data bytes");
    }

    @Override
    public void readDataBytes(int offset, byte[] bytes) {
        this.readDataBytes(offset, bytes, 0, bytes.length);
    }

    @Override
    public void writeDataBytes(int offset, byte[] bytes) {
        this.writeDataBytes(offset, bytes, 0, bytes.length);
    }

    @Override
    public void readDataBytes(int offset, byte[] bytes, int bytesOffset, int size) {
        byte[] src = this.getRawBytes();
        int dstIdx = bytesOffset;
        for (int i = offset; i < offset + size; ++i) {
            bytes[dstIdx++] = src[i];
        }
    }

    @Override
    public void writeDataBytes(int offset, byte[] bytes, int bytesOffset, int size) {
        throw new UnsupportedOperationException("ObjectStoredAsAddress does not support modifying the data bytes");
    }

    @Override
    public ByteBuffer createDirectByteBuffer() {
        return null;
    }

    @Override
    public boolean hasRefCount() {
        return false;
    }

    @Override
    public boolean checkDataEquals(StoredObject so) {
        return this.equals(so);
    }

    @Override
    public boolean checkDataEquals(byte[] serializedObj) {
        byte[] myBytes = this.getSerializedValue();
        return Arrays.equals(myBytes, serializedObj);
    }

    @Override
    public long getAddressForReadingData(int offset, int size) {
        throw new UnsupportedOperationException("ObjectStoredAsAddress does not support reading at an address");
    }

    @Override
    public StoredObject slice(int offset, int limit) {
        throw new UnsupportedOperationException("ObjectStoredAsAddress does not support slice");
    }
}

