/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.size;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.util.concurrent.CopyOnWriteWeakHashMap;

public class ObjectTraverser {
    private final Map<Class<?>, Field[]> FIELD_CACHE = new CopyOnWriteWeakHashMap();
    private final Map<Class<?>, Field[]> STATIC_FIELD_CACHE = new CopyOnWriteWeakHashMap();
    @Immutable
    private static final Field[] NON_PRIMITIVE_ARRAY = new Field[0];
    @Immutable
    private static final Field[] PRIMITIVE_ARRAY = new Field[0];

    public void breadthFirstSearch(Object root, Visitor visitor, boolean includeStatics) throws IllegalArgumentException, IllegalAccessException {
        VisitStack stack = new VisitStack(visitor, includeStatics);
        stack.add(null, root);
        while (!stack.isEmpty()) {
            Object next = stack.next();
            this.doSearch(next, stack);
        }
    }

    private void doSearch(Object root, VisitStack stack) throws IllegalArgumentException, IllegalAccessException {
        Object value;
        boolean includeStatics;
        Class<?> clazz = root.getClass();
        Field[] nonPrimitiveFields = this.getNonPrimitiveFields(clazz, includeStatics = stack.shouldIncludeStatics(clazz));
        if (nonPrimitiveFields == NON_PRIMITIVE_ARRAY) {
            int length = Array.getLength(root);
            for (int i = 0; i < length; ++i) {
                Object value2 = Array.get(root, i);
                stack.add(root, value2);
            }
            return;
        }
        if (includeStatics) {
            for (Field field : this.getStaticFields(clazz)) {
                value = field.get(root);
                stack.add(root, value);
            }
        }
        for (Field field : nonPrimitiveFields) {
            value = field.get(root);
            stack.add(root, value);
        }
    }

    private Field[] getNonPrimitiveFields(Class<?> clazz, boolean includeStatics) {
        Field[] result = this.FIELD_CACHE.get(clazz);
        if (result == null) {
            this.cacheFields(clazz, includeStatics);
            result = this.FIELD_CACHE.get(clazz);
        }
        return result;
    }

    private Field[] getStaticFields(Class<?> clazz) {
        Field[] result = this.STATIC_FIELD_CACHE.get(clazz);
        if (result == null) {
            this.cacheFields(clazz, true);
            result = this.STATIC_FIELD_CACHE.get(clazz);
        }
        return result;
    }

    private void cacheFields(Class<?> clazz, boolean includeStatics) {
        if (clazz != null && clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isPrimitive()) {
                this.FIELD_CACHE.put(clazz, PRIMITIVE_ARRAY);
                this.STATIC_FIELD_CACHE.put(clazz, PRIMITIVE_ARRAY);
            } else {
                this.FIELD_CACHE.put(clazz, NON_PRIMITIVE_ARRAY);
                this.STATIC_FIELD_CACHE.put(clazz, NON_PRIMITIVE_ARRAY);
            }
            return;
        }
        ArrayList<Field> staticFields = new ArrayList<Field>();
        ArrayList<Field> nonPrimitiveFields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                Class<?> fieldType = field.getType();
                if (fieldType.isPrimitive()) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    if (!includeStatics) continue;
                    field.setAccessible(true);
                    staticFields.add(field);
                    continue;
                }
                field.setAccessible(true);
                nonPrimitiveFields.add(field);
            }
        }
        this.FIELD_CACHE.put(clazz, nonPrimitiveFields.toArray(new Field[0]));
        if (includeStatics) {
            this.STATIC_FIELD_CACHE.put(clazz, staticFields.toArray(new Field[0]));
        }
    }

    Map<Class<?>, Field[]> getStaticFieldCache() {
        return this.STATIC_FIELD_CACHE;
    }

    private static class VisitStack {
        private final ReferenceOpenHashSet<Object> seen = new ReferenceOpenHashSet();
        private final LinkedList<Object> stack = new LinkedList();
        private final Visitor visitor;
        private final boolean includeStatics;

        VisitStack(Visitor visitor, boolean includeStatics) {
            this.visitor = visitor;
            this.includeStatics = includeStatics;
        }

        public void add(Object parent, Object object) {
            boolean newObject;
            if (object == null) {
                return;
            }
            boolean bl = newObject = !this.seen.contains(object);
            if (newObject) {
                this.seen.add(object);
                boolean visitChildren = this.visitor.visit(parent, object);
                if (visitChildren) {
                    this.stack.add(object);
                }
            }
        }

        public Object next() {
            return this.stack.removeFirst();
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        public boolean shouldIncludeStatics(Class<?> clazz) {
            if (!this.includeStatics) {
                return false;
            }
            boolean keyExists = this.seen.contains(clazz);
            this.seen.add(clazz);
            return !keyExists;
        }
    }

    public static interface Visitor {
        public boolean visit(Object var1, Object var2);
    }
}

