/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.internal.statistics.ResourceType;

public class ResourceInstance {
    private final int id;
    private final Statistics statistics;
    private final ResourceType type;
    private long[] previousStatValues = null;
    private long[] latestStatValues = null;
    private int[] updatedStats = null;
    private boolean statValuesNotified;

    public ResourceInstance(int id, Statistics statistics, ResourceType type) {
        this.id = id;
        this.statistics = statistics;
        this.type = type;
        this.statValuesNotified = false;
    }

    public int getId() {
        return this.id;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public ResourceType getResourceType() {
        return this.type;
    }

    public boolean getStatValuesNotified() {
        return this.statValuesNotified;
    }

    public void setStatValuesNotified(boolean notified) {
        this.statValuesNotified = notified;
    }

    public Number getStatValue(StatisticDescriptor sd) {
        return this.statistics.get(sd);
    }

    public long getRawStatValue(StatisticDescriptor sd) {
        return this.statistics.getRawBits(sd);
    }

    public long[] getLatestStatValues() {
        return this.latestStatValues;
    }

    public void setLatestStatValues(long[] latestStatValues) {
        this.latestStatValues = latestStatValues;
    }

    public long[] getPreviousStatValues() {
        return this.previousStatValues;
    }

    public void setPreviousStatValues(long[] previousStatValues) {
        this.previousStatValues = previousStatValues;
    }

    public int[] getUpdatedStats() {
        return this.updatedStats;
    }

    public void setUpdatedStats(int[] updatedStats) {
        this.updatedStats = updatedStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("id=").append(this.id);
        if (this.updatedStats == null) {
            sb.append(", updatedStats=null");
        } else {
            sb.append(", updatedStats.length=").append(this.updatedStats.length);
        }
        if (this.previousStatValues == null) {
            sb.append(", previousStatValues=null");
        } else {
            sb.append(", previousStatValues.length=").append(this.previousStatValues.length);
        }
        if (this.latestStatValues == null) {
            sb.append(", latestStatValues=null");
        } else {
            sb.append(", latestStatValues.length=").append(this.latestStatValues.length);
        }
        sb.append(", statistics=").append(this.statistics);
        sb.append(", resourceType=").append(this.type);
        sb.append("}");
        return sb.toString();
    }
}

