/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class StatisticsRegistry
implements StatisticsManager {
    private final StatisticsTypeFactory typeFactory;
    private final AtomicStatisticsFactory atomicStatisticsFactory;
    private final OsStatisticsFactory osStatisticsFactory;
    private final IntSupplier pidSupplier;
    private final String name;
    private final long startTime;
    private final List<Statistics> instances = new CopyOnWriteArrayList<Statistics>();
    private final AtomicLong nextUniqueId = new AtomicLong(1L);
    private int modificationCount;

    public StatisticsRegistry(String name, long startTime) {
        this(name, startTime, StatisticsTypeFactoryImpl.singleton(), LocalStatisticsImpl::createNonAtomic, StatisticsImpl::createAtomicNoOS, ProcessUtils::identifyPidAsUnchecked);
    }

    StatisticsRegistry(String name, long startTime, StatisticsTypeFactory typeFactory, OsStatisticsFactory osStatisticsFactory, AtomicStatisticsFactory atomicStatisticsFactory, IntSupplier pidSupplier) {
        this.name = name;
        this.startTime = startTime;
        this.typeFactory = typeFactory;
        this.osStatisticsFactory = osStatisticsFactory;
        this.atomicStatisticsFactory = atomicStatisticsFactory;
        this.pidSupplier = pidSupplier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPid() {
        return this.pidSupplier.getAsInt();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.instances;
    }

    @Override
    public int getStatListModCount() {
        return this.modificationCount;
    }

    @Override
    public Statistics[] getStatistics() {
        return this.getStatsList().toArray(new Statistics[0]);
    }

    @Override
    public int getStatisticsCount() {
        return this.getStatsList().size();
    }

    @Override
    public StatisticsType createType(String name, String description, StatisticDescriptor[] stats) {
        return this.typeFactory.createType(name, description, stats);
    }

    @Override
    public StatisticsType[] createTypesFromXml(Reader reader) throws IOException {
        return this.typeFactory.createTypesFromXml(reader);
    }

    @Override
    public StatisticsType findType(String name) {
        return this.typeFactory.findType(name);
    }

    @Override
    public Statistics createStatistics(StatisticsType type) {
        return this.createOsStatistics(type, null, 0L, 0);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type) {
        return this.createAtomicStatistics(type, null, 0L);
    }

    @Override
    public Statistics createStatistics(StatisticsType type, String textId) {
        return this.createOsStatistics(type, textId, 0L, 0);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId) {
        return this.createAtomicStatistics(type, textId, 0L);
    }

    @Override
    public Statistics createStatistics(StatisticsType type, String textId, long numericId) {
        return this.createOsStatistics(type, textId, numericId, 0);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId, long numericId) {
        long uniqueId = this.nextUniqueId.getAndIncrement();
        return this.newAtomicStatistics(type, uniqueId, numericId, textId);
    }

    @Override
    public Statistics createOsStatistics(StatisticsType type, String textId, long numericId, int osStatFlags) {
        long uniqueId = this.nextUniqueId.getAndIncrement();
        return this.newOsStatistics(type, uniqueId, numericId, textId, osStatFlags);
    }

    @Override
    public void destroyStatistics(Statistics statisticsToDestroy) {
        this.deregisterDestroyedStatistics(statisticsToDestroy);
    }

    @Override
    public boolean statisticsExists(long uniqueId) {
        return this.anyStatisticsInstance(StatisticsRegistry.withUniqueId(uniqueId)).isPresent();
    }

    @Override
    public Statistics findStatisticsByUniqueId(long uniqueId) {
        return this.anyStatisticsInstance(StatisticsRegistry.withUniqueId(uniqueId)).orElse(null);
    }

    @Override
    public Statistics[] findStatisticsByNumericId(long numericId) {
        return (Statistics[])this.allStatisticsInstances(StatisticsRegistry.withNumericId(numericId)).toArray(Statistics[]::new);
    }

    @Override
    public Statistics[] findStatisticsByTextId(String textId) {
        return (Statistics[])this.allStatisticsInstances(StatisticsRegistry.withTextId(textId)).toArray(Statistics[]::new);
    }

    @Override
    public Statistics[] findStatisticsByType(StatisticsType type) {
        return (Statistics[])this.allStatisticsInstances(StatisticsRegistry.withStatisticsType(type)).toArray(Statistics[]::new);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units) {
        return this.typeFactory.createIntCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units) {
        return this.typeFactory.createLongCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units) {
        return this.typeFactory.createDoubleCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units) {
        return this.typeFactory.createIntGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units) {
        return this.typeFactory.createLongGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units) {
        return this.typeFactory.createDoubleGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units, boolean largerBetter) {
        return this.typeFactory.createIntCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units, boolean largerBetter) {
        return this.typeFactory.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean largerBetter) {
        return this.typeFactory.createDoubleCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units, boolean largerBetter) {
        return this.typeFactory.createIntGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units, boolean largerBetter) {
        return this.typeFactory.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean largerBetter) {
        return this.typeFactory.createDoubleGauge(name, description, units, largerBetter);
    }

    protected Statistics newAtomicStatistics(StatisticsType type, long uniqueId, long numericId, String textId) {
        Statistics statistics = this.atomicStatisticsFactory.create(type, textId, numericId, uniqueId, this);
        this.registerNewStatistics(statistics);
        return statistics;
    }

    protected Statistics newOsStatistics(StatisticsType type, long uniqueId, long numericId, String textId, int osStatFlags) {
        Statistics statistics = this.osStatisticsFactory.create(type, textId, numericId, uniqueId, osStatFlags, this);
        this.registerNewStatistics(statistics);
        return statistics;
    }

    private Stream<Statistics> allStatisticsInstances(Predicate<? super Statistics> predicate) {
        return this.getStatsList().stream().filter(predicate);
    }

    private Optional<Statistics> anyStatisticsInstance(Predicate<? super Statistics> predicate) {
        return this.allStatisticsInstances(predicate).findAny();
    }

    private static Predicate<Statistics> withNumericId(long numericId) {
        return statistics -> statistics.getNumericId() == numericId;
    }

    private static Predicate<Statistics> withStatisticsType(StatisticsType type) {
        return statistics -> statistics.getType() == type;
    }

    private static Predicate<Statistics> withTextId(String textId) {
        return statistics -> textId.equals(statistics.getTextId());
    }

    private static Predicate<Statistics> withUniqueId(long uniqueId) {
        return statistics -> statistics.getUniqueId() == uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewStatistics(Statistics newStatistics) {
        List<Statistics> list = this.instances;
        synchronized (list) {
            this.instances.add(newStatistics);
            ++this.modificationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterDestroyedStatistics(Statistics destroyedStatistics) {
        List<Statistics> list = this.instances;
        synchronized (list) {
            if (this.instances.remove(destroyedStatistics)) {
                ++this.modificationCount;
            }
        }
    }

    public static interface AtomicStatisticsFactory {
        public Statistics create(StatisticsType var1, String var2, long var3, long var5, StatisticsManager var7);
    }

    public static interface OsStatisticsFactory {
        public Statistics create(StatisticsType var1, String var2, long var3, long var5, int var7, StatisticsManager var8);
    }
}

