/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.HashMap;
import java.util.List;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.statistics.MapBasedStatisticsNotification;
import org.apache.geode.internal.statistics.ResourceInstance;
import org.apache.geode.internal.statistics.ResourceType;
import org.apache.geode.internal.statistics.SimpleStatisticId;
import org.apache.geode.internal.statistics.StatisticDescriptorImpl;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticsMonitor;
import org.apache.geode.internal.statistics.StatisticsNotification;

public class ValueMonitor
extends StatisticsMonitor {
    private final CopyOnWriteHashSet<Statistics> statistics = new CopyOnWriteHashSet();

    @Override
    public ValueMonitor addStatistic(StatisticId statId) {
        super.addStatistic(statId);
        return this;
    }

    @Override
    public ValueMonitor removeStatistic(StatisticId statId) {
        super.removeStatistic(statId);
        return this;
    }

    public ValueMonitor addStatistics(Statistics statistics) {
        if (statistics == null) {
            throw new NullPointerException("Statistics is null");
        }
        this.statistics.add(statistics);
        return this;
    }

    public ValueMonitor removeStatistics(Statistics statistics) {
        if (statistics == null) {
            throw new NullPointerException("Statistics is null");
        }
        this.statistics.remove(statistics);
        return this;
    }

    @Override
    protected void monitor(long millisTimeStamp, List<ResourceInstance> resourceInstances) {
        super.monitor(millisTimeStamp, resourceInstances);
        this.monitorStatistics(millisTimeStamp, resourceInstances);
    }

    protected void monitorStatistics(long millisTimeStamp, List<ResourceInstance> resourceInstances) {
        if (!this.statistics.isEmpty()) {
            HashMap<StatisticId, Number> stats = new HashMap<StatisticId, Number>();
            for (ResourceInstance resource : resourceInstances) {
                int[] updatedStats;
                if (!this.statistics.contains(resource.getStatistics())) continue;
                ResourceType resourceType = resource.getResourceType();
                StatisticDescriptor[] sds = resourceType.getStatisticDescriptors();
                resource.setStatValuesNotified(true);
                for (int idx : updatedStats = resource.getUpdatedStats()) {
                    StatisticDescriptorImpl sdi = (StatisticDescriptorImpl)sds[idx];
                    SimpleStatisticId statId = new SimpleStatisticId(sdi, resource.getStatistics());
                    long rawbits = resource.getLatestStatValues()[idx];
                    stats.put(statId, sdi.getNumberForRawBits(rawbits));
                }
            }
            if (!stats.isEmpty()) {
                MapBasedStatisticsNotification notification = new MapBasedStatisticsNotification(millisTimeStamp, StatisticsNotification.Type.VALUE_CHANGED, stats);
                this.notifyListeners(notification);
            }
        }
    }

    @Override
    protected StringBuilder appendToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("statistics=").append(this.statistics);
        return sb;
    }

    public static enum Type {
        CHANGE,
        MATCH,
        DIFFER;

    }
}

