/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal;

import java.util.Collection;
import java.util.TreeMap;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.util.ListCollectingServiceLoader;
import org.apache.geode.logging.internal.SimpleLoggingProvider;
import org.apache.geode.logging.internal.spi.LoggingProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingProviderLoader {
    private static final Logger logger = LogManager.getLogger();
    @VisibleForTesting
    public static final String LOGGING_PROVIDER_NAME_PROPERTY = "geode.LOGGING_PROVIDER_NAME";

    public LoggingProvider load() {
        LoggingProvider providerFromSystemProperty = this.checkSystemProperty();
        if (providerFromSystemProperty != null) {
            logger.info("Using {} from System Property {} for service {}", (Object)providerFromSystemProperty.getClass().getName(), (Object)LOGGING_PROVIDER_NAME_PROPERTY, (Object)LoggingProvider.class.getName());
            return providerFromSystemProperty;
        }
        TreeMap loggingProviders = new TreeMap();
        this.loadServiceProviders().forEach(provider -> loggingProviders.put(provider.getPriority(), provider));
        if (!loggingProviders.isEmpty()) {
            LoggingProvider providerFromServiceLoader = (LoggingProvider)loggingProviders.get(loggingProviders.lastKey());
            logger.info("Using {} from ServiceLoader for service {}", (Object)providerFromServiceLoader.getClass().getName(), (Object)LoggingProvider.class.getName());
            return providerFromServiceLoader;
        }
        logger.info("Using {} for service {}", (Object)SimpleLoggingProvider.class.getName(), (Object)LoggingProvider.class.getName());
        return new SimpleLoggingProvider();
    }

    private Iterable<LoggingProvider> loadServiceProviders() {
        ListCollectingServiceLoader<LoggingProvider> serviceLoader = new ListCollectingServiceLoader<LoggingProvider>();
        Collection<LoggingProvider> loggingProviders = serviceLoader.loadServices(LoggingProvider.class);
        return loggingProviders;
    }

    private LoggingProvider checkSystemProperty() {
        String agentClassName = System.getProperty(LOGGING_PROVIDER_NAME_PROPERTY);
        if (agentClassName == null) {
            return null;
        }
        try {
            Class<LoggingProvider> agentClass = ClassPathLoader.getLatest().forName(agentClassName).asSubclass(LoggingProvider.class);
            return agentClass.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.warn("Unable to create LoggingProvider of type {}", (Object)agentClassName, (Object)e);
            return null;
        }
    }
}

