/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.functions;

import java.util.HashSet;
import org.apache.geode.cache.control.RestoreRedundancyOperation;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.control.SerializableRestoreRedundancyResultsImpl;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.operation.RestoreRedundancyResultsImpl;
import org.apache.geode.management.operation.RestoreRedundancyRequest;

public class RestoreRedundancyFunction
implements InternalFunction<Object[]> {
    public static final String ID = RestoreRedundancyFunction.class.getName();
    private static final long serialVersionUID = -8991672237560920252L;

    @Override
    public void execute(FunctionContext<Object[]> context) {
        RestoreRedundancyResultsImpl results;
        Object[] arguments = context.getArguments();
        RestoreRedundancyRequest request = (RestoreRedundancyRequest)arguments[0];
        boolean isStatusCommand = (Boolean)arguments[1];
        RestoreRedundancyOperation redundancyOperation = context.getCache().getResourceManager().createRestoreRedundancyOperation();
        HashSet<String> includeRegionsSet = null;
        if (request.getIncludeRegions() != null) {
            includeRegionsSet = new HashSet<String>(request.getIncludeRegions());
        }
        HashSet<String> excludeRegionsSet = null;
        if (request.getExcludeRegions() != null) {
            excludeRegionsSet = new HashSet<String>(request.getExcludeRegions());
        }
        redundancyOperation.includeRegions(includeRegionsSet);
        redundancyOperation.excludeRegions(excludeRegionsSet);
        try {
            if (isStatusCommand) {
                results = (RestoreRedundancyResultsImpl)redundancyOperation.redundancyStatus();
            } else {
                redundancyOperation.shouldReassignPrimaries(request.getReassignPrimaries());
                results = (RestoreRedundancyResultsImpl)redundancyOperation.start().join();
            }
            results.setSuccess(true);
            results.setStatusMessage("Success");
        }
        catch (Exception e) {
            results = new SerializableRestoreRedundancyResultsImpl();
            results.setSuccess(false);
            results.setStatusMessage(e.getMessage());
        }
        context.getResultSender().lastResult(results);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

