/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.internal.operation.OperationHistoryManager;
import org.apache.geode.management.internal.operation.OperationPerformer;
import org.apache.geode.management.internal.operation.OperationState;
import org.apache.geode.management.internal.operation.RebalanceOperationPerformer;
import org.apache.geode.management.internal.operation.RestoreRedundancyPerformer;
import org.apache.geode.management.operation.RebalanceOperation;
import org.apache.geode.management.operation.RestoreRedundancyRequest;
import org.apache.geode.management.runtime.OperationResult;

@Experimental
public class OperationManager
implements AutoCloseable {
    private final Map<Class<? extends ClusterManagementOperation>, OperationPerformer> performers;
    private final OperationHistoryManager historyManager;
    private final Executor executor;
    private final InternalCache cache;

    public OperationManager(InternalCache cache, OperationHistoryManager historyManager) {
        this.cache = cache;
        this.historyManager = historyManager;
        this.executor = LoggingExecutors.newThreadOnEachExecute((String)"CMSOpPerformer");
        this.performers = new ConcurrentHashMap<Class<? extends ClusterManagementOperation>, OperationPerformer>();
        this.registerOperation(RebalanceOperation.class, new RebalanceOperationPerformer());
        this.registerOperation(RestoreRedundancyRequest.class, new RestoreRedundancyPerformer());
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> void registerOperation(Class<A> operationClass, OperationPerformer<A, V> performer) {
        this.performers.put(operationClass, performer);
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationState<A, V> submit(A op) {
        OperationPerformer performer = this.getPerformer(op);
        if (performer == null) {
            throw new IllegalArgumentException(String.format("%s is not supported.", op.getClass().getSimpleName()));
        }
        String opId = this.historyManager.recordStart(op, this.cache.getMyId().toString());
        OperationState operationState = this.historyManager.get(opId);
        CompletableFuture.supplyAsync(() -> performer.perform(this.cache, op), this.executor).whenComplete((result, exception) -> {
            Throwable cause = exception == null ? null : exception.getCause();
            this.historyManager.recordEnd(opId, (OperationResult)result, cause);
        });
        return operationState;
    }

    private <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationPerformer<A, V> getPerformer(A op) {
        return this.performers.get(op.getClass());
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationState<A, V> get(String opId) {
        return this.historyManager.get(opId);
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> List<OperationState<A, V>> list(A opType) {
        return this.historyManager.list(opType);
    }

    @Override
    public void close() {
    }
}

