/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;

public class NotificationListenerMBeanServerInterceptor
extends DefaultMBeanServerInterceptor {
    private final Map wrappers = new HashMap();
    private final Map objectNames = new HashMap();

    public String getType() {
        return "notificationlistener";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = null;
            Map map = this.wrappers;
            synchronized (map) {
                ListenerWrapperKey key = new ListenerWrapperKey(listener, metadata.getObjectName());
                wrapper = (ListenerWrapper)this.wrappers.get(key);
                if (wrapper == null) {
                    wrapper = new ListenerWrapper(listener, metadata.getObjectName());
                    this.wrappers.put(key, wrapper);
                    wrapper.increaseReferenceCount();
                } else {
                    wrapper.increaseReferenceCount();
                }
                HashSet<ListenerWrapperKey> keys = (HashSet<ListenerWrapperKey>)this.objectNames.get(metadata.getObjectName());
                if (keys == null) {
                    keys = new HashSet<ListenerWrapperKey>();
                    this.objectNames.put(metadata.getObjectName(), keys);
                    keys.add(key);
                } else {
                    keys.add(key);
                }
            }
            super.addNotificationListener(metadata, wrapper, filter, handback);
        } else {
            super.addNotificationListener(metadata, listener, filter, handback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = null;
            Map map = this.wrappers;
            synchronized (map) {
                ListenerWrapperKey key = new ListenerWrapperKey(listener, metadata.getObjectName());
                wrapper = (ListenerWrapper)this.wrappers.remove(key);
                if (wrapper == null) {
                    throw new ListenerNotFoundException("Could not find listener " + listener);
                }
                wrapper.resetReferenceCount();
                Set keys = (Set)this.objectNames.get(metadata.getObjectName());
                keys.remove(key);
                if (keys.isEmpty()) {
                    this.objectNames.remove(metadata.getObjectName());
                }
            }
            super.removeNotificationListener(metadata, wrapper);
        } else {
            super.removeNotificationListener(metadata, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ListenerWrapper wrapper = null;
            Map map = this.wrappers;
            synchronized (map) {
                ListenerWrapperKey key = new ListenerWrapperKey(listener, metadata.getObjectName());
                wrapper = (ListenerWrapper)this.wrappers.get(key);
                if (wrapper == null) {
                    throw new ListenerNotFoundException("Could not find listener " + listener);
                }
                wrapper.decreaseReferenceCount();
                if (wrapper.getReferenceCount() == 0) {
                    this.wrappers.remove(key);
                    Set keys = (Set)this.objectNames.get(metadata.getObjectName());
                    keys.remove(key);
                    if (keys.isEmpty()) {
                        this.objectNames.remove(metadata.getObjectName());
                    }
                }
            }
            super.removeNotificationListener(metadata, wrapper, filter, handback);
        } else {
            super.removeNotificationListener(metadata, listener, filter, handback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        if (this.isEnabled()) {
            if (operation == 5) {
                Map map = this.wrappers;
                synchronized (map) {
                    Set keys = (Set)this.objectNames.remove(metadata.getObjectName());
                    if (keys != null) {
                        Iterator iterator = keys.iterator();
                        while (iterator.hasNext()) {
                            ListenerWrapperKey key = (ListenerWrapperKey)iterator.next();
                            ListenerWrapper wrapper = (ListenerWrapper)this.wrappers.remove(key);
                            wrapper.resetReferenceCount();
                        }
                    }
                }
            }
            super.registration(metadata, operation);
        } else {
            super.registration(metadata, operation);
        }
    }

    public Map getNotificationListenerWrappers() {
        return this.wrappers;
    }

    public int getNotificationListenerWrapperReferenceCount(Object wrapper) {
        ListenerWrapper listenerWrapper = (ListenerWrapper)wrapper;
        return listenerWrapper.getReferenceCount();
    }

    public Map getObjectNames() {
        return this.objectNames;
    }

    private static class ListenerWrapperKey {
        private final NotificationListener listener;
        private final ObjectName objectName;

        private ListenerWrapperKey(NotificationListener listener, ObjectName objectName) {
            this.listener = listener;
            this.objectName = objectName;
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerWrapperKey that = (ListenerWrapperKey)obj;
            if (!this.listener.equals(that.listener)) {
                return false;
            }
            return this.objectName.equals(that.objectName);
        }

        public int hashCode() {
            int result = this.listener.hashCode();
            result = 29 * result + this.objectName.hashCode();
            return result;
        }
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private final NotificationListener listener;
        private final ObjectName objectName;
        private int referenceCount;

        private ListenerWrapper(NotificationListener listener, ObjectName name) {
            this.listener = listener;
            this.objectName = name;
        }

        public void handleNotification(Notification notification, Object handback) {
            Object src = notification.getSource();
            if (!(src instanceof ObjectName)) {
                notification.setSource(this.objectName);
            }
            NotificationListener listener = this.getTargetListener();
            listener.handleNotification(notification, handback);
        }

        private NotificationListener getTargetListener() {
            return this.listener;
        }

        private int increaseReferenceCount() {
            return ++this.referenceCount;
        }

        private int decreaseReferenceCount() {
            return --this.referenceCount;
        }

        public void resetReferenceCount() {
            this.referenceCount = 0;
        }

        private int getReferenceCount() {
            return this.referenceCount;
        }

        public int hashCode() {
            return this.getTargetListener().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerWrapper wrapper = (ListenerWrapper)obj;
            return this.getTargetListener().equals(wrapper.getTargetListener());
        }

        public String toString() {
            return this.getTargetListener().toString();
        }
    }
}

