/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.partition;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.EntryOperation;
import org.apache.geode.cache.FixedPartitionResolver;
import org.apache.geode.internal.cache.PartitionedRegion;

public class BucketTargetingFixedResolver
implements FixedPartitionResolver {
    public Object getRoutingObject(EntryOperation opDetails) {
        int targetBucketId = (Integer)opDetails.getCallbackArgument();
        Map.Entry<String, Integer[]> targetPartition = this.getFixedPartition(opDetails);
        return targetBucketId - targetPartition.getValue()[0];
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void close() {
    }

    public String getPartitionName(EntryOperation opDetails, @Deprecated Set targetPartitions) {
        Map.Entry<String, Integer[]> targetPartition = this.getFixedPartition(opDetails);
        return targetPartition.getKey();
    }

    protected Map.Entry<String, Integer[]> getFixedPartition(EntryOperation opDetails) {
        PartitionedRegion region = (PartitionedRegion)opDetails.getRegion();
        int targetBucketId = (Integer)opDetails.getCallbackArgument();
        ConcurrentMap partitions = region.getPartitionsMap();
        return partitions.entrySet().stream().filter(entry -> this.withinPartition((Map.Entry<String, Integer[]>)entry, targetBucketId)).findFirst().get();
    }

    private boolean withinPartition(Map.Entry<String, Integer[]> entry, int bucketId) {
        int startingBucket = entry.getValue()[0];
        int endingBucket = startingBucket + entry.getValue()[1];
        return startingBucket <= bucketId && bucketId < endingBucket;
    }
}

