/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.runtime.RuntimeInfo;

@Experimental
public class EntityGroupInfo<T extends AbstractConfiguration<R>, R extends RuntimeInfo> {
    private T configuration;
    private List<R> runtimeInfo = new ArrayList<R>();

    public EntityGroupInfo() {
    }

    public EntityGroupInfo(T configuration) {
        this(configuration, Collections.emptyList());
    }

    public EntityGroupInfo(T configuration, List<R> runtimeInfo) {
        this.configuration = configuration;
        this.runtimeInfo = runtimeInfo;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(T configuration) {
        this.configuration = configuration;
    }

    public List<R> getRuntimeInfo() {
        return this.runtimeInfo;
    }

    public void setRuntimeInfo(List<R> runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
    }

    @JsonIgnore
    public Links getLinks() {
        if (this.configuration == null) {
            return null;
        }
        return ((AbstractConfiguration)this.configuration).getLinks();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityGroupInfo that = (EntityGroupInfo)o;
        return Objects.equals(this.configuration, that.configuration) && Objects.equals(this.runtimeInfo, that.runtimeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.runtimeInfo);
    }

    public String toString() {
        return "ConfigurationResult{configuration=" + this.configuration + ", runtimeInfo=" + this.runtimeInfo + '}';
    }
}

