/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.cache.wan.internal.GatewayReceiverImpl;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.wan.GatewayReceiverException;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.GatewayReceiverCreation;

public class GatewayReceiverFactoryImpl
implements GatewayReceiverFactory {
    private int startPort = 5000;
    private int endPort = 5500;
    private int timeBetPings = 60000;
    private int socketBuffSize = 524288;
    private String bindAdd = "";
    private String hostnameForSenders = "";
    private boolean manualStart = false;
    private final List<GatewayTransportFilter> filters = new ArrayList<GatewayTransportFilter>();
    private InternalCache cache;

    public GatewayReceiverFactoryImpl() {
    }

    public GatewayReceiverFactoryImpl(InternalCache cache) {
        this.cache = cache;
    }

    @Override
    public GatewayReceiverFactory addGatewayTransportFilter(GatewayTransportFilter filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public GatewayReceiverFactory removeGatewayTransportFilter(GatewayTransportFilter filter) {
        this.filters.remove(filter);
        return this;
    }

    @Override
    public GatewayReceiverFactory setMaximumTimeBetweenPings(int time) {
        this.timeBetPings = time;
        return this;
    }

    @Override
    public GatewayReceiverFactory setStartPort(int port) {
        this.startPort = port;
        return this;
    }

    @Override
    public GatewayReceiverFactory setEndPort(int port) {
        this.endPort = port;
        return this;
    }

    @Override
    public GatewayReceiverFactory setSocketBufferSize(int size) {
        this.socketBuffSize = size;
        return this;
    }

    @Override
    public GatewayReceiverFactory setBindAddress(String address) {
        this.bindAdd = address;
        return this;
    }

    @Override
    public GatewayReceiverFactory setHostnameForSenders(String address) {
        this.hostnameForSenders = address;
        return this;
    }

    @Override
    public GatewayReceiverFactory setManualStart(boolean start) {
        this.manualStart = start;
        return this;
    }

    @Override
    public GatewayReceiver create() {
        if (this.startPort > this.endPort) {
            throw new IllegalStateException("Please specify either start port a value which is less than end port.");
        }
        if (this.cache.getGatewayReceivers() != null && !this.cache.getGatewayReceivers().isEmpty()) {
            throw new IllegalStateException("A Gateway Receiver already exists on this member.");
        }
        GatewayReceiver recv = null;
        if (this.cache instanceof GemFireCacheImpl) {
            recv = new GatewayReceiverImpl(this.cache, this.startPort, this.endPort, this.timeBetPings, this.socketBuffSize, this.bindAdd, this.filters, this.hostnameForSenders, this.manualStart);
            this.cache.addGatewayReceiver(recv);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYRECEIVER_CREATE, recv);
            if (!this.manualStart) {
                try {
                    recv.start();
                }
                catch (IOException ioe) {
                    throw new GatewayReceiverException("Exception occurred while starting gateway receiver", ioe);
                }
            }
        } else if (this.cache instanceof CacheCreation) {
            recv = new GatewayReceiverCreation(this.cache, this.startPort, this.endPort, this.timeBetPings, this.socketBuffSize, this.bindAdd, this.filters, this.hostnameForSenders, this.manualStart);
            this.cache.addGatewayReceiver(recv);
        }
        return recv;
    }
}

