/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnThreadingCondition
extends SpringBootCondition {
    OnThreadingCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnThreading.class.getName());
        Threading threading = (Threading)((Object)attributes.get("value"));
        return this.getMatchOutcome(context.getEnvironment(), threading);
    }

    private ConditionOutcome getMatchOutcome(Environment environment2, Threading threading) {
        String name = threading.name();
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnThreading.class, new Object[0]);
        if (threading.isActive(environment2)) {
            return ConditionOutcome.match(message.foundExactly(name));
        }
        return ConditionOutcome.noMatch(message.didNotFind(name).atAll());
    }
}

